/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.tileentity.TileArtefactPensive;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArtefactPensive
extends BlockContainer {
    protected static final AxisAlignedBB PENSIVE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    private static final PropertyBool EMPTY = PropertyBool.func_177716_a((String)"empty");
    private static int MAX_XP = 1395;

    public BlockArtefactPensive() {
        super(Material.field_151571_B);
        this.func_149715_a(0.5f);
        this.func_149711_c(0.5f);
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileArtefactPensive();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!(world.func_175625_s(pos) instanceof TileArtefactPensive)) {
            return false;
        }
        TileArtefactPensive tilePensive = (TileArtefactPensive)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            player.func_71023_q(tilePensive.getStoredXP());
            tilePensive.setStoredXP(0);
            world.func_180501_a(pos, state.func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(true)), 2);
        } else {
            int currentPlayerXP = player.field_71067_cb;
            if (tilePensive.getStoredXP() < MAX_XP) {
                int maxAmountToAdd = MAX_XP - tilePensive.getStoredXP();
                if (maxAmountToAdd >= currentPlayerXP) {
                    tilePensive.setStoredXP(tilePensive.getStoredXP() + currentPlayerXP);
                    this.removePlayerXP(player, tilePensive.getStoredXP() + currentPlayerXP);
                } else {
                    tilePensive.setStoredXP(tilePensive.getStoredXP() + maxAmountToAdd);
                    this.removePlayerXP(player, maxAmountToAdd);
                }
                if (currentPlayerXP > 0) {
                    world.func_180501_a(pos, state.func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(false)), 2);
                }
                tilePensive.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
            }
        }
        return true;
    }

    public void removePlayerXP(EntityPlayer player, int amount) {
        player.field_71068_ca -= amount;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{EMPTY}).build();
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EMPTY) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(meta == 0));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.func_176221_a(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PENSIVE_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

