/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.packet.ASPacketHandler;
import com.windanesz.ancientspellcraft.packet.PacketMushroomActivation;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.tileentity.TileEntityMagicMushroom;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public abstract class BlockMagicMushroom
extends BlockBush
implements ITileEntityProvider {
    protected static final AxisAlignedBB MUSH_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
    public static final int GROWTH_STAGES = 8;
    public static final int GROWTH_STAGE_DURATION = 2;
    public static final int POTION_DURATION = 140;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);

    public BlockMagicMushroom() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
        this.func_149711_c(4.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(null);
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileentity;
        TileEntity tileEntity = tileentity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (tileentity instanceof TileEntityMagicMushroom) {
            return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(((TileEntityMagicMushroom)tileentity).getAge()));
        }
        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void placeAt(World world, BlockPos lowerPos, int flags) {
        world.func_180501_a(lowerPos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)), flags);
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return super.func_180671_f(worldIn, pos, state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        PacketMushroomActivation.Message msg = new PacketMushroomActivation.Message(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, pos, entity);
        ASPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
        if (this.applyEffect(world, (Block)this, pos, state, entity)) {
            world.func_175698_g(pos);
        }
    }

    public static boolean applySpecialMushroomEffects(World world, @Nullable Block block, BlockPos pos, IBlockState state, Entity target) {
        if (block instanceof BlockMagicMushroom) {
            return BlockMagicMushroom.applySpecialMushroomEffects(world, block, pos, state, target);
        }
        return false;
    }

    public abstract boolean applyHarmfulEffect(World var1, @Nullable Block var2, BlockPos var3, DamageSource var4, float var5, IBlockState var6, @Nullable EntityLivingBase var7, EntityLivingBase var8, float var9);

    public boolean applyBeneficialEffect(World world, @Nullable Block block, BlockPos pos, DamageSource source, float damage, IBlockState state, @Nullable EntityLivingBase caster, EntityLivingBase target, float potency) {
        return false;
    }

    public boolean applyEffect(World world, @Nullable Block block, BlockPos pos, IBlockState state, Entity target) {
        if (block == null && !((block = world.func_180495_p(pos).func_177230_c()) instanceof BlockMagicMushroom)) {
            return false;
        }
        EntityLivingBase casterEntity = null;
        DamageSource source = DamageSource.field_76367_g;
        float damage = ASSpells.fairy_ring.getProperty("damage").floatValue();
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityMagicMushroom) {
            float potency = ((TileEntityMagicMushroom)tileentity).potency;
            damage *= potency;
            EntityLivingBase caster = ((TileEntityMagicMushroom)tileentity).getCaster();
            casterEntity = ((TileEntityMagicMushroom)tileentity).getCaster();
            if (target instanceof EntityLivingBase) {
                if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target) || block == ASBlocks.MUSHROOM_HEALING) {
                    return this.applyBeneficialEffect(world, block, pos, source, damage, state, caster, (EntityLivingBase)target, potency);
                }
                return this.applyHarmfulEffect(world, block, pos, source, damage, state, caster, (EntityLivingBase)target, potency);
            }
        }
        return false;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return super.func_185496_a(state, source, pos).func_191194_a(state.func_191059_e(source, pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityMagicMushroom();
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185915_l();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this == ASBlocks.MUSHROOM_FORCE ? BlockRenderLayer.TRANSLUCENT : super.func_180664_k();
    }

    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == WizardryBlocks.thorns) {
            BlockMagicMushroom.applySpecialMushroomEffects(event.getWorld(), null, event.getPos(), event.getWorld().func_180495_p(event.getPos()), event.getEntity());
        }
    }

    public static BlockMagicMushroom getRandomMushroom(float rareChance) {
        return BlockMagicMushroom.getRandomMushroom(rareChance, 0.0f);
    }

    public static BlockMagicMushroom getRandomMushroom(float rareChance, float epicChance) {
        return BlockMagicMushroom.getRandomMushroom(rareChance, epicChance, MushroomType.ANY);
    }

    public static BlockMagicMushroom getRandomMushroom(float rareChance, float epicChance, MushroomType type) {
        ArrayList<Block> mushrooms = new ArrayList<Block>();
        if (type == MushroomType.ANY || type == MushroomType.COMBAT) {
            mushrooms.add(ASBlocks.MUSHROOM_FIRE);
            mushrooms.add(ASBlocks.MUSHROOM_ICE);
            mushrooms.add(ASBlocks.MUSHROOM_POISON);
            mushrooms.add(ASBlocks.MUSHROOM_WITHER);
            mushrooms.add(ASBlocks.MUSHROOM_FORCE);
            mushrooms.add(ASBlocks.MUSHROOM_SHOCKING);
        }
        if (type == MushroomType.ANY || type == MushroomType.BUFF) {
            mushrooms.add(ASBlocks.MUSHROOM_HEALING);
        }
        ArrayList<Block> rareMushrooms = new ArrayList<Block>();
        if (type == MushroomType.ANY || type == MushroomType.COMBAT) {
            rareMushrooms.add(ASBlocks.MUSHROOM_MIND);
            rareMushrooms.add(ASBlocks.MUSHROOM_EXPLOSIVE);
        }
        if (type == MushroomType.ANY || type == MushroomType.BUFF) {
            rareMushrooms.add(ASBlocks.MUSHROOM_CLEANSING);
        }
        ArrayList<Block> epicMushrooms = new ArrayList<Block>();
        if (type == MushroomType.ANY || type == MushroomType.BUFF) {
            epicMushrooms.add(ASBlocks.MUSHROOM_EMPOWERING);
        }
        if (!epicMushrooms.isEmpty() && AncientSpellcraft.rand.nextFloat() > 1.0f - epicChance) {
            return (BlockMagicMushroom)((Object)epicMushrooms.get(AncientSpellcraft.rand.nextInt(epicMushrooms.size())));
        }
        if (!rareMushrooms.isEmpty() && AncientSpellcraft.rand.nextFloat() < rareChance) {
            return (BlockMagicMushroom)((Object)rareMushrooms.get(AncientSpellcraft.rand.nextInt(rareMushrooms.size())));
        }
        return (BlockMagicMushroom)((Object)mushrooms.get(AncientSpellcraft.rand.nextInt(mushrooms.size())));
    }

    public static boolean tryPlaceMushroom(World world, BlockPos pos, EntityLivingBase caster, BlockMagicMushroom mushroom, int lifetime) {
        return BlockMagicMushroom.tryPlaceMushroom(world, pos, caster, mushroom, lifetime, new SpellModifiers());
    }

    public static boolean tryPlaceMushroom(World world, BlockPos pos, EntityLivingBase caster, BlockMagicMushroom mushroom, int lifetime, SpellModifiers modifiers) {
        if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos)) {
            if (lifetime == -1) {
                if (caster != null) {
                    if (!BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)pos)) {
                        lifetime = 120;
                    }
                } else {
                    lifetime = 120;
                }
            }
            mushroom.placeAt(world, pos, 3);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityMagicMushroom) {
                TileEntityMagicMushroom tileMushroom = (TileEntityMagicMushroom)tileentity;
                tileMushroom.setLifetime(lifetime);
                if (caster != null) {
                    tileMushroom.setCaster(caster);
                }
                tileMushroom.potency = modifiers.get("potency");
                tileMushroom.durationMultiplier = modifiers.get(WizardryItems.blast_upgrade);
                tileMushroom.sync();
            }
            return true;
        }
        return false;
    }

    public static enum MushroomType {
        BUFF,
        COMBAT,
        ANY;

    }
}

