/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.gui;

import com.windanesz.ancientspellcraft.spell.Contingency;
import com.windanesz.ancientspellcraft.spell.MetaSpellBuff;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.gui.GuiSpellInfo;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiWarlockSpellBook
extends GuiSpellInfo {
    private int xSize;
    private int ySize;
    private ItemSpellBook book;
    private Spell spell;

    public GuiWarlockSpellBook(ItemStack stack) {
        super(288, 180);
        if (!(stack.func_77973_b() instanceof ItemSpellBook)) {
            throw new ClassCastException("Cannot create spell book GUI for item that does not extend ItemSpellBook!");
        }
        this.book = (ItemSpellBook)stack.func_77973_b();
        this.spell = Spell.byMetadata((int)stack.func_77952_i());
    }

    protected void drawForegroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(), null);
        if (discovered) {
            this.field_146289_q.func_78276_b(this.getSpell().getDisplayName(), left + 17, top + 15, 0);
            String spellType = this.spell instanceof MetaSpellBuff ? I18n.func_135052_a((String)"spelltype.metamagic", (Object[])new Object[0]) : (this.spell instanceof Contingency ? I18n.func_135052_a((String)"spelltype.contingency", (Object[])new Object[0]) : this.spell.getType().getDisplayName());
            this.field_146289_q.func_78276_b(spellType, left + 17, top + 26, 0x777777);
        } else {
            this.field_146297_k.field_71464_q.func_78276_b(SpellGlyphData.getGlyphName((Spell)this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 17, top + 15, 0);
            this.field_146297_k.field_71464_q.func_78276_b(this.getSpell().getType().getDisplayName(), left + 17, top + 26, 0x777777);
        }
        String tier = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.tier", (Object[])new Object[]{this.getSpell().getTier() == Tier.NOVICE ? "\u00a77" + this.getSpell().getTier().getDisplayName() : this.getSpell().getTier().getDisplayNameWithFormatting()});
        this.field_146289_q.func_78276_b(tier, left + 17, top + 45, 0);
        String element = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.element", (Object[])new Object[]{TextFormatting.RED + I18n.func_135052_a((String)"gui.ancientspellcraft:element.warlock", (Object[])new Object[0])});
        if (!discovered) {
            element = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.element_undiscovered", (Object[])new Object[0]);
        }
        this.field_146289_q.func_78276_b(element, left + 17, top + 57, 0);
        String manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost", (Object[])new Object[]{this.getSpell().getCost()});
        if (this.getSpell().isContinuous) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_continuous", (Object[])new Object[]{this.getSpell().getCost()});
        }
        if (!discovered) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_undiscovered", (Object[])new Object[0]);
        }
        this.field_146289_q.func_78276_b(manaCost, left + 17, top + 69, 0);
        if (discovered) {
            this.field_146289_q.func_78279_b(this.getSpell().getDescription(), left + 17, top + 83, 118, 0);
        } else {
            this.field_146297_k.field_71464_q.func_78279_b(SpellGlyphData.getGlyphDescription((Spell)this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 17, top + 83, 118, 0);
        }
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ResourceLocation getTexture() {
        return this.book.getGuiTexture(this.spell);
    }
}

