/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.renderer;

import com.windanesz.ancientspellcraft.entity.construct.EntityArcaneBarrier;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderArcaneBarrierEventBased {
    private static final float EXPANSION_TIME = 3.0f;
    public static List<EntityArcaneBarrier> barrierList = new ArrayList<EntityArcaneBarrier>();
    public static List<EntityArcaneBarrier> barrierListNext = new ArrayList<EntityArcaneBarrier>();

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            RenderArcaneBarrierEventBased.renderBarriers((EntityPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
            if (Minecraft.func_71410_x().field_71439_g.func_70644_a(ASPotions.wizard_shield)) {
                RenderArcaneBarrierEventBased.renderWizardShield((EntityPlayer)player, Float.valueOf(event.getPartialTicks()));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            RenderArcaneBarrierEventBased.renderBarriers(event.getEntityPlayer(), event.getPartialRenderTick());
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerEvent(RenderPlayerEvent.Post event) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a(ASPotions.wizard_shield)) {
            RenderArcaneBarrierEventBased.renderWizardShield(event.getEntityPlayer(), Float.valueOf(event.getPartialRenderTick()));
        }
    }

    private static void renderWizardShield(EntityPlayer player, Float partialTicks) {
        PotionEffect effect = player.func_70660_b(ASPotions.wizard_shield);
        float amp = 0.3f;
        if (effect != null) {
            amp = Math.max(0.3f, Math.min(1.8f, (float)effect.func_76458_c() * 0.1f + 0.1f));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)0.0, (double)(player.func_70093_af() ? (double)player.func_70047_e() - 0.3 : (double)(player.func_70047_e() - 0.6f)), (double)0.0);
        float latStep = 0.15707964f;
        float longStep = 0.15707964f;
        float pulse = MathHelper.func_76126_a((float)(((float)player.field_70173_aa + partialTicks.floatValue()) / 10.0f));
        float r = 0.85f;
        float g = 0.85f + 0.05f * pulse;
        float b = 1.0f;
        float radius = 1.3f;
        RenderArcaneBarrierEventBased.drawSphere((0.1f + amp) * 0.12f + radius - 0.1f - 0.025f * pulse, latStep, longStep, true, r, g, b, Math.min(0.5f, 0.5f * amp));
        RenderArcaneBarrierEventBased.drawSphere((0.1f + amp) * 0.12f + radius + 0.3f - 0.1f - 0.025f * -pulse, latStep, longStep, false, 1.0f, 1.0f, 1.0f, 0.3f * amp);
        RenderArcaneBarrierEventBased.drawSphere((0.1f + amp) * 0.12f + radius + 0.3f - 0.025f * -pulse, latStep, longStep, false, r, g, b, 0.2f * amp);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void renderBarriers(EntityPlayer player, float partialTicks) {
        if (player.field_70173_aa < 40) {
            barrierListNext = new ArrayList<EntityArcaneBarrier>();
            barrierList = barrierListNext;
        }
        for (EntityArcaneBarrier barrier : barrierListNext) {
            if (barrier == null || barrier.field_71093_bK != player.field_71093_bK) continue;
            double clientPosX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double clientPosY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double clientPosZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            double barrierPosX = barrier.field_70169_q + (barrier.field_70165_t - barrier.field_70169_q) * (double)partialTicks;
            double barrierPosY = barrier.field_70167_r + (barrier.field_70163_u - barrier.field_70167_r) * (double)partialTicks;
            double barrierPosZ = barrier.field_70166_s + (barrier.field_70161_v - barrier.field_70166_s) * (double)partialTicks;
            double x = barrierPosX - clientPosX;
            double y = barrierPosY - clientPosY;
            double z = barrierPosZ - clientPosZ;
            RenderArcaneBarrierEventBased.doRender(barrier, x, y, z, barrier.field_70177_z, partialTicks);
        }
        barrierListNext = new ArrayList<EntityArcaneBarrier>(barrierList);
    }

    private static void doRender(EntityArcaneBarrier entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float latStep = 0.15707964f;
        float longStep = 0.15707964f;
        float pulse = MathHelper.func_76126_a((float)(((float)entity.field_70173_aa + partialTicks) / 10.0f));
        float r = entity.getColour().getR();
        float g = entity.getColour().getG();
        float b = entity.getColour().getB();
        float radius = entity.getRadius();
        float a = 0.5f;
        if ((float)entity.field_70173_aa > (float)entity.lifetime - 3.0f) {
            radius *= 1.0f + 0.2f * ((float)entity.field_70173_aa + partialTicks - ((float)entity.lifetime - 3.0f)) / 3.0f;
            a *= Math.max(0.0f, 1.0f - ((float)entity.field_70173_aa + partialTicks - ((float)entity.lifetime - 3.0f)) / 3.0f);
        } else if ((float)entity.field_70173_aa < 3.0f) {
            radius *= 1.0f - (3.0f - (float)entity.field_70173_aa - partialTicks) / 3.0f;
            a *= 1.0f - (3.0f - (float)entity.field_70173_aa - partialTicks) / 3.0f;
        }
        RenderArcaneBarrierEventBased.drawSphere(radius - 0.1f - 0.025f * pulse, latStep, longStep, true, r, g, b, a);
        RenderArcaneBarrierEventBased.drawSphere(radius - 0.1f - 0.025f * pulse, latStep, longStep, false, 1.0f, 1.0f, 1.0f, a);
        RenderArcaneBarrierEventBased.drawSphere(radius, latStep, longStep, false, r, g, b, 0.7f * a);
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static void drawSphere(float radius, float latStep, float longStep, boolean inside, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        boolean goingUp = inside;
        buffer.func_181662_b(0.0, goingUp ? (double)(-radius) : (double)radius, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        for (float longitude = (float)(-Math.PI); longitude <= (float)Math.PI; longitude += longStep) {
            for (float theta = 1.5707964f - latStep; theta >= -1.5707964f + latStep; theta -= latStep) {
                float latitude = goingUp ? -theta : theta;
                float hRadius = radius * MathHelper.func_76134_b((float)latitude);
                float vy = radius * MathHelper.func_76126_a((float)latitude);
                float vx = hRadius * MathHelper.func_76126_a((float)longitude);
                float vz = hRadius * MathHelper.func_76134_b((float)longitude);
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
                vx = hRadius * MathHelper.func_76126_a((float)(longitude + longStep));
                vz = hRadius * MathHelper.func_76134_b((float)(longitude + longStep));
                buffer.func_181662_b((double)vx, (double)vy, (double)vz).func_181666_a(r, g, b, a).func_181675_d();
            }
            buffer.func_181662_b(0.0, goingUp ? (double)radius : (double)(-radius), 0.0).func_181666_a(r, g, b, a).func_181675_d();
            goingUp = !goingUp;
        }
        tessellator.func_78381_a();
    }
}

