/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.google.common.collect.EvictingQueue;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;

public class ClassWeaponData {
    public static final int MAX_RECENT_ENEMIES = 10;
    public static final String RECENT_ENEMIES_TAG = "recent_enemies";
    public static final IStoredVariable<List<UUID>> RECENT_ENEMIES = new IStoredVariable.StoredVariable("recent_enemies", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.DIMENSION_CHANGE);

    private ClassWeaponData() {
    }

    public static void init() {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{RECENT_ENEMIES});
    }

    public static void trackRecentEnemy(EntityPlayer player, EntityLivingBase entity) {
        if (entity != null) {
            WizardData data = WizardData.get((EntityPlayer)player);
            Queue<UUID> recentEnemies = ClassWeaponData.getRecentEnemies(data);
            recentEnemies.add(entity.func_110124_au());
            ArrayList<UUID> enemyList = new ArrayList<UUID>(recentEnemies);
            data.setVariable(RECENT_ENEMIES, enemyList);
        }
    }

    public static int getRecentHitCount(EntityPlayer player, EntityLivingBase entity) {
        WizardData data = WizardData.get((EntityPlayer)player);
        Queue<UUID> recentEnemies = ClassWeaponData.getRecentEnemies(data);
        return (int)recentEnemies.stream().filter(e -> e == entity.func_110124_au()).count();
    }

    public static Queue<UUID> getRecentEnemies(WizardData data) {
        if (data.getVariable(RECENT_ENEMIES) == null) {
            ArrayList resultSet = new ArrayList();
            data.setVariable(RECENT_ENEMIES, resultSet);
            return EvictingQueue.create((int)10);
        }
        EvictingQueue result = EvictingQueue.create((int)10);
        List resultList = (List)data.getVariable(RECENT_ENEMIES);
        if (!resultList.isEmpty()) {
            result.addAll(resultList);
        }
        return result;
    }
}

