/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.windanesz.ancientspellcraft.ritual.Ritual;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RitualDiscoveryData {
    private static final String RITUAL_DISCOVERY_DATA_TAG = "ritual_discovery_data";
    private static final String RITUAL_TAG = "rituals";
    public static final IStoredVariable<NBTTagCompound> RITUAL_DISCOVERY_DATA = IStoredVariable.StoredVariable.ofNBT((String)"ritual_discovery_data", (Persistence)Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<List<Location>> fds = new IStoredVariable.StoredVariable("stoneCirclePos", s -> NBTExtras.listToNBT((Collection)s, Location::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, Location::fromNBT)), Persistence.ALWAYS);

    public static void init() {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{RITUAL_DISCOVERY_DATA});
    }

    public static boolean hasRitualBeenDiscovered(EntityPlayer player, Ritual ritual) {
        return true;
    }

    public static List<String> getKnownRituals(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        return RitualDiscoveryData.getKnownRituals(data, player);
    }

    public static List<String> getKnownRituals(WizardData data, EntityPlayer player) {
        NBTTagCompound compound;
        ArrayList<String> stringList = new ArrayList<String>();
        if (data != null && (compound = (NBTTagCompound)data.getVariable(RITUAL_DISCOVERY_DATA)) != null && compound.func_74764_b(RITUAL_TAG)) {
            NBTTagList tagList = (NBTTagList)compound.func_74781_a(RITUAL_TAG);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                String s = tag.func_74779_i("r" + i);
                stringList.add(s);
            }
        }
        return stringList;
    }

    public static void addKnownRitual(EntityPlayer player, Ritual ritual) {
        String newRitual;
        WizardData data = WizardData.get((EntityPlayer)player);
        List<String> stringList = RitualDiscoveryData.getKnownRituals(data, player);
        if (!stringList.contains(newRitual = Ritual.getRegistryNameString(ritual))) {
            NBTTagList ritualList = new NBTTagList();
            stringList.add(newRitual);
            for (int i = 0; i < stringList.size(); ++i) {
                String s = stringList.get(i);
                if (s == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("r" + i, s);
                ritualList.func_74742_a((NBTBase)tag);
            }
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74782_a(RITUAL_TAG, (NBTBase)ritualList);
            data.setVariable(RITUAL_DISCOVERY_DATA, (Object)comp);
            data.sync();
        }
    }
}

