/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.ai;

import com.windanesz.ancientspellcraft.entity.ai.IShieldUser;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.util.EnumHand;

public class EntityAIBlockWithShield<T extends EntityLiving>
extends EntityAIBase {
    private final T battlemage;
    private EntityLivingBase target;
    private static final float SAFE_MELEE_DISTANCE = 4.5f;
    private final int maxReactionDelay = 5;
    private final int maxReactionDelayBow = 30;
    private int reactionDelayTicks = 0;
    private static final int SHIELD_WITHDRAW_DELAY = 40;
    private int shieldWithdrawTicks = 0;

    public EntityAIBlockWithShield(T shieldUser) {
        this.battlemage = shieldUser;
    }

    public boolean func_75250_a() {
        return this.canExecute(e -> e.func_70089_S() && this.shouldDefendFrom((EntityLivingBase)e));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canExecute(Predicate<EntityLivingBase> defendFrom) {
        if (this.target == null) {
            if (!this.hasShieldInOffhand()) return false;
            if (((IShieldUser)this.battlemage).getShieldDisabledTick() > 0) return false;
            if (this.shieldWithdrawTicks > 0) return true;
            if (this.getAttackTarget().map(defendFrom::test).orElse(false) == false) return false;
            return true;
        }
        if (!this.hasShieldInOffhand()) return false;
        if (((IShieldUser)this.battlemage).getShieldDisabledTick() > 0) return false;
        if (!this.target.func_70089_S()) return false;
        if (!this.getAttackTarget().isPresent()) return false;
        if (this.shieldWithdrawTicks > 0) return true;
        if (this.getAttackTarget().map(t -> t.equals((Object)this.target) && this.shouldDefendFrom(this.target)).orElse(false) == false) return false;
        return true;
    }

    private boolean shouldDefendFrom(@Nullable EntityLivingBase e) {
        return e != null && this.isPlayerOrTargetsThisNpc(e) && (e.field_82175_bq && this.battlemage.func_70032_d((Entity)e) < 4.0f || this.isAimingWithBow(e));
    }

    private boolean isPlayerOrTargetsThisNpc(EntityLivingBase e) {
        if (e instanceof EntityPlayer) {
            return true;
        }
        if (e instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)e;
            return living.func_70638_az() != null && living.func_70638_az().equals(this.battlemage);
        }
        return false;
    }

    public void func_75249_e() {
        if (!this.battlemage.func_184587_cr()) {
            this.init();
        }
    }

    private void init() {
        this.target = this.getAttackTarget().orElse(null);
        this.reactionDelayTicks = new Random(((EntityLiving)this.battlemage).field_70170_p.func_82737_E()).nextInt(this.target != null && this.isAimingWithBow(this.target) ? 30 : 5);
        this.shieldWithdrawTicks = 40;
    }

    public final void func_75251_c() {
        this.target = null;
        this.reactionDelayTicks = 0;
    }

    public final void func_75246_d() {
        double distanceToEntity;
        if (this.reactionDelayTicks > 0) {
            --this.reactionDelayTicks;
            return;
        }
        if (!this.shouldDefendFrom(this.target)) {
            --this.shieldWithdrawTicks;
            return;
        }
        this.battlemage.func_184598_c(EnumHand.OFF_HAND);
        if (this.target != null && (!this.shouldCloseOnTarget(distanceToEntity = this.battlemage.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v)) || this.isAimingWithBow(this.target))) {
            this.startBlocking();
            this.battlemage.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, (double)0.7f);
        }
    }

    private void startBlocking() {
        this.battlemage.func_184598_c(EnumHand.OFF_HAND);
    }

    private Optional<EntityLivingBase> getAttackTarget() {
        return this.battlemage.func_70638_az() != null ? Optional.of(this.battlemage.func_70638_az()) : Optional.ofNullable(this.battlemage.func_70643_av());
    }

    protected boolean shouldCloseOnTarget(double distanceToEntity) {
        double attackDistance = (double)((EntityLiving)this.battlemage).field_70130_N / 2.0 + (double)this.getTarget().field_70130_N / 2.0 + 4.5;
        return distanceToEntity > attackDistance * attackDistance || !this.battlemage.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    public final EntityLivingBase getTarget() {
        return this.target;
    }

    private boolean hasShieldInOffhand() {
        return this.battlemage.func_184592_cb().func_77973_b().isShield(this.battlemage.func_184592_cb(), this.battlemage);
    }

    private boolean isAimingWithBow(EntityLivingBase entity) {
        return EntityAIBlockWithShield.isBow(entity.func_184614_ca().func_77973_b()) && entity.func_184587_cr() && entity.func_184600_cs() == EnumHand.MAIN_HAND || EntityAIBlockWithShield.isBow(entity.func_184592_cb().func_77973_b()) && entity.func_184587_cr() && entity.func_184600_cs() == EnumHand.OFF_HAND;
    }

    public static boolean isBow(Item stack) {
        return stack instanceof ItemBow;
    }
}

