/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.google.common.base.Predicate;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackRangedBowNoStrafing;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellWithCost;
import com.windanesz.ancientspellcraft.entity.ai.EntitySummonAIFollowOwner;
import com.windanesz.ancientspellcraft.entity.living.Vector;
import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemBattlemageSword;
import com.windanesz.ancientspellcraft.item.ItemGuardianBlade;
import com.windanesz.ancientspellcraft.item.ItemIceShield;
import com.windanesz.ancientspellcraft.item.ItemSageTome;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.AwakenTome;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.projectile.EntityConjuredArrow;
import electroblob.wizardry.entity.projectile.EntityFlamecatcherArrow;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemFlamecatcher;
import electroblob.wizardry.item.ItemFlamingAxe;
import electroblob.wizardry.item.ItemFrostAxe;
import electroblob.wizardry.item.ItemSpectralBow;
import electroblob.wizardry.item.ItemSpectralSword;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimatedItem
extends EntitySummonedCreature
implements ISpellCaster,
IRangedAttackMob {
    public static final String ANIMATED_ITEM_TRANSLATION_KEY = "entity.ancientspellcraft:animated_item.nameplate";
    private static final DataParameter<Boolean> HAS_ARMOUR = EntityDataManager.func_187226_a(EntityAnimatedItem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> CONTINUOUS_SPELL = EntityDataManager.func_187226_a(EntityAnimatedItem.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> SPELL_COUNTER = EntityDataManager.func_187226_a(EntityAnimatedItem.class, (DataSerializer)DataSerializers.field_187192_b);
    private final double AISpeed = 1.0;
    private final EntityAIAttackSpellWithCost<EntityAnimatedItem> spellAttackAI = new EntityAIAttackSpellWithCost<EntityAnimatedItem>(this, 0.1f, 15.0f, 30, 50, false);
    private final EntityAIAttackSpellWithCost<EntityAnimatedItem> tomeAttackAI = new EntityAIAttackSpellWithCost<EntityAnimatedItem>(this, 0.1f, 15.0f, 30, 50, true);
    private final EntityAIAttackRangedBowNoStrafing<EntityAnimatedItem> bowAttackAI = new EntityAIAttackRangedBowNoStrafing<EntityAnimatedItem>(this, 0.1, 40, 25.0f);
    private final EntityAIAttackMelee meleeAI = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
    private ItemStack arrows = ItemStack.field_190927_a;

    public EntityAnimatedItem(World world) {
        super(world);
        this.func_184641_n(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_ARMOUR, (Object)false);
        this.field_70180_af.func_187214_a(CONTINUOUS_SPELL, (Object)"ebwizardry:none");
        this.field_70180_af.func_187214_a(SPELL_COUNTER, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, this.getTargetSelector()));
    }

    public Predicate<Entity> getTargetSelector() {
        return entity -> !entity.func_82150_aj() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_()) && this.isValidTarget((Entity)entity);
    }

    public void func_70071_h_() {
        block11: {
            super.func_70071_h_();
            if (this.field_70173_aa % 60 == 0 && this.func_70638_az() == null && this.getCaster() != null) {
                this.func_70661_as().func_75499_g();
                this.func_70661_as().func_75492_a(this.getCaster().field_70165_t, this.getCaster().field_70163_u, this.getCaster().field_70161_v, 1.0);
            }
            if (this.field_70173_aa > 20 && (this.getCaster() == null || this.getCaster().field_70128_L || !this.hasArmour() && this.func_184614_ca().func_190926_b() || this.hasArmour() && this.lostArmour())) {
                this.func_70106_y();
                this.onDespawn();
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (this.func_184582_a(slot).func_190926_b() || !(this.func_184582_a(slot).func_77973_b() instanceof IConjuredItem)) continue;
                this.func_184582_a(slot).func_77972_a(1, (EntityLivingBase)this);
            }
            if (this.func_70027_ad() && this.func_184614_ca().func_77973_b() == ItemSpectralSword.func_150898_a((Block)Blocks.field_150335_W) && !this.field_70170_p.field_72995_K) {
                EntityTNTPrimed tnt = new EntityTNTPrimed(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (EntityLivingBase)this);
                tnt.func_184534_a(20);
                this.field_70170_p.func_72838_d((Entity)tnt);
                this.field_70170_p.func_184148_a((EntityPlayer)null, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                this.func_70106_y();
            }
            if (this.func_184614_ca().func_77973_b() instanceof ItemWand) {
                if (this.field_70173_aa % 20 == 0) {
                    ((ItemWand)this.func_184614_ca().func_77973_b()).consumeMana(this.func_184614_ca(), 3, (EntityLivingBase)this);
                }
                if (((ItemWand)this.func_184614_ca().func_77973_b()).isManaEmpty(this.func_184614_ca())) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, WizardrySounds.ENTITY_LIGHTNING_ARROW_HIT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.func_70106_y();
                    this.onDespawn();
                }
            }
            if (!this.field_70170_p.field_72995_K) break block11;
            Vec3d height = this.func_174791_d().func_72441_c(0.0, 1.3, 0.0);
            if (!this.hasArmour()) {
                Vec3d offset = this.func_70040_Z().func_72432_b().func_186678_a(0.5).func_72441_c(0.5 * (this.field_70146_Z.nextDouble() - 0.5), 0.5 * (this.field_70146_Z.nextDouble() - 0.5), 0.5 * (this.field_70146_Z.nextDouble() - 0.5));
                height = height.func_178787_e(offset);
                Vec3d rightHand = Vector.toRectangular(Math.toRadians(this.field_70761_aq + 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
                rightHand = rightHand.func_178787_e(height);
                for (int i = 0; i < 20; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(rightHand).time(40).clr(0.2f, 1.0f, 0.8f).spawn(this.field_70170_p);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)0.7f * (this.field_70146_Z.nextDouble() - 0.5) + this.field_70165_t, 1.5 * (this.field_70146_Z.nextDouble() - 0.5) + this.field_70163_u + (double)this.func_70047_e() - 0.3, (double)0.7f * (this.field_70146_Z.nextDouble() - 0.5) + this.field_70161_v).time(20).clr(0.2f, 1.0f, 0.8f).spawn(this.field_70170_p);
                }
            }
        }
    }

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c();
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean taken = false;
        if (!player.field_70170_p.field_72995_K && player == this.getCaster()) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                this.func_70099_a(this.arrows, 1.0f);
                this.setArrows(ItemStack.field_190927_a);
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!player.func_184582_a(slot).func_190926_b() || this.func_184582_a(slot).func_190926_b()) continue;
                ItemStack armourToTake = this.func_184582_a(slot).func_77946_l();
                player.func_184201_a(slot, armourToTake);
                this.func_184201_a(slot, ItemStack.field_190927_a);
                taken = true;
            }
        }
        if (taken) {
            return true;
        }
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public boolean lostArmour() {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (this.func_184582_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean hasArmour() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ARMOUR);
    }

    public void setHasArmour(boolean hasArmour) {
        this.field_70180_af.func_187227_b(HAS_ARMOUR, (Object)hasArmour);
    }

    public void setCaster(EntityLivingBase caster) {
        super.setCaster(caster);
    }

    public boolean hasAnimation() {
        return false;
    }

    public void onDespawn() {
        this.revertToItemForm();
        super.onDespawn();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N).time(0).clr(0.2f, 1.0f, 0.8f).shaded(true).spawn(this.field_70170_p);
            }
        }
    }

    @Nonnull
    public List<Spell> getSpells() {
        if (this.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
            Spell spell = ((ISpellCastingItem)this.func_184614_ca().func_77973_b()).getCurrentSpell(this.func_184614_ca());
            int maxTier = 1;
            if (this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)this.getCaster()), (Item)ASItems.charm_spectral_tome)) {
                ++maxTier;
            }
            int finalMaxTier = maxTier;
            return Arrays.stream(((ISpellCastingItem)this.func_184614_ca().func_77973_b()).getSpells(this.func_184614_ca())).filter(s -> s.getTier().level <= finalMaxTier).collect(Collectors.toList());
        }
        return Collections.singletonList(Spells.none);
    }

    public SpellModifiers getModifiers() {
        return new SpellModifiers();
    }

    public Spell getContinuousSpell() {
        return Spell.get((String)((String)this.field_70180_af.func_187225_a(CONTINUOUS_SPELL)));
    }

    public void setContinuousSpell(Spell spell) {
        this.field_70180_af.func_187227_b(CONTINUOUS_SPELL, (Object)spell.getRegistryName().toString());
    }

    public int getSpellCounter() {
        return (Integer)this.field_70180_af.func_187225_a(SPELL_COUNTER);
    }

    public void setSpellCounter(int count) {
        this.field_70180_af.func_187227_b(SPELL_COUNTER, (Object)count);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == WizardryPotions.frost || potioneffectIn.func_188419_a() == MobEffects.field_188423_x || potioneffectIn.func_188419_a() == WizardryPotions.mind_control) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            if (!this.func_184614_ca().func_190926_b() && !this.hasArmour()) {
                return new TextComponentTranslation(ANIMATED_ITEM_TRANSLATION_KEY, new Object[]{this.getCaster().func_70005_c_(), this.func_184614_ca().func_82833_r()});
            }
            return new TextComponentTranslation(ANIMATED_ITEM_TRANSLATION_KEY, new Object[]{this.getCaster().func_70005_c_(), super.func_145748_c_()});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.damageItem(amount);
        return super.func_70097_a(source, amount);
    }

    protected void func_70675_k(float damage) {
        damage /= 4.0f;
        damage = Math.max(damage, 1.0f);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (this.func_184582_a(slot).func_190926_b() || !((stack = this.func_184582_a(slot)).func_77973_b() instanceof ItemArmor)) continue;
            stack.func_77972_a((int)damage, (EntityLivingBase)this);
        }
    }

    protected void damageItem(float damage) {
        damage /= 2.0f;
        damage = Math.max(damage, 1.0f);
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_184614_ca().func_77972_a((int)damage, (EntityLivingBase)this);
        }
    }

    public void func_70645_a(DamageSource cause) {
        Item heldItem = this.func_184614_ca().func_77973_b();
        if (heldItem == Item.func_150898_a((Block)Blocks.field_150335_W)) {
            if (!this.field_70170_p.field_72995_K) {
                EntityTNTPrimed tnt = new EntityTNTPrimed(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (EntityLivingBase)this);
                tnt.func_184534_a(0);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                this.field_70170_p.func_72838_d((Entity)tnt);
                this.field_70170_p.func_184148_a((EntityPlayer)null, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else if (heldItem == Items.field_151079_bi) {
            if (!this.field_70170_p.field_72995_K && this.getCaster() instanceof EntityPlayer) {
                EntityEnderPearl entityenderpearl = new EntityEnderPearl(this.getCaster().field_70170_p, (EntityLivingBase)((EntityPlayer)this.getCaster()));
                entityenderpearl.func_70107_b(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                this.field_70170_p.func_72838_d((Entity)entityenderpearl);
            }
        } else if (heldItem instanceof ItemPotion && PotionUtils.func_185191_c((ItemStack)this.func_184614_ca()) != PotionTypes.field_185229_a) {
            if (!this.field_70170_p.field_72995_K) {
                EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionUtils.func_185191_c((ItemStack)this.func_184614_ca())));
                entitypotion.func_70107_b(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                this.field_70170_p.func_72838_d((Entity)entitypotion);
            }
        } else if (this.func_184614_ca().func_77973_b() instanceof ItemIceShield) {
            ItemIceShield.explodeShield(this.field_70170_p, (EntityLivingBase)this, this.func_184614_ca());
        } else {
            this.revertToItemForm();
        }
        super.func_70645_a(cause);
    }

    public void revertToItemForm() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemGuardianBlade) {
                if (this.getCaster() instanceof EntityPlayer) {
                    List<ItemStack> charm = ASBaublesIntegration.getEquippedArtefactStacks((EntityPlayer)this.getCaster(), ItemArtefact.Type.CHARM);
                    if (charm.isEmpty()) {
                        ASBaublesIntegration.setArtefactToSlot((EntityPlayer)this.getCaster(), this.func_184614_ca().func_77946_l(), ItemArtefact.Type.CHARM);
                        return;
                    }
                    if (!ASUtils.giveStackToPlayer((EntityPlayer)this.getCaster(), this.func_184614_ca().func_77946_l())) {
                        this.func_70099_a(this.func_184614_ca(), 1.0f);
                        return;
                    }
                }
                return;
            }
            if (this.func_184614_ca().func_77973_b() instanceof ItemSageTome) {
                if (this.getCaster() instanceof EntityPlayer) {
                    AwakenTome.removeController((EntityPlayer)this.getCaster());
                    ASUtils.giveStackToPlayer((EntityPlayer)this.getCaster(), this.func_184614_ca().func_77946_l());
                    return;
                }
                this.func_70099_a(this.func_184614_ca(), 1.0f);
            }
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                boolean shouldDropItem = true;
                if (this.getCaster() instanceof EntityPlayer && !this.func_184582_a(slot).func_190926_b() && WandHelper.getUpgradeLevel((ItemStack)this.func_184582_a(slot), (Item)ASItems.soulbound_upgrade) > 0) {
                    boolean bl = shouldDropItem = !ASUtils.giveStackToPlayer((EntityPlayer)this.getCaster(), this.func_184582_a(slot));
                }
                if (shouldDropItem && !this.func_184582_a(slot).func_190926_b() && !(this.func_184582_a(slot).func_77973_b() instanceof IConjuredItem)) {
                    this.func_70099_a(this.func_184582_a(slot), 1.0f);
                }
                this.func_184201_a(slot, ItemStack.field_190927_a);
            }
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                this.func_70099_a(this.arrows, 1.0f);
                this.setArrows(ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        ItemStack stack = this.func_184614_ca();
        Item item = this.func_184614_ca().func_77973_b();
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        if (i > 0 && entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
        }
        if (!stack.func_190926_b() && entityIn instanceof EntityLivingBase) {
            EntityLivingBase livingTarget = (EntityLivingBase)entityIn;
            int j = EnchantmentHelper.func_90036_a((EntityLivingBase)this);
            if (j > 0) {
                entityIn.func_70015_d(j * 4);
            }
            int flamingLevel = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.flaming_weapon, (ItemStack)stack);
            if (item instanceof ItemFlamingAxe) {
                ++flamingLevel;
            }
            if (flamingLevel > 0 && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)livingTarget)) {
                livingTarget.func_70015_d(flamingLevel * 4);
            }
            int iceLevel = EnchantmentHelper.func_77506_a((Enchantment)WizardryEnchantments.freezing_weapon, (ItemStack)stack);
            if (item instanceof ItemFrostAxe) {
                ++iceLevel;
            }
            if (iceLevel > 0 && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)livingTarget)) {
                livingTarget.func_70690_d(new PotionEffect(WizardryPotions.frost, iceLevel * 200, 0));
            }
        }
        this.func_174815_a((EntityLivingBase)this, entityIn);
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_184614_ca().func_77972_a(1, (EntityLivingBase)this);
        }
        return flag;
    }

    public int getAnimationColour(float animationProgress) {
        return 16762368;
    }

    public boolean func_70093_af() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean hasRangedAttack() {
        return false;
    }

    public void setItemType(String itemType) {
    }

    private void setCombatTask() {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
        this.field_70714_bg.func_85156_a(this.spellAttackAI);
        this.field_70714_bg.func_85156_a(this.bowAttackAI);
        if (this.func_184614_ca().func_77973_b() instanceof ISpellCastingItem && !(this.func_184614_ca().func_77973_b() instanceof ItemBattlemageSword)) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemSageTome) {
                int sentienceUpgrades = WandHelper.getUpgradeLevel((ItemStack)this.func_184614_ca(), (Item)ASItems.sentience_upgrade);
                if (sentienceUpgrades > 0) {
                    EntitySummonAIFollowOwner task = new EntitySummonAIFollowOwner((EntityCreature)this, 1.0, 10.0f, 2.0f);
                    this.field_70714_bg.func_75776_a(5, (EntityAIBase)task);
                }
                if (sentienceUpgrades > 1) {
                    this.field_70714_bg.func_75776_a(1, this.tomeAttackAI);
                } else {
                    this.field_70714_bg.func_75776_a(1, this.spellAttackAI);
                }
            } else {
                this.field_70714_bg.func_75776_a(1, this.spellAttackAI);
            }
        } else if (this.func_184614_ca().func_77973_b() instanceof ItemBow && (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)this.func_184614_ca()) > 0 || this.func_184614_ca().func_77973_b() instanceof ItemSpectralBow || !this.arrows.func_190926_b() && this.arrows.func_77973_b() instanceof ItemArrow || this.func_184614_ca().func_77973_b() instanceof ItemFlamecatcher)) {
            this.field_70714_bg.func_75776_a(1, this.bowAttackAI);
        } else {
            if (this.func_184614_ca().func_77973_b() instanceof ItemPotion) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", (double)-0.9f, 2));
                this.func_70606_j(this.func_110138_aP());
            }
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.meleeAI);
        }
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.func_184614_ca().func_77973_b() instanceof ItemFlamecatcher) {
            float velocity = 0.8f;
            velocity = (velocity * velocity + velocity * 2.0f) / 3.0f;
            EntityFlamecatcherArrow arrow = new EntityFlamecatcherArrow(this.field_70170_p);
            arrow.aim((EntityLivingBase)this, 3.0f * velocity);
            this.field_70170_p.func_72838_d((Entity)arrow);
            this.func_184614_ca().func_77972_a(this.func_184614_ca().func_77958_k() / 4, (EntityLivingBase)this);
            return;
        }
        Optional<EntityArrow> arrowOptional = this.getArrow(distanceFactor);
        if (arrowOptional.isPresent()) {
            EntityArrow entityArrow = arrowOptional.get();
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                entityArrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityArrow);
            }
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrowOptional.get().field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityArrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityArrow);
        }
    }

    protected Optional<EntityArrow> getArrow(float distanceFactor) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)this.func_184614_ca()) > 0 || this.func_184614_ca().func_77973_b() instanceof ItemSpectralBow) {
            EntityArrow entityArrow = ((ItemArrow)Items.field_151032_g).func_185052_a(this.field_70170_p, new ItemStack(Items.field_151032_g), (EntityLivingBase)this);
            if (this.func_184614_ca().func_77973_b() instanceof ItemSpectralBow) {
                entityArrow = new EntityConjuredArrow(this.field_70170_p, (EntityLivingBase)this);
            }
            entityArrow.func_190547_a((EntityLivingBase)this, distanceFactor);
            return Optional.of(entityArrow);
        }
        if (!(this.arrows.func_77973_b() instanceof ItemArrow)) {
            this.setCombatTask();
            return Optional.empty();
        }
        ItemStack arrow = this.arrows.func_77946_l();
        arrow.func_190920_e(1);
        this.arrows.func_190918_g(1);
        EntityArrow entityArrow = ((ItemArrow)arrow.func_77973_b()).func_185052_a(this.field_70170_p, arrow, (EntityLivingBase)this);
        entityArrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        if (arrow.func_77973_b() instanceof ItemArrow) {
            this.arrows.func_190918_g(1);
        }
        return Optional.of(entityArrow);
    }

    public void setArrows(ItemStack arrows) {
        this.arrows = arrows;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        NBTTagCompound arrowTag = new NBTTagCompound();
        this.arrows.func_77955_b(arrowTag);
        nbt.func_74782_a("arrows", (NBTBase)arrowTag);
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("arrows")) {
            this.arrows = new ItemStack(nbt.func_74775_l("arrows"));
        }
        super.func_70037_a(nbt);
    }
}

