/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellImproved;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageMelee;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageSpellcasting;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBlockWithShield;
import com.windanesz.ancientspellcraft.entity.ai.IShieldUser;
import com.windanesz.ancientspellcraft.entity.living.IArmourClassWizard;
import com.windanesz.ancientspellcraft.entity.living.ICustomCooldown;
import com.windanesz.ancientspellcraft.item.ItemRareScroll;
import com.windanesz.ancientspellcraft.item.ItemWarlockOrb;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.Covenant;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntityAIAttackSpell;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.misc.WildcardTradeList;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class EntityClassWizard
extends EntityWizard
implements ICustomCooldown,
IArmourClassWizard,
IShieldUser {
    private static final DataParameter<Integer> SHIELD_DISABLED_TICK = EntityDataManager.func_187226_a(EntityClassWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private EntityPlayer customer;
    private static final ResourceLocation BATTLEMAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_battlemage");
    private static final ResourceLocation SAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_sage");
    private static final ResourceLocation WARLOCK_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_warlock");
    public ItemWizardArmour.ArmourClass armourClass = ItemWizardArmour.ArmourClass.BATTLEMAGE;
    private MerchantRecipeList trades;
    private int timeUntilReset;
    private boolean updateRecipes;
    protected int cooldown;
    private int battlemageMercenaryRemainingDuration;
    private static final DataParameter<Integer> EVIL_WIZARD_ARMOUR_CLASS = EntityDataManager.func_187226_a(EntityClassWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(4);
    private EntityAIAttackSpellImproved<EntityClassWizard> spellCastingAIImproved = new EntityAIAttackSpellImproved<EntityClassWizard>(this, 0.5, 14.0f, 30, 80);
    private final EntityAIBattlemageMelee entityAIBattlemageMelee = new EntityAIBattlemageMelee<EntityClassWizard>(this, 0.6, false);
    private final EntityAIBattlemageSpellcasting entityAIBattlemageSpellcasting = new EntityAIBattlemageSpellcasting<EntityClassWizard>(this, 0.6, 14.0f, 30, 50);

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public int incrementCooldown() {
        return this.cooldown++;
    }

    @Override
    public int decrementCooldown() {
        return this.cooldown--;
    }

    public EntityClassWizard(World world) {
        super(world);
        this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIAttackSpell);
        this.field_70714_bg.func_75776_a(3, this.spellCastingAIImproved);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageSpellcasting);
    }

    protected ResourceLocation func_184647_J() {
        ResourceLocation loot = super.func_184647_J();
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            loot = BATTLEMAGE_LOOT_TABLE;
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE) {
            loot = SAGE_LOOT_TABLE;
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
            loot = WARLOCK_LOOT_TABLE;
        }
        return loot;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EVIL_WIZARD_ARMOUR_CLASS, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_DISABLED_TICK, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityWizard.EntityAITradePlayer((EntityWizard)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityWizard.EntityAILookAtTradePlayer((EntityWizard)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityWizard.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, new EntityAIBlockWithShield<EntityClassWizard>(this));
        this.targetSelector = entity -> entity != this && entity != null && !entity.func_82150_aj() && !(entity instanceof EntityWizard) && AllyDesignationSystem.isValidTarget((Entity)this, (Entity)entity) && (entity instanceof IMob || entity instanceof ISummonedCreature || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(entity.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(entity.getClass()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, this.targetSelector));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        NBTTagCompound nbt;
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.getElement() == null) {
            if (this.field_70146_Z.nextInt(10) > 2) {
                this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
            } else {
                this.setElement(Element.MAGIC);
            }
        }
        if (this.getArmourClass() == null || this.getArmourClass() == ItemWizardArmour.ArmourClass.WIZARD) {
            this.setArmourClass(ItemWizardArmour.ArmourClass.values()[this.field_70170_p.field_73012_v.nextInt(3) + 1]);
        }
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
            this.func_184201_a(slot, new ItemStack(ItemWizardArmour.getArmour((Element)element, (ItemWizardArmour.ArmourClass)this.getArmourClass(), (EntityEquipmentSlot)slot)));
        }
        switch (this.getArmourClass()) {
            case SAGE: {
                int n = 9;
            }
            case WARLOCK: {
                int n = 6;
            }
        }
        int spellCount = 4;
        Tier maxTier = IArmourClassWizard.populateSpells((EntityLiving)this, this.spells, element, this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE || this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK, spellCount, this.field_70146_Z);
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
            this.spells.remove(Spells.magic_missile);
            if (this.field_70146_Z.nextBoolean()) {
                this.spells.add(ASSpells.chaos_blast);
            }
            this.spells.add(ASSpells.chaos_orb);
        }
        ItemStack wand = new ItemStack(WizardryItems.getWand((Tier)maxTier, (Element)element));
        ArrayList<Spell> list = new ArrayList<Spell>(this.spells);
        list.add(Spells.heal);
        WandHelper.setSpells((ItemStack)wand, (Spell[])list.toArray(new Spell[5]));
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            ItemStack sword = new ItemStack(ASItems.battlemage_sword_master);
            NBTTagCompound nbt2 = sword.func_77978_p();
            if (nbt2 == null) {
                nbt2 = new NBTTagCompound();
            }
            nbt2.func_74778_a("element", element.name());
            sword.func_77982_d(nbt2);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, sword);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ASItems.battlemage_shield));
            this.setAITask(ItemWizardArmour.ArmourClass.BATTLEMAGE);
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
            wand = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ancientspellcraft", "warlock_orb_" + Tier.values()[this.field_70146_Z.nextInt(4)].toString().toLowerCase() + "_" + element.name().toLowerCase())));
            nbt = wand.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            wand.func_77982_d(nbt);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, wand);
            this.setAITask(ItemWizardArmour.ArmourClass.WIZARD);
        } else {
            wand = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ancientspellcraft", "sage_tome_" + Tier.values()[this.field_70146_Z.nextInt(4)].toString().toLowerCase() + "_" + element.name().toLowerCase())));
            nbt = wand.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            wand.func_77982_d(nbt);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, wand);
            this.setAITask(ItemWizardArmour.ArmourClass.WIZARD);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        return livingdata;
    }

    private void setAITask(ItemWizardArmour.ArmourClass armourClass) {
        if (armourClass == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.spellCastingAIImproved);
        } else {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageSpellcasting);
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageMelee);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getShieldDisabledTick() > 0) {
            this.decrementShieldDisabledTick();
        }
        if (this.battlemageMercenaryRemainingDuration > 0) {
            --this.battlemageMercenaryRemainingDuration;
        } else {
            Covenant.endAlliance(this);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.values()[(Integer)this.field_70180_af.func_187225_a(EVIL_WIZARD_ARMOUR_CLASS)];
    }

    @Override
    public void setArmourClass(ItemWizardArmour.ArmourClass armourClass) {
        this.field_70180_af.func_187227_b(EVIL_WIZARD_ARMOUR_CLASS, (Object)armourClass.ordinal());
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_()));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            if (textcomponentstring == null) {
                TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
                ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
                new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
            }
            return textcomponentstring;
        }
        if (this.getElement() == Element.MAGIC) {
            return this.getArmourClassNameFor(this.getArmourClass());
        }
        TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
        ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
        return new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
    }

    public SpellModifiers getModifiers() {
        return this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK ? this.getWarlockSpellModifiers() : super.getModifiers();
    }

    private SpellModifiers getWarlockSpellModifiers() {
        SpellModifiers modifiers = new SpellModifiers();
        if (this.func_184614_ca().func_77973_b() instanceof ItemWarlockOrb) {
            float potency = (float)(1.0 + (double)(((ItemWarlockOrb)this.func_184614_ca().func_77973_b()).tier.ordinal() + 1) * 0.15);
            modifiers.set("potency", potency, false);
        }
        return modifiers;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
        nbt.func_74768_a("armour_class", this.getArmourClass().ordinal());
        nbt.func_74768_a("battlemage_mercenary_remaining_duration", this.battlemageMercenaryRemainingDuration);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spells = (List)NBTExtras.NBTToList((NBTTagList)nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
        ItemWizardArmour.ArmourClass armourClass = ItemWizardArmour.ArmourClass.values()[nbt.func_74762_e("armour_class")];
        this.setArmourClass(armourClass);
        this.setAITask(armourClass);
        if (nbt.func_74764_b("battlemage_mercenary_remaining_duration")) {
            this.battlemageMercenaryRemainingDuration = nbt.func_74762_e("battlemage_mercenary_remaining_duration");
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.trades == null) {
            LootContext context;
            this.trades = new WildcardTradeList();
            ItemStack crystalStack = new ItemStack(WizardryItems.magic_crystal, 5);
            ArrayList bookTypeList = new ArrayList(ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemSpellBook).distinct().collect(Collectors.toList()));
            if (!bookTypeList.isEmpty()) {
                MerchantRecipe bookRecipe = new MerchantRecipe(new ItemStack((Item)bookTypeList.get(this.field_70146_Z.nextInt(bookTypeList.size())), 1, Short.MAX_VALUE), crystalStack);
                this.trades.add((Object)bookRecipe);
            }
            this.addRandomRecipes(3);
            if (this.field_70146_Z.nextBoolean()) {
                if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
                    ItemStack secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.APPRENTICE.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(8));
                    this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.APPRENTICE), secondItemToBuy, new ItemStack(ASItems.blank_rune), 0, 5));
                } else {
                    ItemStack secondItemToBuy;
                    ArrayList<Item> tablets = new ArrayList<Item>(Arrays.asList(ASItems.stone_tablet_small, ASItems.stone_tablet, ASItems.stone_tablet_large, ASItems.stone_tablet_grand));
                    Item tablet = (Item)tablets.get(this.field_70146_Z.nextInt(tablets.size()));
                    if (tablet == ASItems.stone_tablet_small) {
                        secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.NOVICE.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
                        this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.NOVICE), secondItemToBuy, new ItemStack(tablet), 0, 2));
                    } else if (tablet == ASItems.stone_tablet) {
                        secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.APPRENTICE.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
                        this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.APPRENTICE), secondItemToBuy, new ItemStack(tablet), 0, 1));
                    } else {
                        secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.ADVANCED.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(8));
                        this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.ADVANCED), secondItemToBuy, new ItemStack(tablet), 0, 1));
                    }
                }
            }
            String rarity = "uncommon";
            LootTable table = this.field_70170_p.func_184146_ak().func_186521_a(new ResourceLocation("ebwizardry", "subsets/" + rarity + "_artefacts"));
            List stacks = table.func_186462_a(this.field_70170_p.field_73012_v, context = new LootContext.Builder((WorldServer)this.field_70170_p).func_186469_a(0.0f).func_186471_a());
            if (!stacks.isEmpty()) {
                ItemStack secondItemToBuy = new ItemStack(WizardryItems.astral_diamond);
                this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.MASTER), secondItemToBuy, (ItemStack)stacks.get(0), 0, 1));
            }
        }
        return this.trades;
    }

    private void addRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            ItemStack itemToSell = ItemStack.field_190927_a;
            boolean itemAlreadySold = true;
            Tier tier = Tier.NOVICE;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.5 + 0.04 * (double)Math.max(this.trades.size(), 0);
                tier = Tier.APPRENTICE;
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = Tier.ADVANCED;
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                        tier = Tier.MASTER;
                    }
                }
                itemToSell = this.getRandomItemOfTier(tier);
                for (Object recipe : merchantrecipelist) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
                if (this.trades == null) continue;
                for (Object recipe : this.trades) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
            }
            if (itemToSell.func_190926_b()) {
                return;
            }
            ItemStack secondItemToBuy = tier == Tier.MASTER ? new ItemStack(WizardryItems.astral_diamond) : new ItemStack(WizardryItems.magic_crystal, tier.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
            merchantrecipelist.add((Object)new MerchantRecipe(this.getRandomPrice(tier), secondItemToBuy, itemToSell, 0, 1));
        }
        Collections.shuffle(merchantrecipelist);
        if (this.trades == null) {
            this.trades = new WildcardTradeList();
        }
        this.trades.addAll((Collection)merchantrecipelist);
    }

    private ItemStack getRandomPrice(Tier tier) {
        int value;
        Map map = Wizardry.settings.currencyItems;
        Pair itemName = map.keySet().toArray(new Pair[0])[this.field_70146_Z.nextInt(map.size())];
        Item item = (Item)Item.field_150901_e.func_82594_a(itemName.getLeft());
        short meta = (Short)itemName.getRight();
        if (item == null) {
            Wizardry.logger.warn("Invalid item in currency items: {}", (Object)itemName);
            item = Items.field_151166_bC;
            value = 6;
        } else {
            value = (Integer)map.get(itemName);
        }
        return new ItemStack(item, MathHelper.func_76125_a((int)((8 + tier.ordinal() * 16 + this.field_70146_Z.nextInt(9)) / value), (int)1, (int)64), (int)meta);
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.updateRecipes) {
                    for (MerchantRecipe merchantrecipe : this.trades) {
                        if (!merchantrecipe.func_82784_g() || merchantrecipe.func_77397_d().func_77973_b() instanceof ItemArtefact || merchantrecipe.func_77397_d().func_77973_b() instanceof ItemRareScroll && !(this.field_70146_Z.nextFloat() < 0.15f)) continue;
                        merchantrecipe.func_82783_a(1);
                    }
                    if (this.trades.size() < 12) {
                        this.addRandomRecipes(1);
                    }
                    this.updateRecipes = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    private ItemStack getRandomItemOfTier(Tier tier) {
        List spells = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, null, new SpellProperties.Context[]{SpellProperties.Context.TRADES}));
        List specialismSpells = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, this.getElement(), new SpellProperties.Context[]{SpellProperties.Context.TRADES}));
        spells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        specialismSpells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        switch (tier) {
            case NOVICE: {
                int randomiser = this.field_70146_Z.nextInt(5);
                if (randomiser < 4 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                }
                return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
            }
            case APPRENTICE: {
                int randomiser = this.field_70146_Z.nextInt(Wizardry.settings.discoveryMode ? 16 : 10);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 1);
                }
                if (randomiser < 10) {
                    EntityEquipmentSlot slot = InventoryUtils.ARMOUR_SLOTS[this.field_70146_Z.nextInt(InventoryUtils.ARMOUR_SLOTS.length)];
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getArmour((Element)this.getElement(), (EntityEquipmentSlot)slot));
                    }
                    return new ItemStack(WizardryItems.getArmour((Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)], (EntityEquipmentSlot)slot));
                }
                if (randomiser < 14) {
                    Item upgrade = this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE ? ASItems.crystal_silver_nugget : (this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE ? ASItems.enchanted_filament : ASItems.ethereal_essence);
                    return new ItemStack(upgrade, 3);
                }
                return new ItemStack(WizardryItems.identification_scroll);
            }
            case ADVANCED: {
                int randomiser = this.field_70146_Z.nextInt(18);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 2);
                }
                if (randomiser < 10) {
                    return new ItemStack(ASItems.transmutation_scroll, 1);
                }
                if (randomiser < 12) {
                    return new ItemStack(WizardryItems.grand_crystal, 1);
                }
                ArrayList upgrades = new ArrayList(WandHelper.getSpecialUpgrades());
                randomiser = this.field_70146_Z.nextInt(upgrades.size());
                return new ItemStack((Item)upgrades.get(randomiser));
            }
            case MASTER: {
                int randomiser;
                int n = randomiser = this.getElement() != Element.MAGIC ? this.field_70146_Z.nextInt(10) : 5 + this.field_70146_Z.nextInt(3);
                if (randomiser < 5 && this.getElement() != Element.MAGIC && !specialismSpells.isEmpty()) {
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.master_wand);
                }
                if (randomiser < 8) {
                    Item upgrade = this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE ? WizardryItems.crystal_silver_plating : (this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE ? WizardryItems.resplendent_thread : WizardryItems.ethereal_crystalweave);
                    return new ItemStack(upgrade, 1);
                }
                return new ItemStack(WizardryItems.arcane_tome, 1, 3);
            }
        }
        return new ItemStack(Blocks.field_150348_b);
    }

    public void func_70933_a(MerchantRecipe merchantrecipe) {
        merchantrecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(WizardrySounds.ENTITY_WIZARD_YES, this.func_70599_aP(), this.func_70647_i());
        if (this.func_70931_l_() != null) {
            WizardryAdvancementTriggers.wizard_trade.triggerFor(this.func_70931_l_());
            if (merchantrecipe.func_77397_d().func_77973_b() instanceof ItemSpellBook) {
                WizardData data;
                Spell spell = Spell.byMetadata((int)merchantrecipe.func_77397_d().func_77952_i());
                if (spell.getTier() == Tier.MASTER) {
                    WizardryAdvancementTriggers.buy_master_spell.triggerFor(this.func_70931_l_());
                }
                if ((data = WizardData.get((EntityPlayer)this.func_70931_l_())) != null && !MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(this.func_70931_l_(), spell, DiscoverSpellEvent.Source.PURCHASE)) && data.discoverSpell(spell)) {
                    data.sync();
                    if (!this.field_70170_p.field_72995_K && !this.func_70931_l_().func_184812_l_() && Wizardry.settings.discoveryMode) {
                        EntityUtils.playSoundAtPlayer((EntityPlayer)this.func_70931_l_(), (SoundEvent)WizardrySounds.MISC_DISCOVER_SPELL, (float)1.25f, (float)1.0f);
                        this.func_70931_l_().func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{spell.getNameForTranslationFormatted()}));
                    }
                }
            }
        }
        if (this.customer != null && (this.field_70146_Z.nextInt(5) > 0 || ItemArtefact.isArtefactActive((EntityPlayer)this.customer, (Item)WizardryItems.charm_haggler))) {
            this.timeUntilReset = 40;
            this.updateRecipes = true;
            if (this.func_70931_l_() != null) {
                this.func_70931_l_().func_70005_c_();
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected void func_190629_c(EntityLivingBase attacker) {
        attacker.func_70653_a((Entity)this, 0.1f, this.field_70165_t - attacker.field_70165_t, this.field_70161_v - attacker.field_70161_v);
        if (attacker.func_184614_ca().func_77973_b().canDisableShield(attacker.func_184614_ca(), this.func_184607_cu(), (EntityLivingBase)this, attacker)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        float f = 1.0f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
        if (this.field_70146_Z.nextFloat() < f) {
            this.setShieldDisabledTick(80);
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    protected void func_184590_k(float damage) {
        if (damage >= 3.0f && this.field_184627_bm.func_77973_b().isShield(this.field_184627_bm, (EntityLivingBase)this)) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            this.getShieldStack().func_77972_a(i, (EntityLivingBase)this);
            this.func_184598_c(EnumHand.OFF_HAND);
            if (this.getShieldStack().func_190926_b()) {
                this.setShieldStack(ItemStack.field_190927_a);
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    protected void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemstack = this.func_184586_b(this.func_184600_cs());
            if (ForgeHooks.canContinueUsing((ItemStack)this.field_184627_bm, (ItemStack)itemstack) || itemstack.func_77973_b().isShield(itemstack, (EntityLivingBase)this)) {
                this.field_184627_bm = itemstack;
            }
            if (itemstack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                    }
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (!(--this.field_184628_bn > 0 && 20000 - this.field_184628_bn <= Math.max(25, this.field_70146_Z.nextInt(100)) || this.field_70170_p.field_72995_K)) {
                    this.func_71036_o();
                }
            } else {
                this.func_184602_cy();
            }
        }
    }

    private ItemStack getShieldStack() {
        return this.func_184586_b(EnumHand.OFF_HAND);
    }

    public void setShieldStack(ItemStack stack) {
        this.func_184611_a(EnumHand.OFF_HAND, stack);
    }

    public void setShieldDisabledTick(int count) {
        this.field_70180_af.func_187227_b(SHIELD_DISABLED_TICK, (Object)count);
    }

    @Override
    public int getShieldDisabledTick() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD_DISABLED_TICK);
    }

    public void decrementShieldDisabledTick() {
        this.field_70180_af.func_187227_b(SHIELD_DISABLED_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(SHIELD_DISABLED_TICK) - 1));
    }

    public int getBattlemageMercenaryRemainingDuration() {
        return this.battlemageMercenaryRemainingDuration;
    }

    public void setBattlemageMercenaryRemainingDuration(int battlemageMercenaryRemainingDuration) {
        this.battlemageMercenaryRemainingDuration = battlemageMercenaryRemainingDuration;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184812_l_() && stack.func_77973_b() instanceof ItemSpellBook) {
            Spell spell = Spell.byMetadata((int)stack.func_77952_i());
            if (this.spells.size() >= 4 && spell.canBeCastBy((EntityLiving)this, true)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:spell_book.apply_to_wizard", new Object[]{this.func_145748_c_(), this.spells.set(this.field_70146_Z.nextInt(3) + 1, spell).getNameForTranslationFormatted(), spell.getNameForTranslationFormatted()}));
                return true;
            }
        }
        if (this.func_70089_S() && !this.isTrading() && !this.func_70631_g_() && !player.func_70093_af() && this.func_70638_az() != player) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return false;
    }
}

