/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellImproved;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageMelee;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBattlemageSpellcasting;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIBlockWithShield;
import com.windanesz.ancientspellcraft.entity.ai.IShieldUser;
import com.windanesz.ancientspellcraft.entity.living.IArmourClassWizard;
import com.windanesz.ancientspellcraft.entity.living.ICustomCooldown;
import com.windanesz.ancientspellcraft.item.ItemWarlockOrb;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityAIAttackSpell;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityEvilClassWizard
extends EntityEvilWizard
implements ICustomCooldown,
IArmourClassWizard,
IShieldUser {
    private static final DataParameter<Integer> SHIELD_DISABLED_TICK = EntityDataManager.func_187226_a(EntityEvilClassWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final ResourceLocation BATTLEMAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_battlemage");
    private static final ResourceLocation SAGE_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_sage");
    private static final ResourceLocation WARLOCK_LOOT_TABLE = new ResourceLocation("ancientspellcraft", "entities/evil_warlock");
    protected int cooldown;
    private static final DataParameter<Integer> EVIL_WIZARD_ARMOUR_CLASS = EntityDataManager.func_187226_a(EntityEvilClassWizard.class, (DataSerializer)DataSerializers.field_187192_b);
    private List<Spell> spells = new ArrayList<Spell>(4);
    private EntityAIAttackSpellImproved<EntityEvilClassWizard> spellCastingAIImproved = new EntityAIAttackSpellImproved<EntityEvilClassWizard>(this, 0.5, 14.0f, 30, 80);
    private final EntityAIBattlemageMelee entityAIBattlemageMelee = new EntityAIBattlemageMelee<EntityEvilClassWizard>(this, 0.6, false);
    private final EntityAIBattlemageSpellcasting entityAIBattlemageSpellcasting = new EntityAIBattlemageSpellcasting<EntityEvilClassWizard>(this, 0.6, 14.0f, 30, 50);

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public int incrementCooldown() {
        return this.cooldown++;
    }

    @Override
    public int decrementCooldown() {
        return this.cooldown--;
    }

    public EntityEvilClassWizard(World world) {
        super(world);
        this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIAttackSpell);
        this.field_70714_bg.func_75776_a(2, new EntityAIBlockWithShield<EntityEvilClassWizard>(this));
        this.field_70714_bg.func_75776_a(3, this.spellCastingAIImproved);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.entityAIBattlemageSpellcasting);
    }

    protected ResourceLocation func_184647_J() {
        ResourceLocation loot = super.func_184647_J();
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            loot = BATTLEMAGE_LOOT_TABLE;
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE) {
            loot = SAGE_LOOT_TABLE;
        } else if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
            loot = WARLOCK_LOOT_TABLE;
        }
        return loot;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EVIL_WIZARD_ARMOUR_CLASS, (Object)0);
        this.field_70180_af.func_187214_a(SHIELD_DISABLED_TICK, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.getElement() == null) {
            if (this.field_70146_Z.nextInt(10) > 2) {
                this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
            } else {
                this.setElement(Element.MAGIC);
            }
        }
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WIZARD) {
            this.setArmourClass(ItemWizardArmour.ArmourClass.values()[this.field_70170_p.field_73012_v.nextInt(3) + 1]);
        }
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
            this.func_184201_a(slot, new ItemStack(ItemWizardArmour.getArmour((Element)element, (ItemWizardArmour.ArmourClass)this.getArmourClass(), (EntityEquipmentSlot)slot)));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        switch (this.getArmourClass()) {
            case SAGE: {
                int n = 9;
            }
            case WARLOCK: {
                int n = 6;
            }
        }
        int spellCount = 4;
        Tier maxTier = IArmourClassWizard.populateSpells((EntityLiving)this, this.spells, element, this.getArmourClass() == ItemWizardArmour.ArmourClass.SAGE || this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK, spellCount, this.field_70146_Z);
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
            this.spells.remove(Spells.magic_missile);
            if (this.field_70146_Z.nextBoolean()) {
                this.spells.add(ASSpells.chaos_blast);
            }
            this.spells.add(ASSpells.chaos_orb);
        }
        ItemStack wand = new ItemStack(WizardryItems.getWand((Tier)maxTier, (Element)element));
        ArrayList<Spell> list = new ArrayList<Spell>(this.spells);
        list.add(Spells.heal);
        WandHelper.setSpells((ItemStack)wand, (Spell[])list.toArray(new Spell[5]));
        if (this.getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            ItemStack sword = new ItemStack(ASItems.battlemage_sword_master);
            NBTTagCompound nbt = sword.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74778_a("element", element.name());
            sword.func_77982_d(nbt);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, sword);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ASItems.battlemage_shield));
            this.setAITask(ItemWizardArmour.ArmourClass.BATTLEMAGE);
        } else {
            if (this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
                wand = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("ancientspellcraft", "warlock_orb_" + Tier.values()[this.field_70146_Z.nextInt(4)].toString().toLowerCase() + "_" + element.name().toLowerCase())));
                NBTTagCompound nbt = wand.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                nbt.func_74778_a("element", element.name());
                wand.func_77982_d(nbt);
            }
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, wand);
            this.setAITask(ItemWizardArmour.ArmourClass.WIZARD);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
        return livingdata;
    }

    private void setAITask(ItemWizardArmour.ArmourClass armourClass) {
        if (armourClass == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.spellCastingAIImproved);
        } else {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageSpellcasting);
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a == this.entityAIBattlemageMelee);
        }
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.values()[(Integer)this.field_70180_af.func_187225_a(EVIL_WIZARD_ARMOUR_CLASS)];
    }

    @Override
    public void setArmourClass(ItemWizardArmour.ArmourClass armourClass) {
        this.field_70180_af.func_187227_b(EVIL_WIZARD_ARMOUR_CLASS, (Object)armourClass.ordinal());
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_()));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            if (textcomponentstring == null) {
                TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
                ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
                new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
            }
            return textcomponentstring;
        }
        if (this.getElement() == Element.MAGIC) {
            return this.getArmourClassNameFor(this.getArmourClass());
        }
        TextComponentTranslation wizardName = new TextComponentTranslation("class_element." + this.getElement().func_176610_l() + ".wizard", new Object[0]);
        ITextComponent className = this.getArmourClassNameFor(this.getArmourClass());
        return new TextComponentTranslation("entity." + this.func_70022_Q() + "_combined.name", new Object[]{wizardName, className});
    }

    public SpellModifiers getModifiers() {
        return this.getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK ? this.getWarlockSpellModifiers() : super.getModifiers();
    }

    private SpellModifiers getWarlockSpellModifiers() {
        SpellModifiers modifiers = new SpellModifiers();
        if (this.func_184614_ca().func_77973_b() instanceof ItemWarlockOrb) {
            float potency = (float)(1.0 + (double)(((ItemWarlockOrb)this.func_184614_ca().func_77973_b()).tier.ordinal() + 1) * 0.15);
            modifiers.set("potency", potency, false);
        }
        return modifiers;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
        nbt.func_74768_a("armour_class", this.getArmourClass().ordinal());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.spells = (List)NBTExtras.NBTToList((NBTTagList)nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
        ItemWizardArmour.ArmourClass armourClass = ItemWizardArmour.ArmourClass.values()[nbt.func_74762_e("armour_class")];
        this.setArmourClass(armourClass);
        this.setAITask(armourClass);
        if (this.hasStructure) {
            this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIWander);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getShieldDisabledTick() > 0) {
            this.decrementShieldDisabledTick();
        }
    }

    protected void func_184608_ct() {
        if (this.func_184587_cr()) {
            ItemStack itemstack = this.func_184586_b(this.func_184600_cs());
            if (ForgeHooks.canContinueUsing((ItemStack)this.field_184627_bm, (ItemStack)itemstack) || itemstack.func_77973_b().isShield(itemstack, (EntityLivingBase)this)) {
                this.field_184627_bm = itemstack;
            }
            if (itemstack == this.field_184627_bm) {
                if (!this.field_184627_bm.func_190926_b()) {
                    this.field_184628_bn = ForgeEventFactory.onItemUseTick((EntityLivingBase)this, (ItemStack)this.field_184627_bm, (int)this.field_184628_bn);
                    if (this.field_184628_bn > 0) {
                        this.field_184627_bm.func_77973_b().onUsingTick(this.field_184627_bm, (EntityLivingBase)this, this.field_184628_bn);
                    }
                }
                if (this.func_184605_cv() <= 25 && this.func_184605_cv() % 4 == 0) {
                    this.func_184584_a(this.field_184627_bm, 5);
                }
                if (!(--this.field_184628_bn > 0 && 20000 - this.field_184628_bn <= Math.max(25, this.field_70146_Z.nextInt(100)) || this.field_70170_p.field_72995_K)) {
                    this.func_71036_o();
                }
            } else {
                this.func_184602_cy();
            }
        }
    }

    private ItemStack getShieldStack() {
        return this.func_184586_b(EnumHand.OFF_HAND);
    }

    public void setShieldStack(ItemStack stack) {
        this.func_184611_a(EnumHand.OFF_HAND, stack);
    }

    public void setShieldDisabledTick(int count) {
        this.field_70180_af.func_187227_b(SHIELD_DISABLED_TICK, (Object)count);
    }

    @Override
    public int getShieldDisabledTick() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD_DISABLED_TICK);
    }

    public void decrementShieldDisabledTick() {
        this.field_70180_af.func_187227_b(SHIELD_DISABLED_TICK, (Object)((Integer)this.field_70180_af.func_187225_a(SHIELD_DISABLED_TICK) - 1));
    }

    protected void func_190629_c(EntityLivingBase attacker) {
        attacker.func_70653_a((Entity)this, 0.1f, this.field_70165_t - attacker.field_70165_t, this.field_70161_v - attacker.field_70161_v);
        if (attacker.func_184614_ca().func_77973_b().canDisableShield(attacker.func_184614_ca(), this.func_184607_cu(), (EntityLivingBase)this, attacker)) {
            this.disableShield();
        }
    }

    private void disableShield() {
        float f = 1.0f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
        if (this.field_70146_Z.nextFloat() < f) {
            this.setShieldDisabledTick(80);
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    protected void func_184590_k(float damage) {
        if (damage >= 3.0f && this.field_184627_bm.func_77973_b().isShield(this.field_184627_bm, (EntityLivingBase)this)) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            this.getShieldStack().func_77972_a(i, (EntityLivingBase)this);
            this.func_184598_c(EnumHand.OFF_HAND);
            if (this.getShieldStack().func_190926_b()) {
                this.setShieldStack(ItemStack.field_190927_a);
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }
}

