/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.wizardryutils.entity.ai.EntityAIMinionOwnerHurtByTarget;
import com.windanesz.wizardryutils.entity.ai.EntityAIMinionOwnerHurtTarget;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.util.EntityUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityRemnantMinion
extends EntityRemnant
implements ISummonedCreature {
    private static final DataParameter<Boolean> SPAWN_PARTICLES = EntityDataManager.func_187226_a(EntityRemnantMinion.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lifetime = -1;
    private UUID casterUUID;

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public UUID func_184753_b() {
        return this.casterUUID;
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntityLivingBase getCaster() {
        return this.casterUUID == null ? null : (EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.casterUUID) instanceof EntityLivingBase ? (EntityLivingBase)EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.casterUUID) : null);
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public EntityRemnantMinion(World world) {
        super(world);
        this.field_70765_h = new AIMoveControl(this);
        this.field_70728_aV = 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWN_PARTICLES, (Object)true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityRemnantMinion.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMinionOwnerHurtByTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIMinionOwnerHurtTarget((EntityCreature)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setElement(Element.values()[1 + this.field_70146_Z.nextInt(Element.values().length - 1)]);
        this.setBoundOrigin(new BlockPos((Entity)this));
        return super.func_180482_a(difficulty, livingdata);
    }

    public BlockPos getBoundOrigin() {
        if (this.getCaster() != null) {
            return new BlockPos((Entity)this.getCaster());
        }
        return super.getBoundOrigin();
    }

    public float func_180484_a(BlockPos pos) {
        return 1.0f;
    }

    protected float func_70672_c(DamageSource source, float damage) {
        damage = super.func_70672_c(source, damage);
        if (source.func_82725_o()) {
            damage *= 0.25f;
        }
        return damage;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateDelegate();
    }

    public void onSpawn() {
    }

    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 2.0f), this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    public boolean hasParticleEffect() {
        return true;
    }

    public boolean hasAnimation() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES) != false || this.field_70173_aa > 20;
    }

    public void hideParticles() {
        this.field_70180_af.func_187227_b(SPAWN_PARTICLES, (Object)false);
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityRemnantMinion.this.func_70605_aq().func_75640_a() && EntityRemnantMinion.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityRemnantMinion.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityRemnantMinion.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityRemnantMinion.this.field_70146_Z.nextInt(15) - 7, EntityRemnantMinion.this.field_70146_Z.nextInt(11) - 5, EntityRemnantMinion.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityRemnantMinion.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityRemnantMinion.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                if (EntityRemnantMinion.this.func_70638_az() != null) break;
                EntityRemnantMinion.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityRemnantMinion host) {
            super((EntityLiving)host);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityRemnantMinion.this.field_70165_t;
                double d1 = this.field_75647_c - EntityRemnantMinion.this.field_70163_u;
                double d2 = this.field_75644_d - EntityRemnantMinion.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityRemnantMinion.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityRemnantMinion.this.field_70159_w *= 0.5;
                    EntityRemnantMinion.this.field_70181_x *= 0.5;
                    EntityRemnantMinion.this.field_70179_y *= 0.5;
                } else {
                    EntityRemnantMinion.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityRemnantMinion.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityRemnantMinion.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityRemnantMinion.this.func_70638_az() == null) {
                        EntityRemnantMinion.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityRemnantMinion.this.field_70159_w, (double)EntityRemnantMinion.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityRemnantMinion.this.func_70638_az().field_70165_t - EntityRemnantMinion.this.field_70165_t;
                        double d5 = EntityRemnantMinion.this.func_70638_az().field_70161_v - EntityRemnantMinion.this.field_70161_v;
                        EntityRemnantMinion.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                    EntityRemnantMinion.this.field_70761_aq = EntityRemnantMinion.this.field_70177_z;
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityRemnantMinion.this.func_70638_az() != null && !EntityRemnantMinion.this.func_70605_aq().func_75640_a() && EntityRemnantMinion.this.field_70146_Z.nextInt(7) == 0) {
                return EntityRemnantMinion.this.func_70068_e((Entity)EntityRemnantMinion.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityRemnantMinion.this.func_70605_aq().func_75640_a() && EntityRemnantMinion.this.isAttacking() && EntityRemnantMinion.this.func_70638_az() != null && EntityRemnantMinion.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityRemnantMinion.this.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityRemnantMinion.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            EntityRemnantMinion.this.setAttacking(true);
        }

        public void func_75251_c() {
            EntityRemnantMinion.this.setAttacking(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityRemnantMinion.this.func_70638_az();
            if (entitylivingbase == null) {
                return;
            }
            if (EntityRemnantMinion.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityRemnantMinion.this.func_70652_k((Entity)entitylivingbase);
                EntityRemnantMinion.this.setAttacking(false);
            } else {
                double d0 = EntityRemnantMinion.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    EntityRemnantMinion.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }
}

