/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIAttackSpellImproved;
import com.windanesz.ancientspellcraft.entity.living.Vector;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntitySkeletonMage
extends AbstractSkeleton
implements ISpellCaster {
    private double AISpeed = 1.0;
    private Spell continuousSpell;
    private int spellCounter;
    private int particleCount = 1;
    private float particleSize = 0.7f;
    private ResourceLocation lootTableRegular = new ResourceLocation("ancientspellcraft", "entities/skeleton_mage");
    private ResourceLocation lootTableRare = new ResourceLocation("ancientspellcraft", "entities/skeleton_mage_rare");
    protected static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntitySkeletonMage.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> IS_RARE = EntityDataManager.func_187226_a(EntitySkeletonMage.class, (DataSerializer)DataSerializers.field_187198_h);
    protected List<Spell> spells = new ArrayList<Spell>(1);
    private EntityAIAttackSpellImproved<EntitySkeletonMage> spellcastingAI = new EntityAIAttackSpellImproved<EntitySkeletonMage>(this, this.AISpeed, 15.0f, 25, 40);

    public EntitySkeletonMage(World world) {
        super(world);
        this.field_70728_aV = this.isRare() ? 8 : 5;
        this.field_70714_bg.func_75776_a(0, this.spellcastingAI);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENT, (Object)0);
        this.field_70180_af.func_187214_a(IS_RARE, (Object)false);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_184641_n(false);
        this.setRare(this.field_70146_Z.nextFloat() < 0.4f);
        this.setElement(this.pickElementForBiome());
        Element element = this.getElement();
        this.populateSpellList(element, null);
        return livingdata;
    }

    public Element pickElementForBiome() {
        if (Settings.generalSettings.use_biomes_for_mage_elements < this.field_70146_Z.nextFloat()) {
            return Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1];
        }
        Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
        String name = biome.getRegistryName().func_110623_a();
        if (Arrays.stream(Settings.generalSettings.fire_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.FIRE;
        }
        if (Arrays.stream(Settings.generalSettings.earth_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.EARTH;
        }
        if (Arrays.stream(Settings.generalSettings.sorcery_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.SORCERY;
        }
        if (Arrays.stream(Settings.generalSettings.healing_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.HEALING;
        }
        if (Arrays.stream(Settings.generalSettings.lightning_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.LIGHTNING;
        }
        if (Arrays.stream(Settings.generalSettings.ice_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.ICE;
        }
        if (Arrays.stream(Settings.generalSettings.necromancy_skeleton_and_ghost_biome_whitelist).anyMatch(b -> b.equals(name))) {
            return Element.NECROMANCY;
        }
        return Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1];
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ASItems.wizard_hat_ancient));
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.0f);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.func_70659_e((float)this.AISpeed);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.renderHandParticle();
        if (this.isRare() && this.field_70170_p.field_72995_K) {
            double x = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            double y = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()) + (double)0.2f;
            double z = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).clr(0.6f, 1.0f, 0.6f).shaded(true).spawn(this.field_70170_p);
        }
    }

    private void renderHandParticle() {
        Vec3d height = this.func_174791_d().func_72441_c(0.0, 0.84, 0.0);
        Vec3d rightHand = Vector.toRectangular(Math.toRadians(this.field_70761_aq + 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
        Vec3d leftHand = Vector.toRectangular(Math.toRadians(this.field_70761_aq - 90.0f), 0.0).times(0.385).withY(0.0).toMinecraft();
        rightHand = rightHand.func_178787_e(height);
        leftHand = leftHand.func_178787_e(height);
        if (this.field_82175_bq) {
            rightHand = rightHand.func_72441_c(this.func_70040_Z().field_72450_a * 0.5, (double)this.field_70733_aJ * 0.6, this.func_70040_Z().field_72449_c * 0.5);
        }
        this.spawnHandParticle(rightHand);
        this.spawnHandParticle(leftHand);
    }

    private void spawnHandParticle(Vec3d handSide) {
        if (this.field_70170_p.field_72995_K) {
            block9: for (int i = 0; i < this.particleCount; ++i) {
                switch (this.getElement()) {
                    case FIRE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMage.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(255, 116, 0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMage.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case ICE: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(0, 204, 255).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case LIGHTNING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(EntitySkeletonMage.getRandomNumberInRange(0, 2)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(27, 102, 125).collide(false).scale(this.particleSize / 0.9f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case EARTH: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(102, 51, 0).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case SORCERY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(89, 238, 155).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case HEALING: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMage.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(255, 255, 204).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(246, 180 + EntitySkeletonMage.getRandomNumberInRange(0, 50), 80).collide(false).scale(this.particleSize / 2.0f).spawn(this.field_70170_p);
                        continue block9;
                    }
                    case NECROMANCY: {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(51, 0, 26).collide(false).scale(this.particleSize / 1.5f).spawn(this.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(handSide).time(6 + EntitySkeletonMage.getRandomNumberInRange(0, 4)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0, this.field_70170_p.field_73012_v.nextDouble() / 40.0, this.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(32 + EntitySkeletonMage.getRandomNumberInRange(0, 25), 1, 36).collide(false).scale(this.particleSize / 2.2f).spawn(this.field_70170_p);
                    }
                }
            }
        }
    }

    public Element getElement() {
        return Element.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENT)];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
        this.lootTableRare = new ResourceLocation("ancientspellcraft", "entities/skeleton_mage/" + element.func_176610_l() + "_rare");
        this.lootTableRegular = new ResourceLocation("ancientspellcraft", "entities/skeleton_mage/" + element.func_176610_l());
    }

    public void setRare(boolean rare) {
        this.field_70180_af.func_187227_b(IS_RARE, (Object)rare);
    }

    public void populateSpellList(Element element, Spell spell) {
        this.spells = new ArrayList<Spell>(1);
        if (spell != null) {
            this.spells.add(spell);
            return;
        }
        switch (element) {
            case FIRE: {
                if (this.isRare()) {
                    this.spells.add(Spells.fire_breath);
                    break;
                }
                this.spells.add(Spells.fireball);
                break;
            }
            case ICE: {
                if (this.isRare()) {
                    this.spells.add(Spells.ice_lance);
                    break;
                }
                this.spells.add(Spells.iceball);
                break;
            }
            case LIGHTNING: {
                if (this.isRare()) {
                    this.spells.add(Spells.lightning_disc);
                    break;
                }
                this.spells.add(Spells.lightning_arrow);
                break;
            }
            case EARTH: {
                if (this.isRare()) {
                    this.spells.add(Spells.fangs);
                    break;
                }
                this.spells.add(Spells.dart);
                break;
            }
            case SORCERY: {
                if (this.isRare()) {
                    this.spells.add(Spells.force_orb);
                    break;
                }
                this.spells.add(Spells.force_arrow);
                break;
            }
            case HEALING: {
                if (this.isRare()) {
                    this.spells.add(Spells.ray_of_purification);
                    break;
                }
                if (Spell.registry.containsKey(new ResourceLocation("morphspellpack", "radiant_spark"))) {
                    this.spells.add((Spell)Spell.registry.getValue(new ResourceLocation("morphspellpack", "radiant_spark")));
                    break;
                }
                this.spells.add(Spells.magic_missile);
                break;
            }
            case NECROMANCY: {
                if (this.isRare()) {
                    this.spells.add(Spells.summon_wither_skeleton);
                    break;
                }
                this.spells.add(Spells.summon_zombie);
                break;
            }
            default: {
                this.spells.add(Spells.magic_missile);
            }
        }
    }

    private static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    private boolean hasRangedAttack() {
        return true;
    }

    public List<Spell> getSpells() {
        return this.spells;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("element", this.getElement().ordinal());
        nbt.func_74757_a("rare", this.isRare());
        NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(this.spells, spell -> new NBTTagInt(spell.metadata())));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setElement(Element.values()[nbt.func_74762_e("element")]);
        this.setRare(nbt.func_74767_n("rare"));
        this.spells = (List)NBTExtras.NBTToList((NBTTagList)nbt.func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
    }

    public float getOpacity() {
        return this.isRare() ? 0.55f : 1.0f;
    }

    public SpellModifiers getModifiers() {
        return new SpellModifiers();
    }

    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    public void setSpellCounter(int count) {
        this.spellCounter = count;
    }

    public int getSpellCounter() {
        return this.spellCounter;
    }

    protected SoundEvent func_190727_o() {
        return SoundEvents.field_190035_gx;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected ResourceLocation func_184647_J() {
        return this.isRare() ? this.lootTableRare : this.lootTableRegular;
    }

    public boolean func_70601_bi() {
        Integer[] integerArray = Settings.generalSettings.skeleton_mage_dimension_whitelist;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            if (!super.func_70601_bi() || this.field_71093_bK != i2) continue;
            return true;
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        if (this.isRare() && this.field_70146_Z.nextFloat() < 0.15f && !this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                EntityRemnant remnant = new EntityRemnant(this.field_70170_p);
                remnant.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
                remnant.setElement(this.getElement());
                this.field_70170_p.func_72838_d((Entity)remnant);
            }
        }
        super.func_70645_a(cause);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType) || this.hasRangedAttack();
    }

    public float func_70047_e() {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.6;
    }

    public boolean isRare() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_RARE);
    }

    public ITextComponent func_145748_c_() {
        if (this.isRare()) {
            return new TextComponentTranslation("entity.ancientspellcraft:ghost_mage.name", new Object[0]);
        }
        return super.func_145748_c_();
    }
}

