/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.data.SpellCategorization;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public interface IArmourClassWizard {
    public static Tier populateSpells(EntityLiving wizard, List<Spell> spells, Element e, boolean master, int n, Random random) {
        Tier maxTier = Tier.NOVICE;
        List npcSpells = Spell.getSpells(s -> s.canBeCastBy(wizard, false));
        for (int i = 0; i < n; ++i) {
            List list;
            boolean battleMage = wizard instanceof IArmourClassWizard && ((IArmourClassWizard)wizard).getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE;
            Element element = e == Element.MAGIC ? Element.values()[random.nextInt(Element.values().length)] : e;
            int randomiser = random.nextInt(20);
            Tier tier = randomiser < 10 ? Tier.NOVICE : (randomiser < 16 ? Tier.APPRENTICE : (randomiser < 19 || !master ? Tier.ADVANCED : Tier.MASTER));
            if (tier.ordinal() > maxTier.ordinal()) {
                maxTier = tier;
            }
            if (battleMage) {
                switch (i) {
                    case 0: {
                        list = SpellCategorization.getSpellsForCategory(SpellCategorization.SpellCategory.BUFF);
                        break;
                    }
                    case 1: {
                        list = SpellCategorization.getSpellsForCategory(SpellCategorization.SpellCategory.CLOSE_COMBAT);
                        break;
                    }
                    case 2: {
                        list = SpellCategorization.getSpellsForCategory(SpellCategorization.SpellCategory.DISABLE);
                        break;
                    }
                    default: {
                        list = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, element, new SpellProperties.Context[]{SpellProperties.Context.NPCS}));
                    }
                }
                list.retainAll(npcSpells);
                list.removeAll(spells);
                list.removeIf(s -> s.getElement() != element);
                if (list.isEmpty()) {
                    list = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, element, new SpellProperties.Context[]{SpellProperties.Context.NPCS}));
                }
            } else {
                list = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, element, new SpellProperties.Context[]{SpellProperties.Context.NPCS}));
            }
            list.retainAll(npcSpells);
            list.removeAll(spells);
            if (list.isEmpty()) {
                list = npcSpells;
                list.removeAll(spells);
            }
            if (list.isEmpty()) continue;
            spells.add((Spell)list.get(random.nextInt(list.size())));
        }
        return maxTier;
    }

    public ItemWizardArmour.ArmourClass getArmourClass();

    public void setArmourClass(ItemWizardArmour.ArmourClass var1);

    default public ITextComponent getArmourClassNameFor(ItemWizardArmour.ArmourClass armourClass) {
        return new TextComponentTranslation("wizard_armour_class." + armourClass.name().toLowerCase(), new Object[0]);
    }
}

