/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.handler;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.data.RitualDiscoveryData;
import com.windanesz.ancientspellcraft.entity.ai.EntitySummonAIFollowOwner;
import com.windanesz.ancientspellcraft.entity.projectile.EntityContingencyProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMetamagicProjectile;
import com.windanesz.ancientspellcraft.integration.artemislib.ASArtemisLibIntegration;
import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.AbstractItemArtefactWithSlots;
import com.windanesz.ancientspellcraft.item.EnumElementalSwordEffect;
import com.windanesz.ancientspellcraft.item.ItemArcaneMirror;
import com.windanesz.ancientspellcraft.item.ItemBattlemageShield;
import com.windanesz.ancientspellcraft.item.ItemBeltScrollHolder;
import com.windanesz.ancientspellcraft.item.ItemElementalBelt;
import com.windanesz.ancientspellcraft.item.ItemElementalCloak;
import com.windanesz.ancientspellcraft.item.ItemFocusStone;
import com.windanesz.ancientspellcraft.item.ItemInfernalStone;
import com.windanesz.ancientspellcraft.item.ItemManaArtefact;
import com.windanesz.ancientspellcraft.item.ItemRitualBook;
import com.windanesz.ancientspellcraft.item.ItemSoulboundWandUpgrade;
import com.windanesz.ancientspellcraft.potion.PotionMetamagicEffect;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASDimensions;
import com.windanesz.ancientspellcraft.registry.ASEnchantments;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.ritual.ElementalAttunement;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.spell.AbsorbArtefact;
import com.windanesz.ancientspellcraft.spell.AbsorbCrystal;
import com.windanesz.ancientspellcraft.spell.AbsorbPotion;
import com.windanesz.ancientspellcraft.spell.Contingency;
import com.windanesz.ancientspellcraft.spell.DimensionalAnchor;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.Martyr;
import com.windanesz.ancientspellcraft.spell.MetaSpellBuff;
import com.windanesz.ancientspellcraft.spell.MetamagicProjectile;
import com.windanesz.ancientspellcraft.spell.TimeKnot;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.event.ArtefactCheckEvent;
import electroblob.wizardry.event.ResurrectionEvent;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.spell.SpellProjectile;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
public class ASEventHandler {
    public static final float COST_REDUCTION_PER_ARMOUR = 0.15f;
    public static final IStoredVariable<Integer> SPELL_ID = IStoredVariable.StoredVariable.ofInt((String)"artefactEternitySpell", (Persistence)Persistence.ALWAYS);
    public static final IStoredVariable<Integer> COUNTDOWN_KEY = IStoredVariable.StoredVariable.ofInt((String)"artefactEternityCountdown", (Persistence)Persistence.NEVER).withTicker(ASEventHandler::update);

    private ASEventHandler() {
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getWorld().field_72995_K && event.getItemStack().func_77973_b() == WizardryItems.identification_scroll && event.getEntityLiving() instanceof EntityPlayer) {
            Ritual ritual;
            EntityPlayer player;
            EnumHand otherHand = event.getHand() == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            ItemStack otherItemStack = event.getEntityLiving().func_184586_b(otherHand);
            if (otherItemStack.func_77973_b() instanceof ItemRitualBook && !RitualDiscoveryData.hasRitualBeenDiscovered(player = (EntityPlayer)event.getEntityLiving(), ritual = ItemRitualBook.getRitual(otherItemStack))) {
                RitualDiscoveryData.addKnownRitual(player, ritual);
                if (!player.func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
                ASUtils.sendMessage((Entity)player, "ritual.discover", false, ritual.getNameForTranslationFormatted());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        NBTTagCompound activeContingencies;
        EntityPlayer player;
        WizardData data;
        if (event.getEntityLiving().func_70644_a(ASPotions.magma_strider)) {
            EntityLivingBase entity = event.getEntityLiving();
            PotionEffect effect = entity.func_70660_b(ASPotions.magma_strider);
            if (entity.func_180799_ab() && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
                entity.field_70159_w *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                entity.field_70179_y *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                if (entity.func_70093_af() && entity.field_70181_x < 0.0 || entity.field_70181_x > 0.0) {
                    entity.field_70181_x *= (double)1.7f + 0.03 * (double)effect.func_76458_c();
                }
            }
        }
        if (event.getEntityLiving().func_70644_a(ASPotions.aquatic_agility)) {
            PotionEffect effect = event.getEntityLiving().func_70660_b(ASPotions.aquatic_agility);
            if (event.getEntityLiving().func_70090_H()) {
                event.getEntityLiving().field_70159_w *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                event.getEntityLiving().field_70179_y *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                if (event.getEntityLiving().func_70093_af() && event.getEntityLiving().field_70181_x < 0.0 || event.getEntityLiving().field_70181_x > 0.0) {
                    event.getEntityLiving().field_70181_x *= (double)1.1f + 0.025 * (double)effect.func_76458_c();
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70122_E && event.getEntityLiving().field_70143_R >= 4.0f && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.FALL.spellName)) {
            Contingency.tryCastContingencySpell(player, data, Contingency.Type.FALL);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (event.getEntityPlayer().func_70644_a(ASPotions.curse_of_insomnia)) {
            ASUtils.sendMessage((Entity)event.getEntityPlayer(), "message.ancientspellcraft:curse.of_insomnia.sleep_prevented", true, new Object[0]);
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            EntityPlayer player;
            WizardData data;
            ArrayList<Potion> effects = new ArrayList<Potion>();
            for (String entry : Settings.generalSettings.immobility_contingency_effects) {
                try {
                    Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(entry));
                    effects.add(potion);
                }
                catch (Exception e) {
                    AncientSpellcraft.logger.warn("No such potion type named as " + entry);
                }
            }
            if (event.getPotionEffect().func_188419_a() != null && effects.contains(event.getPotionEffect().func_188419_a()) && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.IMMOBILITY.spellName)) {
                Contingency.tryCastContingencySpell(player, data, Contingency.Type.IMMOBILITY);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        NBTTagCompound activeContingencies;
        EntityPlayer player;
        WizardData data;
        if (event.getEntityBeingMounted() instanceof EntityBubble && event.getEntityMounting() instanceof EntityPlayer && event.isMounting() && (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityMounting()))) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.IMMOBILITY.spellName)) {
            String spellName = activeContingencies.func_74779_i(Contingency.Type.IMMOBILITY.spellName);
            Contingency.tryCastContingencySpell(player, data, Contingency.Type.IMMOBILITY);
            if (spellName.equals(Spells.cure_effects.getUnlocalisedName())) {
                event.setCanceled(true);
                event.getEntityBeingMounted().func_70106_y();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        int level;
        EntityLivingBase attacker;
        if (event.getEntity() instanceof EntityPlayer && ((EntityPlayer)event.getEntity()).func_70644_a(ASPotions.burrow) && "inWall".equals(event.getSource().func_76355_l())) {
            event.setCanceled(true);
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && event.getEntityLiving().field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)event.getEntityLiving()).spawn(event.getEntityLiving().field_70170_p);
            }
        }
    }

    private static void onMetaMagicFinished(EntityPlayer player, Spell spell, Potion effect) {
        ASEventHandler.setCooldown(player, spell);
        if (!player.field_70170_p.field_72995_K) {
            float chance = 0.0f;
            for (ItemArtefact ring : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[]{ItemArtefact.Type.RING})) {
                if (ring != ASItems.ring_metamagic_preserve) continue;
                chance += 0.33f;
            }
            if (chance == 0.0f || chance > 0.0f && player.field_70170_p.field_73012_v.nextFloat() < chance) {
                player.func_184589_d(effect);
            }
        }
    }

    private static void setCooldown(EntityPlayer player, Spell spell) {
        List<ItemStack> wands = ASUtils.getAllHotbarWands(player);
        if (wands != null && !wands.isEmpty()) {
            for (ItemStack wand : wands) {
                int index = 0;
                for (Spell currentSpell : WandHelper.getSpells((ItemStack)wand)) {
                    try {
                        int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                        if (cooldowns.length == 0) {
                            int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                            cooldowns = new int[count];
                        }
                        if (currentSpell == spell) {
                            int[] maxCooldowns = WandHelper.getMaxCooldowns((ItemStack)wand);
                            if (maxCooldowns.length == 0) {
                                int count = WandHelper.getSpells((ItemStack)wand).length - 1;
                                maxCooldowns = new int[count];
                            }
                            cooldowns[index] = 1200;
                            maxCooldowns[index] = 1200;
                            WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                            WandHelper.setMaxCooldowns((ItemStack)wand, (int[])maxCooldowns);
                        }
                        ++index;
                    }
                    catch (Exception e) {
                        AncientSpellcraft.logger.error("Failed to set a wand cooldown");
                    }
                }
            }
        }
    }

    private static int update(EntityPlayer player, Integer countdown) {
        if (countdown == null) {
            return 0;
        }
        if (!player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            Integer spellId = (Integer)data.getVariable(SPELL_ID);
            if (spellId == null) {
                return 0;
            }
            Spell spell = Spell.byMetadata((int)spellId);
            if (countdown != 1 || ItemArtefact.findMatchingWandAndCast((EntityPlayer)player, (Spell)spell)) {
                // empty if block
            }
            if (countdown > 0) {
                Integer n = countdown;
                Integer n2 = countdown = Integer.valueOf(countdown - 1);
            }
        }
        return countdown;
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        int level;
        EntityLivingBase attacker;
        WizardData data;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            Object effect;
            player = (EntityPlayer)event.getEntity();
            if (player.func_70644_a(ASPotions.wizard_shield) && (effect = player.func_70660_b(ASPotions.wizard_shield)) != null) {
                float oldAmount = event.getAmount();
                int oldTimer = effect.func_76459_b();
                int amplifier = effect.func_76458_c();
                player.func_85034_r(0);
                int usedUp = (int)event.getAmount();
                int newAmplifier = amplifier - usedUp;
                float newAmount = (int)event.getAmount() - (amplifier + 1);
                if (newAmount < 0.0f) {
                    amplifier = (int)(-newAmount);
                    event.setCanceled(true);
                }
                if (newAmplifier > 0) {
                    if (event.getSource().func_76364_f() instanceof EntityArrow) {
                        event.getSource().func_76364_f().func_70106_y();
                    }
                    player.func_184589_d(ASPotions.wizard_shield);
                    player.func_70690_d(new PotionEffect(ASPotions.wizard_shield, oldTimer, newAmplifier));
                } else {
                    player.func_184589_d(ASPotions.wizard_shield);
                }
                event.setAmount(newAmount);
            }
            block0: for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                ItemStack amulet;
                List<ItemStack> amuletz;
                if (artefact == ASItems.amulet_time_knot && player.func_70644_a(ASPotions.time_knot) && player.func_110143_aJ() - event.getAmount() <= 0.0f && !player.func_184811_cZ().func_185141_a(ASItems.amulet_time_knot)) {
                    TimeKnot.loopPlayer(player);
                    event.setCanceled(true);
                    player.func_70066_B();
                    player.func_184811_cZ().func_185145_a(ASItems.amulet_time_knot, 6000);
                }
                if (artefact == ASItems.amulet_time_slow && !player.func_184811_cZ().func_185141_a(ASItems.amulet_time_slow)) {
                    if (!(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f)) continue;
                    player.func_70690_d(new PotionEffect(WizardryPotions.slow_time, 120));
                    player.func_184811_cZ().func_185145_a(ASItems.amulet_time_slow, 9600);
                    continue;
                }
                if (artefact == ASItems.charm_cryostasis) {
                    if (!(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    ASSpells.cryostasis.cast(player.field_70170_p, player, player.func_184600_cs(), 0, new SpellModifiers());
                    continue;
                }
                if (artefact == ASItems.ring_protector) {
                    if (!(player.func_110143_aJ() <= 8.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    boolean shouldContinue = true;
                    for (ItemStack wand : ASUtils.getAllHotbarWands(player)) {
                        if (!shouldContinue) continue block0;
                        Spell[] spells = WandHelper.getSpells((ItemStack)wand);
                        ArrayList<Spell> minions = new ArrayList<Spell>();
                        ArrayList<Integer> indexes = new ArrayList<Integer>();
                        int index = 0;
                        for (Spell spell : spells) {
                            if (spell instanceof SpellMinion) {
                                minions.add(spell);
                                indexes.add(index);
                            }
                            ++index;
                        }
                        if (minions.isEmpty()) continue;
                        int currIndex = indexes.size() == 1 ? 0 : player.field_70170_p.field_73012_v.nextInt(indexes.size() - 1);
                        Spell spell = (Spell)minions.get(currIndex);
                        SpellModifiers modifiers = new SpellModifiers();
                        modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : ((ItemWand)wand.func_77973_b()).calculateModifiers(wand, player, spell);
                        int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                        if (cooldowns != null && cooldowns.length != spells.length) continue;
                        WandHelper.selectSpell((ItemStack)wand, (int)currIndex);
                        shouldContinue = !((ItemWand)wand.func_77973_b()).cast(wand, spell, player, EnumHand.MAIN_HAND, 0, modifiers);
                        if (shouldContinue) continue;
                        WandHelper.setCooldowns((ItemStack)wand, (int[])cooldowns);
                    }
                    continue;
                }
                if (artefact == ASItems.ring_berserker) {
                    if (player.field_70170_p.field_72995_K || !(player.func_110143_aJ() <= 6.0f) && !(player.func_110143_aJ() - event.getAmount() <= 6.0f) || player.func_70644_a(MobEffects.field_76420_g)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 300));
                    continue;
                }
                if (artefact == ASItems.amulet_rabbit) {
                    if (player.field_70170_p.field_72995_K || !(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                    if (!player.func_70644_a(MobEffects.field_76424_c)) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 200));
                    }
                    if (player.func_70644_a(MobEffects.field_76437_t)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
                    continue;
                }
                if (artefact == ASItems.amulet_shield && !player.func_184811_cZ().func_185141_a(ASItems.amulet_shield)) {
                    if (!(event.getAmount() > 1.0f)) continue;
                    player.func_70690_d(new PotionEffect(ASPotions.wizard_shield, 100, 15));
                    player.func_184811_cZ().func_185145_a(ASItems.amulet_shield, 3600);
                    continue;
                }
                if (artefact == ASItems.belt_soul_scorch && event.getSource().func_76364_f() instanceof EntityLivingBase) {
                    ((EntityLivingBase)event.getSource().func_76364_f()).func_70690_d(new PotionEffect(ASPotions.soul_scorch, 60));
                    continue;
                }
                if (artefact == ASItems.ring_undeath && !player.func_70644_a(WizardryPotions.curse_of_undeath)) {
                    if (!(player.func_110143_aJ() - event.getAmount() <= 0.0f) || player.func_184811_cZ().func_185141_a(ASItems.ring_undeath)) continue;
                    player.func_70690_d(new PotionEffect(WizardryPotions.curse_of_undeath, Integer.MAX_VALUE, 0));
                    player.func_184811_cZ().func_185145_a(ASItems.ring_undeath, 6000);
                    ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:ring_undeath.resurrect", true, new Object[0]);
                    event.setAmount(0.0f);
                    player.func_70691_i(player.func_110138_aP() * Settings.generalSettings.ring_of_undeath_heal_amount);
                    continue;
                }
                if (artefact != ASItems.amulet_elemental_defense || (amuletz = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.AMULET)).size() != 1 || !(AbstractItemArtefactWithSlots.getItemForSlot(amulet = amuletz.get(0), 0).func_77973_b() instanceof ItemCrystal)) continue;
                ItemStack crystal = AbstractItemArtefactWithSlots.getItemForSlot(amulet, 0);
                Optional<Element> e = ASUtils.getDamageTypeElement(event.getSource().func_76355_l());
                if (!e.isPresent() || Element.values()[crystal.func_77960_j()] != e.get()) continue;
                event.setAmount(event.getAmount() * 0.7f);
            }
            if (event.getAmount() >= 0.0f && (data = WizardData.get((EntityPlayer)player)) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null) {
                if (Contingency.isFireDamageSource(event.getSource()) && activeContingencies.func_74764_b(Contingency.Type.FIRE.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.FIRE);
                } else if (event.getSource() == DamageSource.field_76369_e && activeContingencies.func_74764_b(Contingency.Type.DROWNING.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.DROWNING);
                } else if (activeContingencies.func_74764_b(Contingency.Type.DAMAGE.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.DAMAGE);
                }
                if (((double)player.func_110143_aJ() <= (double)player.func_110138_aP() * 0.25 || (double)(player.func_110143_aJ() - event.getAmount()) <= (double)player.func_110138_aP() * 0.25) && activeContingencies.func_74764_b(Contingency.Type.CRITICAL_HEALTH.spellName)) {
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.CRITICAL_HEALTH);
                }
            }
        }
        if (!(event.getEntity().field_70170_p.field_72995_K || !event.getEntityLiving().func_70644_a(ASPotions.martyr_beneficial) || !(event.getEntityLiving() instanceof EntityPlayer) || event.getSource().func_76363_c() || event.getSource() instanceof IElementalDamage && ((IElementalDamage)event.getSource()).isRetaliatory() || (data = WizardData.get((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()))) == null)) {
            Iterator<UUID> iterator = Martyr.getMartyrBoundEntities(data).iterator();
            while (iterator.hasNext()) {
                Entity entity = EntityUtils.getEntityByUUID((World)player.field_70170_p, (UUID)iterator.next());
                if (entity == null) {
                    iterator.remove();
                }
                if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_70644_a(ASPotions.martyr)) continue;
                if (DamageSafetyChecker.attackEntitySafely((Entity)entity, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC, (boolean)true), (float)event.getAmount(), (String)event.getSource().func_76355_l(), (DamageSource)DamageSource.field_76376_m, (boolean)false)) {
                    entity.func_184185_a(WizardrySounds.SPELL_CURSE_OF_SOULBINDING_RETALIATE, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.2f + 1.0f);
                }
                event.setCanceled(true);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_184614_ca().func_190926_b() && ImbueWeapon.isSword((ItemStack)attacker.func_184614_ca()) && (level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.static_charge, (ItemStack)attacker.func_184614_ca())) > 0 && !MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)event.getEntityLiving())) {
            event.setAmount(event.getAmount() + (float)(level * 2));
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getPotionEffect().func_188419_a() != ASPotions.tenacity && event.getEntityLiving().func_70644_a(ASPotions.tenacity)) {
            if (!event.getEntityLiving().func_184216_O().contains(event.getPotionEffect().func_188419_a().getRegistryName().toString())) {
                int tenacityLevel = event.getEntityLiving().func_70660_b(ASPotions.tenacity).func_76458_c() + 1;
                double reductionFactor = 1.0 - 0.25 * (double)tenacityLevel;
                event.getEntityLiving().func_184211_a(event.getPotionEffect().func_188419_a().getRegistryName().toString());
                event.getEntityLiving().func_70690_d(new PotionEffect(event.getPotionEffect().func_188419_a(), (int)((double)event.getPotionEffect().func_76459_b() * 0.5), event.getPotionEffect().func_76458_c()));
                event.setResult(Event.Result.DENY);
            } else {
                event.getEntityLiving().func_184216_O().remove(event.getPotionEffect().func_188419_a().getRegistryName().toString());
            }
        }
        if (!(event.getPotionEffect().func_188419_a() != ASPotions.astral_projection && event.getPotionEffect().func_188419_a() != ASPotions.eagle_eye || event.getEntityLiving() instanceof EntityPlayer)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getPotionEffect().func_188419_a() == MobEffects.field_76421_d && event.getEntityLiving() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)event.getEntityLiving()), (Item)ASItems.belt_temporal_anchor)) {
            event.setResult(Event.Result.DENY);
        }
        if (!(event.getPotionEffect().func_188419_a() != ASPotions.shrinkage && event.getPotionEffect().func_188419_a() != ASPotions.growth || ASArtemisLibIntegration.enabled())) {
            event.setResult(Event.Result.DENY);
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                WizardData data;
                String potionName;
                if (artefact == ASItems.amulet_poison_resistance) {
                    if (event.getPotionEffect().func_188419_a() != MobEffects.field_76436_u || !(player.field_70170_p.field_73012_v.nextFloat() < 0.5f)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact == ASItems.amulet_curse_ward) {
                    if (!(event.getPotionEffect().func_188419_a() instanceof Curse)) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact == ASItems.amulet_persistence) {
                    if (event.getPotionEffect().func_188419_a() != ASPotions.shrinkage && event.getPotionEffect().func_188419_a() != ASPotions.growth) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact == ASItems.amulet_cursed_mirror) {
                    if (!(event.getPotionEffect().func_188419_a() instanceof Curse) || !player.field_70170_p.field_73012_v.nextBoolean()) continue;
                    for (EntityLivingBase target : EntityUtils.getEntitiesWithinRadius((double)12.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class)) {
                        if (target == player || AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)target) || !(target instanceof EntityPlayer) && !(target instanceof ISpellCaster)) continue;
                        target.func_70690_d(event.getPotionEffect());
                    }
                    continue;
                }
                if (artefact != ASItems.amulet_absorb_potion || !event.getPotionEffect().func_188419_a().func_76398_f() || (potionName = (String)(data = WizardData.get((EntityPlayer)player)).getVariable(AbsorbPotion.EFFECT)) == null || !potionName.equals(event.getPotionEffect().func_188419_a().getRegistryName().toString())) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == ASPotions.magical_exhaustion) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                ItemStack pendant;
                Spell spell;
                ArrayList amuletList;
                if (artefact != ASItems.amulet_pendant_of_eternity || (amuletList = ASBaublesIntegration.enabled() ? ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.AMULET) : new ArrayList()).isEmpty() || (spell = ASEventHandler.getCurrentSpellFromSpellBearingArtefact(ASItems.amulet_pendant_of_eternity, pendant = (ItemStack)amuletList.get(0))) == Spells.none || !(spell instanceof SpellBuff)) continue;
                try {
                    SpellBuff obj = (SpellBuff)spell;
                    Field field = ASUtils.ReflectionUtil.getField(obj.getClass(), "potionSet");
                    ASUtils.ReflectionUtil.makeAccessible(field);
                    Set potionset = (Set)field.get(obj);
                    if (!potionset.contains(event.getPotionEffect().func_188419_a())) continue;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    data.setVariable(COUNTDOWN_KEY, (Object)20);
                    data.setVariable(SPELL_ID, (Object)spell.metadata());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        NBTTagCompound compound;
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70662_br()) {
            EntityLivingBase entity;
            player = (EntityPlayer)event.getSource().func_76346_g();
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_reanimation) && !event.getEntityLiving().field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextFloat() < 0.15f && ((entity = event.getEntityLiving()) instanceof EntitySkeleton || entity instanceof EntityZombie)) {
                EntitySkeletonMinion skeletonMinion = new EntitySkeletonMinion(entity.field_70170_p);
                skeletonMinion.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                skeletonMinion.setCaster((EntityLivingBase)player);
                skeletonMinion.setLifetime(600);
                if (entity.func_184592_cb().func_77973_b() instanceof ItemBow || entity.func_184614_ca().func_77973_b() instanceof ItemBow) {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                } else {
                    skeletonMinion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151041_m));
                }
                skeletonMinion.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
                entity.field_70170_p.func_72838_d((Entity)skeletonMinion);
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            NBTTagCompound activeContingencies;
            player = (EntityPlayer)event.getEntityLiving();
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.DEATH.spellName)) {
                Contingency.tryCastContingencySpell(player, data, Contingency.Type.DEATH);
            }
            ItemSoulboundWandUpgrade.storeSoulboundWands(player);
        }
        if (event.getEntityLiving().getEntityData().func_74764_b("active_listener") && (compound = event.getEntityLiving().getEntityData().func_74775_l("active_listener")) != null && compound.func_74764_b(Contingency.Type.DEATH.spellName)) {
            Contingency.tryCastContingencySpellAsMob(event.getEntityLiving(), Contingency.Type.DEATH);
        }
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)event.getSource().func_76346_g();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(entityLivingBase.func_184614_ca(), entityLivingBase.func_184592_cb()));
            for (ItemStack stack : items) {
                if (!(stack.func_77973_b() instanceof IManaStoringItem) || ((IManaStoringItem)stack.func_77973_b()).isManaFull(stack) || WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.siphon_upgrade) <= 0) continue;
                int mana = 5 * WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.siphon_upgrade) + entityLivingBase.field_70170_p.field_73012_v.nextInt(5);
                ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, mana);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeathEventLowest(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (player.func_70644_a(ASPotions.spell_siphon)) {
                for (ItemStack stack : InventoryUtils.getPrioritisedHotbarAndOffhand((EntityPlayer)player)) {
                    if (!(stack.func_77973_b() instanceof IManaStoringItem) || ((IManaStoringItem)stack.func_77973_b()).isManaFull(stack)) continue;
                    int mana = 5 * (player.func_70660_b(ASPotions.spell_siphon).func_76458_c() + 1);
                    ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, mana);
                    break;
                }
            }
            if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityEvilWizard && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_plunderers_mark)) {
                double d0 = event.getEntityLiving().field_70163_u - (double)0.3f + (double)event.getEntityLiving().func_70047_e();
                EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, d0, event.getEntityLiving().field_70161_v, new ItemStack(ASItems.astral_diamond_shard));
                event.getEntityLiving().field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactArrowEvent(ProjectileImpactEvent.Arrow event) {
        if (!event.getArrow().field_70170_p.field_72995_K && event.getArrow().field_70250_c instanceof EntityPlayer) {
            EntityLivingBase target;
            EntityPlayer player = (EntityPlayer)event.getArrow().field_70250_c;
            if (player.field_70170_p.field_73012_v.nextFloat() < 0.2f && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_poison_arrow) && event.getRayTraceResult().field_72308_g instanceof EntityLivingBase && !(target = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_70644_a(MobEffects.field_76436_u)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getSpell().getTier().ordinal() > 1) {
            for (EntityPlayer player : event.getWorld().field_73010_i) {
                if (!(event.getCaster() instanceof EntityLivingBase) || !(event.getCaster().func_70068_e((Entity)player) < 20.0) || !ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_suppression_orb)) continue;
                if (event.getCaster() instanceof EntityPlayer) {
                    ASUtils.sendMessage((Entity)event.getCaster(), "item.ancientspellcraft:charm_suppression_orb.message", true, new Object[0]);
                }
                event.setCanceled(true);
                return;
            }
        }
        if (event.getCaster() instanceof EntityPlayer && event.getSource() == SpellCastEvent.Source.WAND) {
            List<ItemStack> list;
            int wandMana;
            ItemStack wand;
            EntityPlayer player = (EntityPlayer)event.getCaster();
            int cost = (int)((float)event.getSpell().getCost() * event.getModifiers().get("cost") + 0.1f);
            ItemStack itemStack = wand = event.getCaster().func_184614_ca().func_77973_b() instanceof ItemWand ? event.getCaster().func_184614_ca() : event.getCaster().func_184592_cb();
            if (wand.func_77973_b() instanceof IManaStoringItem && (wandMana = ((IManaStoringItem)wand.func_77973_b()).getMana(wand)) <= cost && ASBaublesIntegration.enabled() && !(list = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.RING)).isEmpty()) {
                for (ItemStack currentStack : list) {
                    int currMana;
                    if (!(currentStack.func_77973_b() instanceof ItemManaArtefact) || (currMana = ((ItemManaArtefact)currentStack.func_77973_b()).getMana(currentStack)) < cost) continue;
                    ((ItemManaArtefact)currentStack.func_77973_b()).setMana(currentStack, currMana - cost);
                    ((ItemWand)wand.func_77973_b()).setMana(wand, wandMana + cost);
                    if (!event.getSpell().isContinuous || (currMana = ((ItemManaArtefact)currentStack.func_77973_b()).getMana(currentStack)) < 50) break;
                    ((ItemManaArtefact)currentStack.func_77973_b()).setMana(currentStack, currMana - 50);
                    ((ItemWand)wand.func_77973_b()).rechargeMana(wand, 50);
                    break;
                }
            }
        }
        if (event.getSpell().getType() == SpellType.ALTERATION || event.getSpell().getType() == SpellType.ATTACK || event.getSpell().getType() == SpellType.MINION || event.getSpell().getType() == SpellType.PROJECTILE) {
            List closestPlayers = new ArrayList();
            if (event.getCaster() != null) {
                closestPlayers = EntityUtils.getEntitiesWithinRadius((double)20.0, (double)event.getCaster().field_70165_t, (double)event.getCaster().field_70163_u, (double)event.getCaster().field_70161_v, (World)event.getWorld(), EntityPlayer.class);
            }
            if (!closestPlayers.isEmpty()) {
                for (EntityPlayer player : closestPlayers) {
                    Object activeContingencies;
                    WizardData data;
                    if (event.getCaster() == player || AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)event.getCaster()) || (data = WizardData.get((EntityPlayer)player)) == null || (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) == null || !activeContingencies.func_74764_b(Contingency.Type.HOSTILE_SPELLCAST.spellName)) continue;
                    Contingency.tryCastContingencySpell(player, data, Contingency.Type.HOSTILE_SPELLCAST);
                }
            }
        }
        if (event.getCaster() instanceof EntityPlayer) {
            WizardData data;
            int gems = AbsorbArtefact.getPowerGemCount((EntityPlayer)event.getCaster());
            if (gems > 0) {
                SpellModifiers modifiers = event.getModifiers();
                modifiers.set("potency", modifiers.get("potency") + (float)gems * 0.01f, false);
            }
            if (!(event.getSpell() instanceof MetaSpellBuff)) {
                EntityPlayer player = (EntityPlayer)event.getCaster();
                HashMap potionEffectMap = new HashMap();
                Map potionEffects = player.func_193076_bZ();
                potionEffectMap.putAll(potionEffects);
                for (Map.Entry entry : potionEffectMap.entrySet()) {
                    float duration;
                    float range;
                    SpellModifiers modifiers;
                    Potion potion = (Potion)entry.getKey();
                    if (potion instanceof PotionMetamagicEffect) {
                        int level;
                        if (potion.equals(ASPotions.arcane_augmentation)) {
                            PotionEffect effect = (PotionEffect)entry.getValue();
                            modifiers = event.getModifiers();
                            range = modifiers.get(WizardryItems.range_upgrade);
                            float blast = modifiers.get(WizardryItems.blast_upgrade);
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers.set(WizardryItems.range_upgrade, range + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
                                modifiers.set(WizardryItems.blast_upgrade, blast + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.arcane_augmentation, ASPotions.arcane_augmentation);
                        } else if (potion.equals(ASPotions.intensifying_focus)) {
                            PotionEffect effect = (PotionEffect)entry.getValue();
                            modifiers = event.getModifiers();
                            float potency = modifiers.get("potency");
                            int level2 = effect.func_76458_c() + 1;
                            if (level2 > 0) {
                                modifiers.set("potency", potency + (float)level2 * Constants.POTENCY_INCREASE_PER_TIER, true);
                            }
                            ASEventHandler.setCooldown(player, ASSpells.intensifying_focus);
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.intensifying_focus, ASPotions.intensifying_focus);
                        } else if (potion.equals(ASPotions.continuity_charm)) {
                            PotionEffect effect = (PotionEffect)entry.getValue();
                            modifiers = event.getModifiers();
                            duration = modifiers.get(WizardryItems.duration_upgrade);
                            float cost = modifiers.get("cost");
                            level = effect.func_76458_c() + 1;
                            if (level > 0) {
                                modifiers.set(WizardryItems.duration_upgrade, duration + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, true);
                                modifiers.set("cost", cost + (float)level * 0.15f, true);
                            }
                            ASEventHandler.onMetaMagicFinished(player, ASSpells.continuity_charm, ASPotions.continuity_charm);
                        }
                    }
                    int level = ((PotionEffect)entry.getValue()).func_76458_c() + 1;
                    if (potion == ASPotions.spell_blast) {
                        modifiers = event.getModifiers();
                        float blast = modifiers.get(WizardryItems.blast_upgrade);
                        modifiers.set(WizardryItems.blast_upgrade, blast + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
                    }
                    if (potion == ASPotions.spell_range) {
                        modifiers = event.getModifiers();
                        range = modifiers.get(WizardryItems.range_upgrade);
                        modifiers.set(WizardryItems.range_upgrade, range + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
                    }
                    if (potion == ASPotions.spell_cooldown) {
                        modifiers = event.getModifiers();
                        float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                        modifiers.set(WizardryItems.cooldown_upgrade, cooldown - (float)level * Constants.COOLDOWN_REDUCTION_PER_LEVEL, true);
                    }
                    if (potion != ASPotions.spell_duration) continue;
                    modifiers = event.getModifiers();
                    duration = modifiers.get(WizardryItems.duration_upgrade);
                    modifiers.set(WizardryItems.duration_upgrade, duration + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, false);
                }
            }
            EntityPlayer player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            int jewelsSetCount = 0;
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.belt_enchanter) && event.getSpell().getType() == SpellType.BUFF) {
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 1.2f, false);
            }
            for (ItemArtefact itemArtefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (itemArtefact == ASItems.ring_shivering && event.getSpell().getElement() == Element.ICE && !player.func_184811_cZ().func_185141_a(ASItems.ring_shivering)) {
                    player.func_184811_cZ().func_185145_a(ASItems.ring_shivering, 100);
                    for (EntityLivingBase currTarget : EntityUtils.getEntitiesWithinRadius((double)4.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class)) {
                        if (currTarget == player || AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)currTarget)) continue;
                        if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)currTarget)) {
                            EntityUtils.attackEntityWithoutKnockback((Entity)currTarget, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)3.5f);
                            currTarget.func_70690_d(new PotionEffect(WizardryPotions.frost, 60, 0));
                        }
                        double angle = (EnumElementalSwordEffect.getAngleBetweenEntities((Entity)player, (Entity)currTarget) + 90.0) * Math.PI / 180.0;
                        double distance = player.func_70032_d((Entity)currTarget) - 4.0f;
                        currTarget.field_70159_w += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle);
                        currTarget.field_70179_y += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle);
                    }
                    if (player.field_70170_p.field_72995_K) {
                        int i;
                        for (i = 0; i < 10; ++i) {
                            double particleX = player.field_70165_t - 1.0 + 2.0 * player.field_70170_p.field_73012_v.nextDouble();
                            double particleZ = player.field_70161_v - 1.0 + 2.0 * player.field_70170_p.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(particleX, player.field_70163_u + 1.0, particleZ).vel((particleX - player.field_70165_t) * 0.3, 0.0, (particleZ - player.field_70161_v) * 0.3).time(20).spawn(player.field_70170_p);
                        }
                        for (i = 0; i < 40; ++i) {
                            double particleX = player.field_70165_t - 1.0 + 2.0 * player.field_70170_p.field_73012_v.nextDouble();
                            double particleZ = player.field_70161_v - 1.0 + 2.0 * player.field_70170_p.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).pos(particleX, player.field_70163_u + 1.0, particleZ).vel((particleX - player.field_70165_t) * 0.3, 0.0, (particleZ - player.field_70161_v) * 0.3).time(20).spawn(player.field_70170_p);
                        }
                    }
                } else if (itemArtefact == ASItems.charm_focus_stone && !player.field_70170_p.field_72995_K && !player.func_184811_cZ().func_185141_a(ASItems.charm_focus_stone)) {
                    List<ItemStack> list = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.CHARM);
                    if (!list.isEmpty() && list.get(0).func_77973_b() instanceof ItemFocusStone) {
                        player.func_184811_cZ().func_185145_a(ASItems.charm_focus_stone, 5);
                        ItemStack stack = list.get(0);
                        float charge = ItemFocusStone.getCharge(stack);
                        if (charge < 1.0f) {
                            float newCharge = charge + 0.1f;
                            if (newCharge >= 1.0f && charge < 1.0f) {
                                ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_focus_stone.fully_charged", false, new Object[0]);
                            } else if (newCharge >= 0.8f) {
                                ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_focus_stone.charged_n", false, (int)(newCharge * 100.0f));
                            }
                            ItemFocusStone.addCharge(stack, 0.1f);
                            ASBaublesIntegration.setArtefactToSlot(player, stack, ItemArtefact.Type.CHARM);
                        } else if (charge == 1.0f) {
                            ItemFocusStone.resetCharge(stack);
                            ASBaublesIntegration.setArtefactToSlot(player, stack, ItemArtefact.Type.CHARM);
                            modifiers.set("potency", modifiers.get("potency") + 0.3f, true);
                            modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + 0.75f, true);
                            modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + 0.75f, true);
                            modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + 0.75f, false);
                            modifiers.set(WizardryItems.siphon_upgrade, modifiers.get(WizardryItems.siphon_upgrade) + 0.75f, false);
                        }
                    }
                } else if (itemArtefact == ASItems.head_curse) {
                    float potency = modifiers.get("potency");
                    float potencyBonus = 1.0f;
                    for (Potion potion : player.func_193076_bZ().keySet()) {
                        if (!(potion instanceof Curse)) continue;
                        potencyBonus += 0.1f;
                    }
                    if (potencyBonus >= 1.0f) {
                        modifiers.set("potency", potencyBonus * potency, false);
                    }
                } else if (itemArtefact == ASItems.belt_scroll_holder && ASBaublesIntegration.enabled()) {
                    ItemStack scroll;
                    List<ItemStack> holder = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.BELT);
                    if (!holder.isEmpty() && holder.get(0).func_77973_b() instanceof ItemBeltScrollHolder && (scroll = ItemBeltScrollHolder.getScroll(holder.get(0))).func_77973_b() instanceof ItemWandUpgrade) {
                        if (scroll.func_77973_b() == WizardryItems.blast_upgrade) {
                            modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + 0.25f, true);
                        } else if (scroll.func_77973_b() == WizardryItems.range_upgrade) {
                            modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + 0.25f, true);
                        } else if (scroll.func_77973_b() == WizardryItems.duration_upgrade) {
                            modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + 0.25f, true);
                        } else if (scroll.func_77973_b() == WizardryItems.cooldown_upgrade) {
                            modifiers.set(WizardryItems.cooldown_upgrade, modifiers.get(WizardryItems.cooldown_upgrade) - 0.15f, true);
                        }
                    }
                } else if (itemArtefact == ASItems.head_lightning && ASBaublesIntegration.enabled() && event.getSpell().getElement() == Element.LIGHTNING && player.field_70170_p.func_180495_p(player.func_180425_c()).func_177230_c() == ASBlocks.lightning_block) {
                    modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + 0.25f, true);
                    modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + 0.25f, true);
                    modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + 0.25f, true);
                }
                float potency = modifiers.get("potency");
                float cost = modifiers.get("cost");
                if (itemArtefact == ASItems.amulet_elemental_offense) {
                    ItemStack amulet;
                    List<ItemStack> amuletz = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.AMULET);
                    if (amuletz.size() == 1 && AbstractItemArtefactWithSlots.getItemForSlot(amulet = amuletz.get(0), 0).func_77973_b() instanceof ItemCrystal) {
                        ItemStack crystal = AbstractItemArtefactWithSlots.getItemForSlot(amulet, 0);
                        if (Element.values()[crystal.func_77960_j()] == event.getSpell().getElement()) {
                            event.getModifiers().set("potency", event.getModifiers().get("potency") + 0.05f, true);
                        }
                    }
                } else if (itemArtefact == ASItems.charm_mana_orb) {
                    modifiers.set("cost", 0.85f * cost, false);
                } else if (itemArtefact == ASItems.amulet_mana) {
                    modifiers.set("cost", 0.9f * cost, false);
                } else if (itemArtefact == ASItems.ring_mana_cost) {
                    modifiers.set("cost", 0.95f * cost, false);
                } else if (itemArtefact == ASItems.ring_blast) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.blast_upgrade) + 0.25f, true);
                } else if (itemArtefact == ASItems.ring_range) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.range_upgrade) + 0.25f, true);
                } else if (itemArtefact == ASItems.ring_duration) {
                    modifiers.set("cost", 1.25f * cost, false);
                    event.getModifiers().set(WizardryItems.duration_upgrade, event.getModifiers().get(WizardryItems.duration_upgrade) + 0.25f, true);
                } else if (itemArtefact == ASItems.charm_elemental_grimoire) {
                    if (event.getSpell().getElement() == Element.FIRE || event.getSpell().getElement() == Element.ICE || event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.1f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_earth_orb) {
                    if (event.getSpell().getElement() == Element.EARTH) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_healing_orb) {
                    if (event.getSpell().getElement() == Element.HEALING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_lightning_orb) {
                    if (event.getSpell().getElement() == Element.LIGHTNING) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_fire_orb) {
                    if (event.getSpell().getElement() == Element.FIRE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_ice_orb) {
                    if (event.getSpell().getElement() == Element.ICE) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_necromancy_orb) {
                    if (event.getSpell().getElement() == Element.NECROMANCY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_sorcery_orb) {
                    if (event.getSpell().getElement() == Element.SORCERY) {
                        modifiers.set("potency", 0.01f * (float)Settings.generalSettings.orb_artefact_potency_bonus + potency, false);
                    } else {
                        modifiers.set("potency", -0.5f + potency, false);
                    }
                } else if (itemArtefact instanceof ItemElementalCloak) {
                    ItemElementalCloak cloak = (ItemElementalCloak)itemArtefact;
                    Element cloakElement = cloak.getElement();
                    if (event.getSpell().getElement() == cloakElement) {
                        float potencyBonus = 1.0f + (float)Settings.generalSettings.cloak_potency_bonus / 100.0f;
                        modifiers.set("potency", potency * potencyBonus, false);
                    }
                } else if (itemArtefact == ASItems.head_chaos_magic) {
                    if (event.getSpell() instanceof IClassSpell && ((IClassSpell)event.getSpell()).getArmourClass() == ItemWizardArmour.ArmourClass.WARLOCK) {
                        modifiers.set("potency", 1.25f * potency, false);
                    }
                } else if (itemArtefact == ASItems.charm_infernal_stone) {
                    ItemStack stoneStack = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.CHARM).get(0);
                    if (event.getSpell().getElement() == Element.FIRE) {
                        if (ItemInfernalStone.isHot(stoneStack)) {
                            ItemInfernalStone.applyFireSpellBonuses(event.getModifiers(), stoneStack);
                            ItemInfernalStone.consumeHeatForSpell(stoneStack);
                        }
                        if (player.func_70027_ad()) {
                            event.getModifiers().set("potency", event.getModifiers().get("potency") * 1.15f, false);
                            player.func_70066_B();
                            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 40));
                        }
                    }
                }
                if (itemArtefact == ASItems.ring_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.05f + potency, false);
                    modifiers.set("cost", 0.05f + cost, false);
                    continue;
                }
                if (itemArtefact == ASItems.amulet_power) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.1f + potency, false);
                    modifiers.set("cost", 0.1f + cost, false);
                    continue;
                }
                if (itemArtefact == ASItems.charm_power_orb) {
                    ++jewelsSetCount;
                    modifiers.set("potency", 0.2f + potency, false);
                    modifiers.set("cost", 0.2f + cost, false);
                    continue;
                }
                if (!(itemArtefact instanceof ItemElementalBelt)) continue;
                ItemElementalBelt cloak = (ItemElementalBelt)itemArtefact;
                Element element = cloak.getElement();
                int mod = element == event.getSpell().getElement() ? 1 : -1;
                modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + Constants.BLAST_RADIUS_INCREASE_PER_LEVEL * (float)mod, true);
                modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + Constants.RANGE_INCREASE_PER_LEVEL * (float)mod, true);
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + Constants.DURATION_INCREASE_PER_LEVEL * (float)mod, false);
                modifiers.set(WizardryItems.siphon_upgrade, modifiers.get(WizardryItems.siphon_upgrade) + (float)(5 * mod), false);
            }
            if (jewelsSetCount > 1) {
                float potency = modifiers.get("potency");
                float f = (float)(jewelsSetCount - 1) * 5.0f / 100.0f;
                modifiers.set("potency", f + potency, false);
            }
            if ((data = WizardData.get((EntityPlayer)player)) != null) {
                Optional<Element> optional;
                Optional<Element> optional2 = AbsorbCrystal.getElement(data);
                if (optional2.isPresent() && event.getSpell().getElement() == optional2.get()) {
                    modifiers.set("potency", modifiers.get("potency") + (AbsorbCrystal.isBlock(data) ? 0.1f : 0.05f), false);
                }
                if ((optional = ElementalAttunement.getElement(player)).isPresent()) {
                    int mod = event.getSpell().getElement() == optional.get() ? 1 : -1;
                    modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) + (float)mod * 0.25f, false);
                    modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) + (float)mod * 0.25f, false);
                    modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) + (float)mod * 0.25f, false);
                    modifiers.set(WizardryItems.siphon_upgrade, modifiers.get(WizardryItems.siphon_upgrade) + (float)mod * 0.25f, false);
                }
                if (!(event.getSpell() instanceof Contingency)) {
                    if (data.getVariable(MetamagicProjectile.METAMAGIC_PROJECTILE) != null && ((Boolean)data.getVariable(MetamagicProjectile.METAMAGIC_PROJECTILE)).booleanValue()) {
                        String spellName = event.getSpell().getRegistryName().toString();
                        if (event.getSpell() instanceof MetaSpellBuff || event.getSpell() instanceof SpellRay || event.getSpell() instanceof SpellProjectile || event.getSpell() instanceof MetamagicProjectile || Arrays.asList(Settings.generalSettings.metamagic_projectile_incompatible_spells).contains(spellName)) {
                            return;
                        }
                        EntityMetamagicProjectile projectile = new EntityMetamagicProjectile(player.field_70170_p);
                        projectile.setCaster((EntityLivingBase)player);
                        projectile.setStoredSpell(event.getSpell());
                        projectile.aim((EntityLivingBase)player, ASEventHandler.calculateVelocity(projectile, modifiers, player.func_70047_e() - 0.1f));
                        projectile.damageMultiplier = modifiers.get("potency");
                        if (!player.field_70170_p.field_72995_K) {
                            player.field_70170_p.func_72838_d((Entity)projectile);
                        }
                        data.setVariable(MetamagicProjectile.METAMAGIC_PROJECTILE, null);
                        event.setCanceled(true);
                        return;
                    }
                    NBTTagCompound activeContingencyListener = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER);
                    if (activeContingencyListener != null && activeContingencyListener.func_74764_b("active_listener")) {
                        if (player.func_70093_af() && Contingency.Type.fromName(activeContingencyListener.func_74779_i("active_listener")) == Contingency.Type.DEATH) {
                            EntityContingencyProjectile projectile = new EntityContingencyProjectile(player.field_70170_p);
                            projectile.setCaster((EntityLivingBase)player);
                            projectile.setStoredSpell(event.getSpell());
                            projectile.setContingencyType(Contingency.Type.fromName(activeContingencyListener.func_74779_i("active_listener")));
                            projectile.aim((EntityLivingBase)player, ASEventHandler.calculateVelocity(projectile, modifiers, player.func_70047_e() - 0.1f));
                            projectile.damageMultiplier = modifiers.get("potency");
                            if (!event.getWorld().field_72995_K) {
                                player.field_70170_p.func_72838_d((Entity)projectile);
                            }
                            data.setVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER, null);
                            Contingency.playSound(event.getWorld(), player.func_180425_c());
                            event.setCanceled(true);
                            return;
                        }
                        String spellTag = activeContingencyListener.func_74779_i("active_listener");
                        Spell contingency = (Spell)Spell.registry.getValue(new ResourceLocation(spellTag));
                        Spell spellToStore = event.getSpell();
                        NBTTagCompound activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES);
                        if (activeContingencies == null) {
                            activeContingencies = new NBTTagCompound();
                        }
                        activeContingencies.func_74778_a(contingency.getRegistryName().toString(), spellToStore.getRegistryName().toString());
                        if (event.getSource() == SpellCastEvent.Source.WAND) {
                            if (player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                                ((ItemWand)player.func_184614_ca().func_77973_b()).consumeMana(player.func_184614_ca(), spellToStore.getCost(), (EntityLivingBase)player);
                                if (!spellToStore.isContinuous && !player.func_184812_l_()) {
                                    WandHelper.setCurrentCooldown((ItemStack)player.func_184614_ca(), (int)((int)((float)spellToStore.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
                                }
                            } else if (player.func_184592_cb().func_77973_b() instanceof ItemWand) {
                                ((ItemWand)player.func_184592_cb().func_77973_b()).consumeMana(player.func_184592_cb(), spellToStore.getCost(), (EntityLivingBase)player);
                                if (!spellToStore.isContinuous && !player.func_184812_l_()) {
                                    WandHelper.setCurrentCooldown((ItemStack)player.func_184592_cb(), (int)((int)((float)spellToStore.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
                                }
                            }
                        } else if (event.getSource() == SpellCastEvent.Source.SCROLL) {
                            if (player.func_184614_ca().func_77973_b() instanceof ItemScroll) {
                                player.func_184614_ca().func_190918_g(1);
                                player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), spellToStore.getCooldown());
                            } else if (player.func_184592_cb().func_77973_b() instanceof ItemScroll) {
                                player.func_184592_cb().func_190918_g(1);
                                player.func_184811_cZ().func_185145_a(player.func_184614_ca().func_77973_b(), spellToStore.getCooldown());
                            }
                        }
                        if (event.getWorld().field_72995_K) {
                            Contingency.spawnParticles(event.getWorld(), (EntityLivingBase)player, Contingency.Type.fromName(spellTag));
                        }
                        Contingency.playSound(event.getWorld(), player.func_180425_c());
                        data.setVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER, null);
                        data.setVariable(Contingency.ACTIVE_CONTINGENCIES, (Object)activeContingencies);
                        data.sync();
                        event.setCanceled(true);
                    }
                }
            }
        }
        if (DimensionalAnchor.shouldPreventSpell(event.getCaster(), event.getWorld(), event.getSpell())) {
            event.setCanceled(true);
        }
        if (event.getSpell().getType() == SpellType.MINION && event.getCaster() instanceof EntityPlayer) {
            List playersNearby = EntityUtils.getEntitiesWithinRadius((double)20.0, (double)event.getCaster().field_70165_t, (double)event.getCaster().field_70163_u, (double)event.getCaster().field_70161_v, (World)event.getWorld(), EntityPlayer.class);
            for (EntityPlayer player : playersNearby) {
                if (!ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_conjuration_inhibitor)) continue;
                List entities = EntityUtils.getEntitiesWithinRadius((double)20.0, (double)event.getCaster().field_70165_t, (double)event.getCaster().field_70163_u, (double)event.getCaster().field_70161_v, (World)event.getWorld(), Entity.class);
                int minionCount = 0;
                for (Entity entity : entities) {
                    if (!(entity instanceof ISummonedCreature)) continue;
                    ++minionCount;
                }
                if (minionCount < 2) continue;
                ASUtils.sendMessage((Entity)event.getCaster(), "item.ancientspellcraft:charm_conjuration_inhibitor.message", true, new Object[0]);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        EntityLivingBase caster = event.getCaster();
        if (caster != null) {
            List nearbyPlayers = EntityUtils.getEntitiesWithinRadius((double)15.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, EntityPlayer.class);
            for (EntityPlayer nearbyPlayer : nearbyPlayers) {
                Spell spell;
                boolean offhand = nearbyPlayer.func_184592_cb().func_77973_b() == ASItems.charm_arcane_mirror;
                if (!offhand || nearbyPlayer.func_184592_cb().func_77973_b() != ASItems.charm_arcane_mirror || (spell = ((ISpellCastingItem)nearbyPlayer.func_184592_cb().func_77973_b()).getCurrentSpell(nearbyPlayer.func_184592_cb())) != Spells.none) continue;
                ((ItemArcaneMirror)nearbyPlayer.func_184592_cb().func_77973_b()).setSpell(nearbyPlayer.func_184592_cb(), event.getSpell());
            }
        }
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            ASEventHandler.handleCloakEffects(player, event.getSpell());
            ASEventHandler.handleRingOfHealerEffect(player, event.getSpell(), event.getModifiers());
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_knowledge_orb)) {
                boolean flag = false;
                if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemWand) {
                    if (((ItemWand)player.func_184614_ca().func_77973_b()).tier.level == Tier.MASTER.level) {
                        flag = true;
                    }
                } else if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemWand && ((ItemWand)player.func_184592_cb().func_77973_b()).tier.level == Tier.MASTER.level) {
                    flag = true;
                }
                if (flag) {
                    int progression = (int)((float)event.getSpell().getCost() * event.getModifiers().get("progression"));
                    List<ItemStack> wands = ASUtils.getAllHotbarWands(player, Tier.ADVANCED);
                    if (wands != null && !wands.isEmpty()) {
                        ItemStack targetWand = ASUtils.getRandomListItem(wands);
                        WandHelper.addProgression((ItemStack)targetWand, (int)progression);
                        Tier nextTier = Tier.values()[((ItemWand)targetWand.func_77973_b()).tier.ordinal() + 1];
                        int excess = WandHelper.getProgression((ItemStack)targetWand) - nextTier.getProgression();
                        if (excess >= 0 && excess < progression) {
                            player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                            if (!player.field_70170_p.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{targetWand.func_77973_b().func_77653_i(targetWand), nextTier.getNameForTranslationFormatted()}));
                            }
                        }
                    }
                }
            }
        }
    }

    private static void handleCloakEffects(EntityPlayer player, Spell spell) {
        for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
            if (!(artefact instanceof ItemElementalCloak) || player.field_70170_p.field_72995_K) continue;
            ItemElementalCloak cloak = (ItemElementalCloak)artefact;
            Element cloakElement = cloak.getElement();
            if (spell.getElement() != cloakElement) continue;
            ASEventHandler.applyCloakEffect(player, cloakElement, spell);
        }
    }

    private static void handleRingOfHealerEffect(EntityPlayer player, Spell spell, SpellModifiers modifiers) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_healer) && (spell.getType() == SpellType.BUFF || spell instanceof SpellBuff)) {
            List nearbyAllies = EntityUtils.getEntitiesWithinRadius((double)10.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
            for (EntityLivingBase ally : nearbyAllies) {
                if (ally == player || !AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)ally) || !(spell instanceof SpellBuff)) continue;
                SpellBuff buffSpell = (SpellBuff)spell;
                try {
                    Field field = ASUtils.ReflectionUtil.getField(buffSpell.getClass(), "potionSet");
                    ASUtils.ReflectionUtil.makeAccessible(field);
                    Set potionSet = (Set)field.get(buffSpell);
                    for (Potion potion : potionSet) {
                        if (potion.func_76398_f()) continue;
                        int originalDuration = (int)(buffSpell.getProperty(potion.getRegistryName().func_110623_a() + "_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                        int allyDuration = (int)Math.max(1.0, (double)originalDuration * 0.2);
                        int bonusAmplifier = SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"));
                        int amplifier = (int)buffSpell.getProperty(potion.getRegistryName().func_110623_a() + "_strength").floatValue() + bonusAmplifier;
                        ally.func_70690_d(new PotionEffect(potion, allyDuration, amplifier, false, true));
                    }
                }
                catch (Exception e) {
                    AncientSpellcraft.logger.warn("Failed to apply ring of healer effect: " + e.getMessage());
                }
            }
        }
    }

    private static void applyCloakEffect(EntityPlayer player, Element element, Spell spell) {
        switch (element) {
            case EARTH: {
                player.func_184589_d(MobEffects.field_76436_u);
                if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.3f)) break;
                List nearbyEntities = EntityUtils.getEntitiesWithinRadius((double)6.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
                for (EntityLivingBase entity : nearbyEntities) {
                    if (entity == player || entity instanceof EntityPlayer) continue;
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 0));
                }
                break;
            }
            case FIRE: {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 0));
                if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.4f)) break;
                List nearbyEntities = EntityUtils.getEntitiesWithinRadius((double)5.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
                for (EntityLivingBase entity : nearbyEntities) {
                    if (entity == player || entity instanceof EntityPlayer) continue;
                    entity.func_70015_d(3);
                }
                break;
            }
            case HEALING: {
                List entitiesWithinRadius = EntityUtils.getEntitiesWithinRadius((double)8.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
                for (EntityLivingBase ally : entitiesWithinRadius) {
                    if (ally == player || !AllyDesignationSystem.isAllied((EntityLivingBase)player, (EntityLivingBase)ally)) continue;
                    float healAmount = ally.func_110138_aP() * 0.05f;
                    ally.func_70691_i(healAmount);
                    if (!(ally.func_110143_aJ() >= ally.func_110138_aP())) continue;
                    ally.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 0));
                }
                break;
            }
            case ICE: {
                player.func_70066_B();
                boolean inSnowyBiome = false;
                try {
                    Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
                    if (biome.getRegistryName() != null) {
                        String biomeName = biome.getRegistryName().toString().toLowerCase();
                        inSnowyBiome = biomeName.contains("tundra") || biomeName.contains("snow") || biomeName.contains("ice") || biomeName.contains("frozen") || biomeName.contains("cold");
                    }
                }
                catch (Exception biome) {
                    // empty catch block
                }
                if (!inSnowyBiome && !player.func_70644_a(MobEffects.field_76421_d)) break;
                player.func_70691_i(2.0f);
                break;
            }
            case NECROMANCY: {
                List nearbyEntities = EntityUtils.getEntitiesWithinRadius((double)10.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
                for (EntityLivingBase entity : nearbyEntities) {
                    int currentLifetime;
                    ISummonedCreature minion;
                    if (!(entity instanceof ISummonedCreature) || (minion = (ISummonedCreature)entity).getCaster() != player || (currentLifetime = minion.getLifetime()) <= 0) continue;
                    minion.setLifetime(currentLifetime + 60);
                }
                break;
            }
            case SORCERY: {
                if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.25f)) break;
                ArrayList<Potion> beneficialPotions = new ArrayList<Potion>();
                for (String potionName : Settings.generalSettings.sorcery_cloak_potion_effects) {
                    try {
                        Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
                        if (potion != null) {
                            beneficialPotions.add(potion);
                            continue;
                        }
                        AncientSpellcraft.logger.warn("Potion not found for sorcery cloak effect: " + potionName);
                    }
                    catch (Exception e) {
                        AncientSpellcraft.logger.warn("Invalid potion registry name for sorcery cloak effect: " + potionName);
                    }
                }
                if (beneficialPotions.isEmpty()) {
                    beneficialPotions.addAll(Arrays.asList(MobEffects.field_76424_c, MobEffects.field_76430_j, MobEffects.field_76420_g, MobEffects.field_76428_l, MobEffects.field_76444_x, MobEffects.field_188425_z, MobEffects.field_76439_r, MobEffects.field_76427_o, MobEffects.field_76429_m));
                }
                Potion randomPotion = (Potion)beneficialPotions.get(player.field_70170_p.field_73012_v.nextInt(beneficialPotions.size()));
                player.func_70690_d(new PotionEffect(randomPotion, 100, 0));
                break;
            }
            case LIGHTNING: {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, 1));
                if (!(player.field_70170_p.field_73012_v.nextFloat() < 0.35f)) break;
                List nearbyEntities2 = EntityUtils.getEntitiesWithinRadius((double)6.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class);
                for (EntityLivingBase entity : nearbyEntities2) {
                    if (entity == player || entity instanceof EntityPlayer) continue;
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 0));
                }
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArcaneWorkbenchApplyButtonPressed(SpellBindEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            int centre_slot = 9;
            int upgrade_slot = 10;
            ItemStack centre = event.getContainer().func_75139_a(centre_slot).func_75211_c();
            ItemStack upgrade = event.getContainer().func_75139_a(upgrade_slot).func_75211_c();
            EntityPlayer player = event.getEntityPlayer();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != ASItems.charm_wand_upgrade || !(player.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !WandHelper.isWandUpgrade((Item)upgrade.func_77973_b()) || !(centre.func_77973_b() instanceof ItemWand)) continue;
                Item specialUpgrade = upgrade.func_77973_b();
                if (WandHelper.getTotalUpgrades((ItemStack)centre) >= ((ItemWand)centre.func_77973_b()).tier.upgradeLimit || WandHelper.getUpgradeLevel((ItemStack)centre, (Item)specialUpgrade) >= 3) continue;
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), true);
                player.func_191521_c(new ItemStack(specialUpgrade));
            }
        }
    }

    private static Spell getCurrentSpellFromSpellBearingArtefact(Item item, ItemStack stack) {
        return Spell.byMetadata((int)stack.func_77952_i());
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.START) {
            WizardData data;
            player = event.player;
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float i;
                if (artefact != ASItems.ring_prismarine || !player.func_70027_ad() || (i = player.func_184811_cZ().func_185143_a(ASItems.ring_prismarine, 0.0f)) != 0.0f) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 120));
                SpellModifiers modifiers = new SpellModifiers();
                if (!ASSpells.extinguish.cast(player.field_70170_p, player, EnumHand.MAIN_HAND, 0, modifiers)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.SCROLL, ASSpells.extinguish, (EntityLivingBase)player, modifiers));
                player.func_184811_cZ().func_185145_a(ASItems.ring_prismarine, 1200);
            }
            if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 6 == 0) {
                NBTTagCompound activeContingencies;
                if (event.player.field_71093_bK == ASDimensions.POCKET_DIM_ID && !event.player.func_70644_a(ASPotions.dimensional_anchor)) {
                    event.player.func_70690_d(new PotionEffect(ASPotions.dimensional_anchor, 200000));
                }
                if ((data = WizardData.get((EntityPlayer)player)) != null && (activeContingencies = (NBTTagCompound)data.getVariable(Contingency.ACTIVE_CONTINGENCIES)) != null && activeContingencies.func_74764_b(Contingency.Type.IMMOBILITY.spellName)) {
                    for (BlockPos pos : Arrays.asList(player.func_180425_c(), player.func_180425_c().func_177984_a())) {
                        if (player.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151569_G && player.field_70170_p.func_180495_p(pos).func_177230_c() != ASBlocks.QUICKSAND && !player.field_70170_p.func_180495_p(pos).func_177230_c().getRegistryName().toString().equals("biomesoplenty:quicksand")) continue;
                        Contingency.tryCastContingencySpell(player, data, Contingency.Type.IMMOBILITY);
                        break;
                    }
                }
            }
            if (player.field_70170_p.field_72995_K && player.field_70173_aa % 21 == 0 && WizardData.get((EntityPlayer)player) != null && WizardData.get((EntityPlayer)player).getVariable(AbsorbPotion.EFFECT) != null) {
                Potion potion;
                data = WizardData.get((EntityPlayer)player);
                String potionName = (String)data.getVariable(AbsorbPotion.EFFECT);
                Integer duration = (Integer)data.getVariable(AbsorbPotion.DURATION);
                if (potionName != null && !potionName.equals("none") && (potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName))) != null) {
                    for (int i = 0; i < 10; ++i) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).scale(1.0f).pos(0.0, 0.2, 0.0).entity((Entity)player).clr(potion.func_76401_j()).spin((double)ASSpells.absorb_potion.getProperty("effect_radius").intValue(), 0.02).time(60).spawn(player.field_70170_p);
                    }
                    for (EntityLivingBase target : EntityUtils.getEntitiesWithinRadius((double)ASSpells.absorb_potion.getProperty("effect_radius").floatValue(), (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, EntityLivingBase.class)) {
                        if (target != player && potion == MobEffects.field_76441_p) continue;
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SCORCH).pos(target.field_70165_t, target.field_70163_u + 0.101, target.field_70161_v).face(EnumFacing.UP).clr(potion.func_76401_j()).collide(false).scale(2.3f).time(40).spawn(event.player.field_70170_p);
                    }
                }
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            player = event.player;
            if (ASBaublesIntegration.enabled()) {
                ASBaublesIntegration.tickWornArtefacts(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArtefactCheckEvent(ArtefactCheckEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184592_cb().func_77973_b() instanceof ItemBattlemageShield && ItemBattlemageShield.getArtefacts(event.getPlayer().func_184592_cb()).stream().anyMatch(s -> s.func_77973_b() == event.getArtefact())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckSpawnEvent(EntityJoinWorldEvent event) {
        Entity owner;
        if (event.getEntity() instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)event.getEntity();
            for (EntityPlayer player : event.getWorld().field_73010_i) {
                if (player.field_71093_bK != entityItem.field_71093_bK || !player.func_174813_aQ().func_72326_a(entityItem.func_174813_aQ().func_186662_g(20.0)) || !ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.belt_emberguard)) continue;
                entityItem.func_184224_h(true);
                break;
            }
        }
        if (event.getEntity() instanceof ISummonedCreature && event.getEntity() instanceof EntityCreature && ((ISummonedCreature)event.getEntity()).func_70902_q() != null && (owner = ((ISummonedCreature)event.getEntity()).func_70902_q()) instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)owner), (Item)ASItems.head_minions) && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)owner), (Item)ASItems.head_minions)) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            EntitySummonAIFollowOwner task = new EntitySummonAIFollowOwner(creature, 1.0, 10.0f, 2.0f);
            creature.field_70714_bg.func_75776_a(5, (EntityAIBase)task);
        }
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityLivingBase) {
                EntityLivingBase archer = (EntityLivingBase)arrow.field_70250_c;
                ItemStack bow = archer.func_184614_ca();
                if (!ImbueWeapon.isBow((ItemStack)bow) && !ImbueWeapon.isBow((ItemStack)(bow = archer.func_184592_cb()))) {
                    return;
                }
                int level = EnchantmentHelper.func_77506_a((Enchantment)ASEnchantments.degrade_bow, (ItemStack)bow);
                if (level > 0) {
                    arrow.func_70239_b(arrow.func_70242_d() * (1.5 / (double)(level + 1)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ItemSoulboundWandUpgrade.restoreStoredWandsToInventory(event.player);
    }

    @SubscribeEvent
    public static void onResurrectionEvent(ResurrectionEvent event) {
        ItemSoulboundWandUpgrade.restoreStoredWandsToInventory(event.getEntityPlayer());
    }

    public static float calculateVelocity(EntityMagicProjectile projectile, SpellModifiers modifiers, float launchHeight) {
        float range = 20.0f * modifiers.get(WizardryItems.range_upgrade);
        if (projectile.func_189652_ae()) {
            if (projectile.getLifetime() <= 0) {
                return 1.5f;
            }
            return range / (float)projectile.getLifetime();
        }
        float g = 0.03f;
        return range / MathHelper.func_76129_c((float)(2.0f * launchHeight / g));
    }

    static {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{COUNTDOWN_KEY, SPELL_ID});
    }
}

