/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.integration.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.AbstractItemArtefactWithSlots;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.AbsorbArtefact;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public final class ASBaublesIntegration {
    public static final String BAUBLES_MOD_ID = "baubles";
    private static final Map<ItemArtefact.Type, BaubleType> WIZARDRY_ARTEFACT_TYPE_MAP = new EnumMap<ItemArtefact.Type, BaubleType>(ItemArtefact.Type.class);
    private static boolean baublesLoaded;

    public static void init() {
        baublesLoaded = Loader.isModLoaded((String)BAUBLES_MOD_ID);
        if (!ASBaublesIntegration.enabled()) {
            return;
        }
        WIZARDRY_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.RING, BaubleType.RING);
        WIZARDRY_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.AMULET, BaubleType.AMULET);
        WIZARDRY_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.CHARM, BaubleType.CHARM);
        WIZARDRY_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.BELT, BaubleType.BELT);
        WIZARDRY_ARTEFACT_TYPE_MAP.put(ItemArtefact.Type.HEAD, BaubleType.HEAD);
    }

    public static boolean enabled() {
        return Settings.generalSettings.baubles_integration && baublesLoaded;
    }

    public static List<ItemStack> getEquippedArtefactStacks(EntityPlayer player, ItemArtefact.Type ... types) {
        ArrayList<ItemStack> artefacts = new ArrayList<ItemStack>();
        for (ItemArtefact.Type type : types) {
            for (int slot : WIZARDRY_ARTEFACT_TYPE_MAP.get(type).getValidSlots()) {
                ItemStack stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot);
                if (!(stack.func_77973_b() instanceof ItemArtefact)) continue;
                artefacts.add(stack);
            }
        }
        return artefacts;
    }

    public static ItemStack getBeltSlotItemStack(EntityPlayer player) {
        int beltSlot;
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack stack = baubles.getStackInSlot(beltSlot = 3);
        if (stack != null) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static void setArtefactToSlot(EntityPlayer player, ItemStack stack, ItemArtefact.Type type) {
        ASBaublesIntegration.setArtefactToSlot(player, stack, type, 0);
    }

    public static void setArtefactToSlot(EntityPlayer player, ItemStack stack, ItemArtefact.Type type, int slotId) {
        BaublesApi.getBaublesHandler((EntityPlayer)player).setStackInSlot(WIZARDRY_ARTEFACT_TYPE_MAP.get(type).getValidSlots()[slotId], stack);
    }

    public static void tickWornArtefacts(EntityPlayer player) {
        ItemStack belt;
        List<ItemStack> list;
        ItemStack stack;
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles.getSlots(); ++i) {
            stack = baubles.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ITickableArtefact)) continue;
            ((ITickableArtefact)stack.func_77973_b()).onWornTick(stack, (EntityLivingBase)player);
        }
        Optional<Item> artefact = AbsorbArtefact.getArtefact(WizardData.get((EntityPlayer)player));
        if (artefact.isPresent() && (stack = new ItemStack(artefact.get())).func_77973_b() instanceof ITickableArtefact) {
            ((ITickableArtefact)stack.func_77973_b()).onWornTick(stack, (EntityLivingBase)player);
        }
        if ((list = ASBaublesIntegration.getEquippedArtefactStacks(player, ItemArtefact.Type.BELT)).size() == 1 && (belt = list.get(0)).func_77973_b() == ASItems.belt_hook && belt.func_77942_o() && AbstractItemArtefactWithSlots.getItemForSlot(belt, 0).func_77973_b() instanceof ITickableArtefact) {
            ((ITickableArtefact)AbstractItemArtefactWithSlots.getItemForSlot(belt, 0).func_77973_b()).onWornTick(AbstractItemArtefactWithSlots.getItemForSlot(belt, 0), (EntityLivingBase)player);
        }
    }
}

