/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.integration.jei;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.integration.jei.ArcaneAnvilRecipeCategory;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.Wizardry;
import java.util.Arrays;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@JEIPlugin
public class ASJEIIntegration
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (!Settings.generalSettings.jei_integration) {
            return;
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new ArcaneAnvilRecipeCategory(registry)});
    }

    public void register(IModRegistry registry) {
        if (!Wizardry.settings.jeiIntegration) {
            return;
        }
        registry.addRecipeCatalyst((Object)new ItemStack(ASBlocks.ARCANE_ANVIL), new String[]{"ancientspellcraft:arcane_anvil"});
        registry.addRecipes(ArcaneAnvilRecipeCategory.generateRecipes(), "ancientspellcraft:arcane_anvil");
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ASJEIIntegration.addItemInfo(registry, Item.func_150898_a((Block)ASBlocks.SCRIBING_DESK), ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, Item.func_150898_a((Block)ASBlocks.SPHERE_COGNIZANCE), ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, Item.func_150898_a((Block)ASBlocks.DEVORITIUM_BLOCK), ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_fire, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_ice, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_lightning, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_necromancy, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_earth, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_sorcery, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.crystal_shard_healing, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.devoritium_bomb, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.devoritium_sword, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.devoritium_arrow, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.devoritium_door, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.devoritium_ingot, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.astral_diamond_charged, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.stone_tablet_small, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.stone_tablet, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.stone_tablet_large, ".desc_extended");
        ASJEIIntegration.addItemInfo(registry, ASItems.stone_tablet_grand, ".desc_extended");
    }

    private static void addItemInfo(IModRegistry registry, Item item, String ... suffixes) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), subItems);
        for (ItemStack stack : subItems) {
            ASJEIIntegration.addItemInfo(registry, stack, suffixes);
        }
    }

    private static void addItemInfo(IModRegistry registry, ItemStack stack, String ... suffixes) {
        String prefix = stack.func_77973_b().func_77667_c(stack);
        String[] keys = (String[])Arrays.stream(suffixes).map(s -> prefix + s).toArray(String[]::new);
        registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, keys);
    }
}

