/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.integration.jei;

import com.windanesz.ancientspellcraft.integration.jei.ArcaneAnvilRecipe;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ArcaneAnvilRecipeCategory
implements IRecipeCategory<ArcaneAnvilRecipe> {
    static final String UID = "ancientspellcraft:arcane_anvil";
    static final ResourceLocation TEXTURE = new ResourceLocation("ancientspellcraft", "textures/integration/jei/arcane_anvil_background.png");
    static final int WIDTH = 139;
    static final int HEIGHT = 58;
    static final int INPUT_SLOT_1_X = 7;
    static final int INPUT_SLOT_1_Y = 20;
    static final int INPUT_SLOT_2_X = 56;
    static final int INPUT_SLOT_2_Y = 20;
    static final int OUTPUT_SLOT_X = 114;
    static final int OUTPUT_SLOT_Y = 20;
    private final IDrawable background;

    public ArcaneAnvilRecipeCategory(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        this.background = helper.createDrawable(TEXTURE, 0, 0, 139, 58);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"integration.jei.category.ancientspellcraft:arcane_anvil", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Ancient Spellcraft by Dan";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcaneAnvilRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup slots = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        slots.init(0, true, 7, 20);
        slots.init(1, true, 56, 20);
        slots.init(2, false, 114, 20);
        for (int j = 0; j < inputs.size(); ++j) {
            slots.set(j, (List)inputs.get(j));
        }
        for (int k = 0; k < outputs.size(); ++k) {
            slots.set(inputs.size() + k, (List)outputs.get(k));
        }
    }

    public static Collection<ArcaneAnvilRecipe> generateRecipes() {
        ArrayList<ArcaneAnvilRecipe> recipes = new ArrayList<ArcaneAnvilRecipe>();
        recipes.addAll(ArcaneAnvilRecipeCategory.generateAnvilRecipes());
        return recipes;
    }

    private static Collection<ArcaneAnvilRecipe> generateAnvilRecipes() {
        ArrayList<ArcaneAnvilRecipe> recipes = new ArrayList<ArcaneAnvilRecipe>();
        ItemStack plating_input1 = new ItemStack(ASItems.crystal_silver_ingot);
        ItemStack plating_input2 = ItemStack.field_190927_a;
        ItemStack plating_output = new ItemStack(WizardryItems.crystal_silver_plating);
        recipes.add(new ArcaneAnvilRecipe(plating_input1, plating_input2, plating_output));
        ItemStack novice_input1 = new ItemStack(ASItems.battlemage_sword_hilt);
        ItemStack novice_input2 = new ItemStack(ASItems.battlemage_sword_blade);
        ItemStack novice_output = new ItemStack(ASItems.battlemage_sword_novice);
        recipes.add(new ArcaneAnvilRecipe(novice_input1, novice_input2, novice_output));
        ItemStack apprentice_input1 = new ItemStack(ASItems.battlemage_sword_novice);
        WandHelper.addProgression((ItemStack)apprentice_input1, (int)Tier.APPRENTICE.getProgression());
        ItemStack apprentice_input2 = new ItemStack(ASItems.crystal_silver_ingot);
        ItemStack apprentice_output = new ItemStack(ASItems.battlemage_sword_apprentice);
        recipes.add(new ArcaneAnvilRecipe(apprentice_input1, apprentice_input2, apprentice_output));
        ItemStack advanced_input1 = new ItemStack(ASItems.battlemage_sword_apprentice);
        WandHelper.addProgression((ItemStack)advanced_input1, (int)Tier.ADVANCED.getProgression());
        ItemStack advanced_input2 = new ItemStack(ASItems.crystal_silver_ingot);
        ItemStack advanced_output = new ItemStack(ASItems.battlemage_sword_advanced);
        recipes.add(new ArcaneAnvilRecipe(advanced_input1, advanced_input2, advanced_output));
        ItemStack master_input1 = new ItemStack(ASItems.battlemage_sword_advanced);
        WandHelper.addProgression((ItemStack)advanced_input1, (int)Tier.MASTER.getProgression());
        ItemStack master_input2 = new ItemStack(ASItems.crystal_silver_ingot);
        ItemStack master_output = new ItemStack(ASItems.battlemage_sword_master);
        recipes.add(new ArcaneAnvilRecipe(master_input1, master_input2, master_output));
        return recipes;
    }
}

