/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.item.IItemWithSlots;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import electroblob.wizardry.item.ItemArtefact;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public abstract class AbstractItemArtefactWithSlots
extends ItemArtefact
implements IItemWithSlots {
    private final int slotCount;
    private final int rows;
    private final int columns;
    private final boolean hasGUI;

    public AbstractItemArtefactWithSlots(EnumRarity rarity, ItemArtefact.Type type, int rows, int columns, boolean hasGUI) {
        super(rarity, type);
        this.rows = rows;
        this.columns = columns;
        this.slotCount = rows * columns;
        this.hasGUI = hasGUI;
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public boolean hasGUI() {
        return this.hasGUI;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.openGui((Object)"ancientspellcraft", GuiHandlerAS.GUI_1_SLOT, world, hand.ordinal(), 0, 0);
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public static boolean isSlotEmpty(ItemStack stack, int slot) {
        int maxCount;
        if (stack.func_77973_b() instanceof AbstractItemArtefactWithSlots && slot <= (maxCount = ((AbstractItemArtefactWithSlots)stack.func_77973_b()).getSlotCount()) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            NBTTagList items = stack.func_77978_p().func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = items.func_150305_b(slot);
            return new ItemStack(nbttagcompound).func_190926_b();
        }
        return true;
    }

    public static ItemStack getItemForSlot(ItemStack stack, int slot) {
        int maxCount;
        if (stack.func_77973_b() instanceof AbstractItemArtefactWithSlots && slot <= (maxCount = ((AbstractItemArtefactWithSlots)stack.func_77973_b()).getSlotCount()) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            NBTTagList items = stack.func_77978_p().func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = items.func_150305_b(slot);
            return new ItemStack(nbttagcompound);
        }
        return ItemStack.field_190927_a;
    }

    public static void setItemForSlot(ItemStack stack, int slot, ItemStack item) {
        int maxCount;
        if (stack.func_77973_b() instanceof AbstractItemArtefactWithSlots && slot <= (maxCount = ((AbstractItemArtefactWithSlots)stack.func_77973_b()).getSlotCount())) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            NBTTagList items = nbt.func_150295_c("Items", 10);
            while (items.func_74745_c() <= slot) {
                items.func_74742_a((NBTBase)new NBTTagCompound());
            }
            items.func_150304_a(slot, (NBTBase)item.func_77955_b(new NBTTagCompound()));
            nbt.func_74782_a("Items", (NBTBase)items);
        }
    }
}

