/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.entity.projectile.EntitySafeIceShard;
import com.windanesz.ancientspellcraft.item.ItemBattlemageSword;
import com.windanesz.ancientspellcraft.item.ItemGlyphArtefact;
import com.windanesz.ancientspellcraft.item.WizardClassWeaponHelper;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.spell.Animate;
import com.windanesz.ancientspellcraft.spell.Runeword;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Disintegration;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public enum EnumElementalSwordEffect {
    MAGIC(Element.MAGIC){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        }
    }
    ,
    FIRE(Element.FIRE){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            target.func_70015_d(3);
            if (AncientSpellcraft.rand.nextDouble() < 0.2 || target.func_110143_aJ() <= 0.0f && AncientSpellcraft.rand.nextDouble() < 0.4) {
                Disintegration.spawnEmbers((World)target.field_70170_p, (EntityLivingBase)wielder, (Entity)target, (int)6);
            }
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            wielder.func_70690_d(new PotionEffect(WizardryPotions.fireskin, 160, 0));
            wielder.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 160, 0));
            if (target.func_70027_ad()) {
                target.func_70690_d(new PotionEffect(ASPotions.soul_scorch, 100, 0));
            }
        }
    }
    ,
    ICE(Element.ICE){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            PotionEffect effect;
            int duration = 40;
            int amplifier = 0;
            if (target.func_70644_a(WizardryPotions.frost) && (effect = target.func_70660_b(WizardryPotions.frost)) != null) {
                duration = effect.func_76459_b() + duration;
                amplifier = effect.func_76458_c();
                if (target.field_70170_p.field_73012_v.nextDouble() < 0.2 && amplifier < 3) {
                    ++amplifier;
                }
            }
            if (AncientSpellcraft.rand.nextDouble() < 0.25 && target.func_110143_aJ() == 0.0f && target.func_70644_a(WizardryPotions.frost)) {
                for (int i = 0; i < 8; ++i) {
                    double dx = AncientSpellcraft.rand.nextDouble() - 0.5;
                    double dy = AncientSpellcraft.rand.nextDouble() - 0.5;
                    double dz = AncientSpellcraft.rand.nextDouble() - 0.5;
                    EntitySafeIceShard iceshard = new EntitySafeIceShard(target.field_70170_p);
                    iceshard.func_70107_b(target.field_70165_t + dx + Math.signum(dx) * (double)target.field_70130_N, target.field_70163_u + (double)(target.field_70131_O / 2.0f) + dy, target.field_70161_v + dz + Math.signum(dz) * (double)target.field_70130_N);
                    iceshard.field_70159_w = dx * 1.5;
                    iceshard.field_70181_x = dy * 1.5;
                    iceshard.field_70179_y = dz * 1.5;
                    iceshard.setCaster(wielder);
                    target.field_70170_p.func_72838_d((Entity)iceshard);
                }
            }
            target.func_70690_d(new PotionEffect(WizardryPotions.frost, duration, amplifier));
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            for (EntityLivingBase currTarget : EntityUtils.getEntitiesWithinRadius((double)4.0, (double)target.field_70165_t, (double)target.field_70163_u, (double)target.field_70161_v, (World)target.field_70170_p, EntityLivingBase.class)) {
                if (currTarget == wielder || currTarget == target || AllyDesignationSystem.isAllied((EntityLivingBase)wielder, (EntityLivingBase)currTarget)) continue;
                EntityUtils.attackEntityWithoutKnockback((Entity)currTarget, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)wielder, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)3.5f);
                currTarget.func_70690_d(new PotionEffect(WizardryPotions.frost, 60, 0));
                double angle = (3.getAngleBetweenEntities((Entity)wielder, (Entity)currTarget) + 90.0) * Math.PI / 180.0;
                double distance = wielder.func_70032_d((Entity)currTarget) - 4.0f;
                currTarget.field_70159_w += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle);
                currTarget.field_70179_y += Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle);
            }
        }
    }
    ,
    LIGHTNING(Element.LIGHTNING){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
            if (world.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (player.field_70122_E && 4.hasPosChanged(player)) {
                    if (ItemBattlemageSword.hasManaStorage(stack) && !((IManaStoringItem)stack.func_77973_b()).isManaFull(stack)) {
                        ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                    } else if (player.func_184592_cb().func_77973_b() instanceof IManaStoringItem) {
                        ((IManaStoringItem)player.func_184592_cb().func_77973_b()).rechargeMana(player.func_184592_cb(), 1);
                    }
                }
            }
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            List secondaryTargets = EntityUtils.getLivingWithinRadius((double)4.0, (double)target.field_70165_t, (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f)), (double)target.field_70161_v, (World)wielder.field_70170_p);
            secondaryTargets.stream().filter(entity -> !entity.equals((Object)target)).filter(EntityUtils::isLiving).filter(e -> AllyDesignationSystem.isValidTarget((Entity)wielder, (Entity)e)).limit(3L).forEach(secondaryTarget -> 4.electrocute(target.field_70170_p, (Entity)wielder, target.func_174791_d().func_72441_c(0.0, (double)(target.field_70131_O / 2.0f), 0.0), (Entity)secondaryTarget, 4.0f, 0));
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            int amount = 60;
            if (ItemBattlemageSword.hasManaStorage(stack) && !((IManaStoringItem)stack.func_77973_b()).isManaFull(stack)) {
                ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, amount);
            } else if (wielder.func_184592_cb().func_77973_b() instanceof IManaStoringItem) {
                ((IManaStoringItem)wielder.func_184592_cb().func_77973_b()).rechargeMana(wielder.func_184592_cb(), amount);
            }
        }
    }
    ,
    NECROMANCY(Element.NECROMANCY){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
            wielder.func_70691_i(0.5f);
            if (target.func_110143_aJ() == 0.0f) {
                wielder.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 0));
                wielder.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 100, 0));
            }
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            ArrayList<PotionEffect> effects;
            Map<Potion, PotionEffect> beneficialPotions;
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)wielder, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), (float)2.5f);
            wielder.func_70691_i(1.5f);
            if (wielder instanceof EntityPlayer) {
                ((EntityPlayer)wielder).func_71024_bL().func_75122_a(2, 0.1f);
            }
            if (AncientSpellcraft.rand.nextDouble() < 0.3 && wielder instanceof EntityPlayer && ItemGlyphArtefact.isArtefactActive((EntityPlayer)wielder, ASItems.charm_glyph_leeching) && !(beneficialPotions = target.func_193076_bZ().entrySet().stream().filter(p -> !((Potion)p.getKey()).func_76398_f()).filter(p -> ((PotionEffect)p.getValue()).func_76459_b() <= 12000).filter(p -> ((PotionEffect)p.getValue()).func_76458_c() < 3).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty() && !(effects = new ArrayList<PotionEffect>(beneficialPotions.values())).isEmpty()) {
                PotionEffect potionToSteal = (PotionEffect)effects.get(AncientSpellcraft.rand.nextInt(effects.size()));
                wielder.func_70690_d(potionToSteal);
                target.func_184589_d(potionToSteal.func_188419_a());
            }
        }
    }
    ,
    EARTH(Element.EARTH){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            BlockPos pos;
            PotionEffect effect;
            int duration = 80;
            int amplifier = 0;
            if (target.func_70644_a(MobEffects.field_76436_u) && (effect = target.func_70660_b(MobEffects.field_76436_u)) != null) {
                duration = (int)((double)effect.func_76459_b() * 0.1 + (double)duration);
                amplifier = effect.func_76458_c();
                if (target.field_70170_p.field_73012_v.nextDouble() < 0.2 && amplifier < 2) {
                    ++amplifier;
                }
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration, amplifier));
            if (!wielder.field_70170_p.field_72995_K && AncientSpellcraft.rand.nextDouble() < 0.5 && (pos = BlockUtils.findNearbyFloorSpace((Entity)target, (int)4, (int)7)) != null) {
                BlockMagicMushroom.tryPlaceMushroom(wielder.field_70170_p, pos, wielder, BlockMagicMushroom.getRandomMushroom(0.1f, 0.06f), 600);
            }
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        }
    }
    ,
    SORCERY(Element.SORCERY){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            if (!wielder.field_70170_p.field_72995_K) {
                ItemStack conjured;
                double d = AncientSpellcraft.rand.nextDouble();
                if (d < 0.2) {
                    target.func_70690_d(new PotionEffect(WizardryPotions.containment, 60));
                } else if (d < 0.5) {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                }
                int duration = 100;
                if (wielder instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)wielder), (Item)WizardryItems.ring_conjurer)) {
                    duration += 60;
                }
                if (AncientSpellcraft.rand.nextDouble() < (double)0.8f) {
                    conjured = Animate.conjureItem(new SpellModifiers(), WizardryItems.spectral_sword);
                } else {
                    conjured = Animate.conjureItem(new SpellModifiers(), WizardryItems.spectral_bow);
                    duration += 60;
                }
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)wielder, (int)4, (int)8);
                if (pos != null && pos != BlockPos.field_177992_a) {
                    EntityAnimatedItem minion = new EntityAnimatedItem(wielder.field_70170_p);
                    minion.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    minion.setLifetime(duration);
                    minion.setCaster(wielder);
                    minion.func_184611_a(EnumHand.MAIN_HAND, conjured);
                    wielder.field_70170_p.func_72838_d((Entity)minion);
                }
            }
        }
    }
    ,
    HEALING(Element.HEALING){

        @Override
        void onUpdateEffect(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        }

        @Override
        void lesserPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder, boolean charged) {
            if (ASUtils.isEntityConsideredUndead((Entity)target)) {
                target.func_70015_d(2);
                if (!target.func_70644_a(WizardryPotions.mark_of_sacrifice)) {
                    target.func_70690_d(new PotionEffect(WizardryPotions.mark_of_sacrifice, 40, 1));
                }
            }
        }

        @Override
        void greaterPowerOnEntityHit(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
            List nearbyEntities = EntityUtils.getEntitiesWithinRadius((double)16.0, (double)wielder.field_70165_t, (double)wielder.field_70163_u, (double)wielder.field_70161_v, (World)wielder.field_70170_p, EntityLivingBase.class);
            List<EntityLivingBase> entitiesToBuff = nearbyEntities.stream().filter(e -> AllyDesignationSystem.isAllied((EntityLivingBase)wielder, (EntityLivingBase)e)).collect(Collectors.toList());
            List<PotionEffect> healingElementApplicablePotionList = Arrays.asList(new PotionEffect(MobEffects.field_76428_l, 100, 1), new PotionEffect(MobEffects.field_76426_n, 200, 1), new PotionEffect(MobEffects.field_76444_x, 200, 1), new PotionEffect(MobEffects.field_76420_g, 200, 0), new PotionEffect(MobEffects.field_76424_c, 200, 0), new PotionEffect(MobEffects.field_76422_e, 200, 0), new PotionEffect(MobEffects.field_76439_r, 200, 0), new PotionEffect(MobEffects.field_76443_y, 60, 0), new PotionEffect(WizardryPotions.empowerment, 200, 0), new PotionEffect(WizardryPotions.font_of_mana, 200, 0), new PotionEffect(WizardryPotions.ward, 200, 0), new PotionEffect(ASPotions.fortified_archery, 200, 0), new PotionEffect(ASPotions.projectile_ward, 200, 0), new PotionEffect(ASPotions.wizard_shield, 200, 8));
            if (!entitiesToBuff.isEmpty()) {
                PotionEffect potionToApply = healingElementApplicablePotionList.get(AncientSpellcraft.rand.nextInt(healingElementApplicablePotionList.size()));
                entitiesToBuff.forEach(e -> e.func_70690_d(potionToApply));
            }
        }
    };

    private final Element element;

    private EnumElementalSwordEffect(Element element) {
        this.element = element;
    }

    abstract void onUpdateEffect(ItemStack var1, World var2, Entity var3, int var4, boolean var5);

    abstract void lesserPowerOnEntityHit(ItemStack var1, EntityLivingBase var2, EntityLivingBase var3, boolean var4);

    abstract void greaterPowerOnEntityHit(ItemStack var1, EntityLivingBase var2, EntityLivingBase var3);

    public static void onUpdate(Element element, ItemStack stack, World world, EntityLivingBase entity, int slot, boolean isHeld) {
        EnumElementalSwordEffect.fromElement(element).onUpdateEffect(stack, world, (Entity)entity, slot, isHeld);
    }

    public static void hitEntity(Element element, ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        EnumElementalSwordEffect effect = EnumElementalSwordEffect.fromElement(element);
        boolean charged = WizardClassWeaponHelper.isChargeFull(stack);
        for (Map.Entry<Runeword, Integer> activeRuneword : ItemBattlemageSword.getActiveRunewords(stack).entrySet()) {
            activeRuneword.getKey().onAboutToHitEntity(wielder.field_70170_p, wielder, target, EnumHand.MAIN_HAND, stack, new SpellModifiers(), charged);
        }
        for (Spell spell : WandHelper.getSpells((ItemStack)stack)) {
            if (!(spell instanceof Runeword) || !((Runeword)spell).isPassive()) continue;
            ((Runeword)spell).onAboutToHitEntity(wielder.field_70170_p, wielder, target, EnumHand.MAIN_HAND, stack, new SpellModifiers(), charged);
        }
        effect.lesserPowerOnEntityHit(stack, target, wielder, charged);
        if (charged) {
            effect.greaterPowerOnEntityHit(stack, target, wielder);
            WizardClassWeaponHelper.resetChargeProgress(stack);
        }
    }

    private static EnumElementalSwordEffect fromElement(Element element) {
        for (EnumElementalSwordEffect effect : EnumElementalSwordEffect.values()) {
            if (effect.element != element) continue;
            return effect;
        }
        return MAGIC;
    }

    public static boolean hasPosChanged(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        BlockPos pos = (BlockPos)data.getVariable(ItemBattlemageSword.LAST_POS);
        data.setVariable(ItemBattlemageSword.LAST_POS, (Object)player.func_180425_c());
        if (pos == null) {
            return true;
        }
        return !pos.equals((Object)player.func_180425_c());
    }

    public static double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.field_70161_v - first.field_70161_v, second.field_70165_t - first.field_70165_t) * 57.29577951308232 + 90.0;
    }

    public static void electrocute(World world, Entity caster, Vec3d origin, Entity target, float damage, int ticksInUse) {
        if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)target)) {
            if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), "lightning damage"}), true);
            }
        } else if (!world.field_72995_K) {
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), (float)damage);
        }
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity(caster).clr(0.2f, 0.6f, 1.0f).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            if (ticksInUse % 3 == 0) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity(caster).pos(caster != null ? origin.func_178788_d(caster.func_174791_d()) : origin).target(target).spawn(world);
            }
            for (int i = 0; i < 5; ++i) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK, (Entity)target).spawn(world);
            }
        }
    }
}

