/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.BaublesCapabilities;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.event.ImbuementActivateEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemASArtefact
extends ItemArtefact {
    public ItemASArtefact(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ASArtefactBaubleProvider(this);
    }

    @SubscribeEvent
    public static void onImbuement(ImbuementActivateEvent event) {
        if (event.lastUser != null && ItemArtefact.isArtefactActive((EntityPlayer)event.lastUser, (Item)ASItems.amulet_imbued_marble)) {
            List<Element> elements = Arrays.asList(event.receptacleElements);
            Element firstElement = elements.get(0);
            if (elements.stream().anyMatch(e -> e != firstElement)) {
                return;
            }
            if ((double)field_77697_d.nextFloat() < 0.8) {
                for (int i = 0; i < 10; ++i) {
                    List randomSpell = Spell.getSpells((Predicate)new Spell.TierElementFilter(Tier.ADVANCED, firstElement, new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
                    Spell spell = (Spell)randomSpell.get(field_77697_d.nextInt(randomSpell.size() - 1));
                    if (spell.applicableForItem(WizardryItems.spell_book)) {
                        event.result = new ItemStack(WizardryItems.spell_book, 1, spell.metadata());
                        break;
                    }
                    if (!spell.applicableForItem(ASItems.ancient_spellcraft_spell_book)) continue;
                    event.result = new ItemStack(ASItems.ancient_spellcraft_spell_book, 1, spell.metadata());
                    break;
                }
            }
        }
    }

    protected static class ASArtefactBaubleProvider
    implements ICapabilityProvider,
    IBauble {
        private final ItemASArtefact item;

        public ASArtefactBaubleProvider(ItemASArtefact item) {
            this.item = item;
        }

        public BaubleType getBaubleType(ItemStack itemstack) {
            switch (this.item.getType()) {
                case RING: {
                    return BaubleType.RING;
                }
                case AMULET: {
                    return BaubleType.AMULET;
                }
                case CHARM: {
                    return BaubleType.CHARM;
                }
                case BELT: {
                    return BaubleType.BELT;
                }
                case HEAD: {
                    return BaubleType.HEAD;
                }
                case BODY: {
                    return BaubleType.BODY;
                }
            }
            return BaubleType.CHARM;
        }

        public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                ((IBauble)this.item).onEquipped(itemstack, player);
            }
        }

        public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                ((IBauble)this.item).onWornTick(itemstack, player);
            }
        }

        public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                ((IBauble)this.item).onUnequipped(itemstack, player);
            }
        }

        public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                return ((IBauble)this.item).canEquip(itemstack, player);
            }
            return true;
        }

        public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                return ((IBauble)this.item).canUnequip(itemstack, player);
            }
            return true;
        }

        public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
            if (this.item instanceof IBauble) {
                return ((IBauble)this.item).willAutoSync(itemstack, player);
            }
            return false;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == BaublesCapabilities.CAPABILITY_ITEM_BAUBLE ? this : null);
        }
    }
}

