/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemRareScroll;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.misc.WildcardTradeList;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ItemAmnesiaScroll
extends ItemRareScroll {
    public static final String TRADES_TAG = "trades";

    @SubscribeEvent
    public static void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityWizard) {
            if (event.getItemStack().func_77973_b() == ASItems.amnesia_scroll) {
                ItemAmnesiaScroll.handleAmnesiaScroll(event);
            } else if (ItemArtefact.isArtefactActive((EntityPlayer)event.getEntityPlayer(), (Item)ASItems.head_merchant)) {
                ItemAmnesiaScroll.handleCrown(event);
            }
        }
    }

    private static void handleAmnesiaScroll(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        NBTTagCompound entityInNbt = event.getTarget().serializeNBT();
        boolean foundTrades = entityInNbt.func_74764_b(TRADES_TAG);
        if (event.getWorld().field_72995_K) {
            Vec3d origin = event.getTarget().func_174824_e(1.0f);
            for (int i = 0; i < 30; ++i) {
                double x = origin.field_72450_a - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                double y = origin.field_72448_b - 0.25 + world.field_73012_v.nextDouble() * 0.5;
                double z = origin.field_72449_c - 1.0 + world.field_73012_v.nextDouble() * 2.0;
                if (world.field_73012_v.nextBoolean()) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(140, 140, 140).spawn(world);
                    continue;
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(99, 1, 110).spawn(world);
            }
        }
        if (foundTrades) {
            entityInNbt.func_82580_o(TRADES_TAG);
            ItemAmnesiaScroll.spawnWizard(event, entityInNbt);
        }
    }

    private static void handleCrown(PlayerInteractEvent.EntityInteract event) {
        NBTTagCompound entityInNbt = event.getTarget().serializeNBT();
        boolean foundTrades = entityInNbt.func_74764_b(TRADES_TAG);
        if (foundTrades && entityInNbt.func_74764_b(TRADES_TAG)) {
            NBTTagCompound tagCompound = entityInNbt.func_74775_l(TRADES_TAG);
            WildcardTradeList trades = new WildcardTradeList(tagCompound);
            boolean scrolls = false;
            for (MerchantRecipe recipe : trades) {
                if (!(recipe.func_77394_a().func_77973_b() instanceof ItemScroll)) continue;
                scrolls = true;
                break;
            }
            if (!scrolls) {
                ArrayList<IForgeRegistryEntry> itemList = new ArrayList<IForgeRegistryEntry>();
                for (String itemName : Settings.generalSettings.scroll_items_for_crown_of_the_merchant_king) {
                    if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName))) continue;
                    itemList.add(ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName)));
                }
                for (Item item : itemList) {
                    ItemStack scrollStack = new ItemStack(item, 1, Short.MAX_VALUE);
                    ItemStack crystalStack1 = new ItemStack(WizardryItems.magic_crystal, 1);
                    MerchantRecipe rec = new MerchantRecipe(scrollStack, crystalStack1);
                    boolean matches = false;
                    for (MerchantRecipe r : trades) {
                        if (r.func_77394_a().func_77973_b() != rec.func_77394_a().func_77973_b()) continue;
                        matches = true;
                    }
                    if (matches) continue;
                    trades.add((Object)rec);
                }
                entityInNbt.func_82580_o(TRADES_TAG);
                NBTExtras.storeTagSafely((NBTTagCompound)entityInNbt, (String)TRADES_TAG, (NBTBase)trades.func_77202_a());
                ItemAmnesiaScroll.spawnWizard(event, entityInNbt);
            }
        }
    }

    private static void spawnWizard(PlayerInteractEvent.EntityInteract event, NBTTagCompound entityInNbt) {
        entityInNbt.func_186854_a("UUID", MathHelper.func_180182_a((Random)event.getWorld().field_73012_v));
        Entity mob = EntityList.func_75615_a((NBTTagCompound)entityInNbt, (World)event.getWorld());
        if (mob != null && !event.getWorld().field_72995_K) {
            event.getWorld().func_72900_e(event.getTarget());
            ItemStack copy = event.getEntityPlayer().func_184586_b(event.getHand());
            copy.func_190918_g(1);
            event.getEntityPlayer().func_184611_a(event.getHand(), copy);
            event.getWorld().func_72838_d(mob);
            event.setCanceled(true);
            ItemAmnesiaScroll.consumeScroll(event.getEntityPlayer(), event.getHand());
        }
    }
}

