/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAmuletOfCelerity
extends ItemASArtefact
implements ITickableArtefact,
IBauble {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("c8b6c8a8-4a4a-4b8b-8b8b-8b8b8b8b8b8b");
    private static final String SPEED_MODIFIER_NAME = "Amulet of Celerity Speed";

    public ItemAmuletOfCelerity(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        AttributeModifier modifier;
        IAttributeInstance speedAttribute;
        if (!player.field_70170_p.field_72995_K && (speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null && !speedAttribute.func_180374_a(modifier = new AttributeModifier(SPEED_MODIFIER_UUID, SPEED_MODIFIER_NAME, Settings.generalSettings.amulet_of_celerity_speed_bonus, 1))) {
            speedAttribute.func_111121_a(modifier);
        }
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        IAttributeInstance speedAttribute;
        if (!player.field_70170_p.field_72995_K && (speedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null) {
            speedAttribute.func_188479_b(SPEED_MODIFIER_UUID);
        }
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        int percentage = (int)(Settings.generalSettings.amulet_of_celerity_speed_bonus * 100.0);
        tooltip.add(I18n.func_135052_a((String)"item.ancientspellcraft:amulet_celerity.tooltip", (Object[])new Object[]{percentage}));
        if (!Settings.isArtefactEnabled((Item)this)) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }
}

