/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAmuletOfResistance
extends ItemASArtefact
implements IManaStoringItem,
IWorkbenchItem,
ITickableArtefact {
    private static final int MANA_COST_PER_TICK = 1;
    private static final String IMBUED_POTION_TAG = "imbued_potion";
    private static final String IMMUNITY_ACTIVE_TAG = "immunity_active";

    public ItemAmuletOfResistance(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77656_e(Settings.generalSettings.amulet_of_resistance_mana_capacity);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasImbuedPotion(stack) && !this.isManaEmpty(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        if (this.hasImbuedPotion(stack)) {
            Potion imbuedPotion = this.getImbuedPotion(stack);
            if (imbuedPotion != null) {
                tooltip.add(TextFormatting.GREEN + "Imbued with: " + new TextComponentTranslation(imbuedPotion.func_76393_a(), new Object[0]).func_150254_d());
            }
        } else {
            tooltip.add(TextFormatting.YELLOW + "Right-click with a potion to imbue");
        }
        tooltip.add(TextFormatting.BLUE + "Mana: " + this.getMana(stack) + "/" + this.getManaCapacity(stack));
        if (!Settings.isArtefactEnabled((Item)this)) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && Settings.isArtefactEnabled((Item)this)) {
            EnumHand otherHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
            ItemStack otherStack = player.func_184586_b(otherHand);
            if (!otherStack.func_190926_b() && otherStack.func_77973_b() instanceof ItemPotion) {
                if (this.imbueWithPotion(stack, otherStack, player)) {
                    otherStack.func_190918_g(1);
                    player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.0f, 1.0f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.hasImbuedPotion(stack) && !this.isManaEmpty(stack)) {
                boolean wasActive = this.isImmunityActive(stack);
                this.toggleImmunity(stack);
                player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.0f, 1.0f);
                if (!wasActive) {
                    ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:amulet_of_resistance.activated", false, new Object[0]);
                } else {
                    ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:amulet_of_resistance.deactivated", false, new Object[0]);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        Potion imbuedPotion;
        if (!player.field_70170_p.field_72995_K && this.hasImbuedPotion(itemstack) && this.isImmunityActive(itemstack) && (imbuedPotion = this.getImbuedPotion(itemstack)) != null) {
            if (player.field_70173_aa % 20 == 0) {
                this.consumeMana(itemstack, 1, player);
            }
            if (player.func_70644_a(imbuedPotion)) {
                player.func_184589_d(imbuedPotion);
                if (this.isManaEmpty(itemstack)) {
                    this.setImmunityActive(itemstack, false);
                }
            }
        }
    }

    private boolean imbueWithPotion(ItemStack amulet, ItemStack potionStack, EntityPlayer player) {
        List effects = PotionUtils.func_185189_a((ItemStack)potionStack);
        if (!effects.isEmpty()) {
            Potion potion = ((PotionEffect)effects.get(0)).func_188419_a();
            this.setImbuedPotion(amulet, potion);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:amulet_of_resistance.imbued", new Object[]{new TextComponentTranslation(potion.func_76393_a(), new Object[0]).func_150254_d()}));
            return true;
        }
        return false;
    }

    private void toggleImmunity(ItemStack stack) {
        boolean currentlyActive = this.isImmunityActive(stack);
        this.setImmunityActive(stack, !currentlyActive);
    }

    private boolean hasImbuedPotion(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(IMBUED_POTION_TAG);
    }

    private Potion getImbuedPotion(ItemStack stack) {
        if (this.hasImbuedPotion(stack)) {
            String potionName = stack.func_77978_p().func_74779_i(IMBUED_POTION_TAG);
            return (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
        }
        return null;
    }

    private void setImbuedPotion(ItemStack stack, Potion potion) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(IMBUED_POTION_TAG, potion.getRegistryName().toString());
    }

    private boolean isImmunityActive(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(IMMUNITY_ACTIVE_TAG);
    }

    private void setImmunityActive(ItemStack stack, boolean active) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(IMMUNITY_ACTIVE_TAG, active);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public boolean showManaInWorkbench(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public void consumeMana(ItemStack stack, int mana, @Nullable EntityLivingBase wielder) {
        super.consumeMana(stack, mana, wielder);
    }

    public void rechargeMana(ItemStack stack, int mana) {
        super.rechargeMana(stack, mana);
    }

    public boolean isManaFull(ItemStack stack) {
        return super.isManaFull(stack);
    }

    public boolean isManaEmpty(ItemStack stack) {
        return super.isManaEmpty(stack);
    }

    public float getFullness(ItemStack stack) {
        return super.getFullness(stack);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }
}

