/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAncientWand
extends ItemASArtefact
implements ISpellCastingItem,
IWorkbenchItem {
    public static final int BASE_SPELL_SLOTS = 5;

    public ItemAncientWand(EnumRarity enumRarity, ItemArtefact.Type type) {
        super(enumRarity, type);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
        Spell currentSpell = this.getCurrentSpell(stack);
        if (currentSpell != Spells.none) {
            tooltip.add("Current Spell: " + currentSpell.getDisplayNameWithFormatting());
        } else {
            tooltip.add("Current Spell: None");
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return SpellActions.POINT;
    }

    public int func_77626_a(ItemStack stack) {
        return 20000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Spell spell = this.getCurrentSpell(stack);
        SpellModifiers modifiers = new SpellModifiers();
        modifiers.set("potency", 1.0f, false);
        this.cast(stack, spell, player, hand, 0, modifiers);
        if (!player.func_184587_cr()) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer && count <= 19800) {
            user.func_184597_cx();
        }
        super.onUsingTick(stack, user, count);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
            }
            this.setSpell(stack, Spells.none);
            if (caster instanceof EntityPlayer) {
                caster.func_184811_cZ().func_185145_a((Item)this, spell.getCooldown() + 40);
            }
            return true;
        }
        return false;
    }

    public void setSpell(ItemStack stack, Spell spell) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74778_a("Spell", spell.getRegistryName().toString());
    }

    public Spell getCurrentSpell(ItemStack stack) {
        return WandHelper.getCurrentSpell((ItemStack)stack);
    }

    public Spell getNextSpell(ItemStack stack) {
        return WandHelper.getNextSpell((ItemStack)stack);
    }

    public Spell getPreviousSpell(ItemStack stack) {
        return WandHelper.getPreviousSpell((ItemStack)stack);
    }

    public Spell[] getSpells(ItemStack stack) {
        return WandHelper.getSpells((ItemStack)stack);
    }

    public void selectNextSpell(ItemStack stack) {
        WandHelper.selectNextSpell((ItemStack)stack);
    }

    public void selectPreviousSpell(ItemStack stack) {
        WandHelper.selectPreviousSpell((ItemStack)stack);
    }

    public boolean selectSpell(ItemStack stack, int index) {
        return WandHelper.selectSpell((ItemStack)stack, (int)index);
    }

    public int getCurrentCooldown(ItemStack stack) {
        return WandHelper.getCurrentCooldown((ItemStack)stack);
    }

    public int getCurrentMaxCooldown(ItemStack stack) {
        return WandHelper.getCurrentMaxCooldown((ItemStack)stack);
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        return !caster.func_184811_cZ().func_185141_a(stack.func_77973_b());
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 1;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        Spell[] spells = WandHelper.getSpells((ItemStack)centre.func_75211_c());
        if (spells.length <= 0) {
            spells = new Spell[1];
        }
        for (int i = 0; i < spells.length; ++i) {
            if (spellBooks[i].func_75211_c() == ItemStack.field_190927_a) continue;
            Spell spell = Spell.byMetadata((int)spellBooks[i].func_75211_c().func_77952_i());
            if (Wizardry.settings.preventBindingSameSpellTwiceToWands && Arrays.stream(spells).anyMatch(s -> s == spell)) continue;
            spells[i] = spell;
            changed = true;
            if (!Wizardry.settings.singleUseSpellBooks) continue;
            spellBooks[i].func_75211_c().func_190918_g(1);
        }
        WandHelper.setSpells((ItemStack)centre.func_75211_c(), (Spell[])spells);
        if (WandHelper.rechargeManaOnApplyButtonPressed((Slot)centre, (Slot)crystals)) {
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }
}

