/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.data.ClassWeaponData;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.item.EnumElementalSwordEffect;
import com.windanesz.ancientspellcraft.item.IWizardClassWeapon;
import com.windanesz.ancientspellcraft.item.ItemBattlemageShield;
import com.windanesz.ancientspellcraft.item.WizardClassWeaponHelper;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.RunesmithingSpellBase;
import com.windanesz.ancientspellcraft.spell.Runeword;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemBattlemageSword
extends ItemSword
implements ISpellCastingItem,
IWorkbenchItem,
IWizardClassWeapon,
IManaStoringItem {
    private static final String MANA_AVAILABLE_TAG = "mana_available";
    private static final String TEMPORARY_RUNEWORD_DATA_TAG = "temporary_runeword_data";
    private static final int CONTINUOUS_TRACKING_INTERVAL = 20;
    private static final float ELEMENTAL_PROGRESSION_MODIFIER = 1.2f;
    private static final float DISCOVERY_PROGRESSION_MODIFIER = 5.0f;
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;
    private static final float MAX_PROGRESSION_REDUCTION = 0.75f;
    public static final int SWORD_BASE_SPELL_SLOTS = 5;
    public static final String ACTIVE_RUNEWORDS = "active_runewords";
    public final int upgradeLimit;
    private final int attackDamage;
    public final Tier tier;
    public static final IStoredVariable<BlockPos> LAST_POS = IStoredVariable.StoredVariable.ofBlockPos((String)"lastPlayerPos", (Persistence)Persistence.NEVER);

    public ItemBattlemageSword(Tier tier, int upgradeLimit) {
        super(Item.ToolMaterial.IRON);
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
        this.tier = tier;
        this.upgradeLimit = upgradeLimit;
        int bonus = tier.level == 0 ? 2 : (tier.level == 1 ? 1 : 0);
        this.attackDamage = Settings.generalSettings.spellblade_base_damage + tier.level * Settings.generalSettings.spellblade_damage_increase_per_tier + bonus;
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LAST_POS});
        this.func_185043_a(new ResourceLocation("element"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return (float)WizardClassWeaponHelper.getElement(stack).ordinal() * 0.1f;
            }
        });
    }

    public boolean func_77636_d(ItemStack stack) {
        return WizardClassWeaponHelper.isChargeFull(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        WandHelper.decrementCooldowns((ItemStack)stack);
        if (!world.field_72995_K) {
            NBTTagCompound compound;
            boolean hasManaStorage = ItemBattlemageSword.hasManaStorage(stack);
            boolean powered = false;
            if (hasManaStorage && !this.isManaFull(stack) && world.func_82737_E() % 50L == 0L) {
                this.rechargeMana(stack, WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.condenser_upgrade));
            }
            if ((compound = stack.func_77978_p()) == null) {
                compound = new NBTTagCompound();
            }
            if (hasManaStorage && !((ItemBattlemageSword)stack.func_77973_b()).isManaEmpty(stack)) {
                powered = true;
            }
            Element element = Element.MAGIC;
            if (isHeld && entity instanceof EntityLivingBase) {
                Spell[] entityLiving = (Spell[])entity;
                ItemStack offhand = entityLiving.func_184592_cb();
                if ((offhand.func_77973_b() instanceof ItemWand || offhand.func_77973_b() instanceof ItemBattlemageShield) && !((IManaStoringItem)offhand.func_77973_b()).isManaEmpty(offhand)) {
                    powered = true;
                }
                Optional<Element> optionalElement = WizardArmourUtils.getFullSetElementForClassOptional((EntityLivingBase)entityLiving, ItemWizardArmour.ArmourClass.BATTLEMAGE);
                element = optionalElement.orElse(Element.MAGIC);
                if (!optionalElement.isPresent()) {
                    powered = false;
                }
                EnumElementalSwordEffect.onUpdate(element, stack, world, (EntityLivingBase)entityLiving, slot, true);
            }
            compound.func_74778_a("element", element.func_176610_l().toLowerCase());
            compound.func_74757_a(MANA_AVAILABLE_TAG, powered);
            if (entity instanceof EntityLivingBase) {
                for (Spell spell : this.getSpells(stack)) {
                    if (!(spell instanceof Runeword) || !((Runeword)spell).isTicking()) continue;
                    ((Runeword)spell).tick((EntityLivingBase)entity, stack);
                }
            }
            if (entity.field_70173_aa % 15 == 0 && entity instanceof EntityPlayer) {
                ArrayList<String> glyphs = new ArrayList<String>();
                EntityPlayer player = (EntityPlayer)entity;
                if (player.func_184614_ca().func_77973_b() instanceof ItemBattlemageSword && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_glyph_antigravity)) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 40, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 40, 0));
                    glyphs.add(ASItems.charm_glyph_antigravity.getRegistryName().toString());
                }
                if (player.func_184614_ca().func_77973_b() instanceof ItemBattlemageSword && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_glyph_might)) {
                    glyphs.add(ASItems.charm_glyph_might.getRegistryName().toString());
                }
                if (!glyphs.isEmpty()) {
                    NBTTagList list = new NBTTagList();
                    for (String s : glyphs) {
                        list.func_74742_a((NBTBase)new NBTTagString(s));
                    }
                    compound.func_74782_a("active_glyphs", (NBTBase)list);
                } else {
                    compound.func_82580_o("active_glyphs");
                }
            }
            stack.func_77982_d(compound);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (ItemBattlemageSword.hasManaStorage(stack)) {
            return (int)((float)super.getMaxDamage(stack) * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.storage_upgrade)) + 0.5f);
        }
        return 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        double damage = this.attackDamage;
        if (slot == EntityEquipmentSlot.MAINHAND) {
            boolean anyManaAvailable;
            int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.melee_upgrade);
            boolean innateManaAvailable = ItemBattlemageSword.hasManaStorage(stack) && !this.isManaEmpty(stack);
            boolean bl = anyManaAvailable = stack.func_77942_o() && stack.func_77978_p().func_74764_b(MANA_AVAILABLE_TAG) && stack.func_77978_p().func_74767_n(MANA_AVAILABLE_TAG);
            damage = level > 0 && innateManaAvailable ? (double)(this.attackDamage + level) : (level > 0 && anyManaAvailable ? (double)this.attackDamage + (double)level : (!innateManaAvailable && !anyManaAvailable && stack.func_77942_o() ? (double)this.attackDamage * 0.5 : (double)this.attackDamage));
            if (anyManaAvailable) {
                Spell[] spells;
                for (Spell spell : spells = this.getSpells(stack)) {
                    if (!(spell instanceof Runeword) || !((Runeword)spell).isAffectingAttributes()) continue;
                    HashMap<Runeword, NBTTagCompound> data = ItemBattlemageSword.getTemporaryRunewordData(stack);
                    if (spell == ASSpells.runeword_fury) {
                        if (!data.containsKey((Runeword)ASSpells.runeword_fury)) continue;
                        int charges = data.get(ASSpells.runeword_fury).func_74762_e("charges");
                        float modifier = 1.0f + ASSpells.runeword_fury.getProperty("dmg_percent_increase_per_hit").floatValue() * (float)charges;
                        damage *= (double)modifier;
                        continue;
                    }
                    if (spell != ASSpells.runeword_sacrifice) continue;
                }
            }
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("active_glyphs")) {
                Iterator iterator = stack.func_77978_p().func_150295_c("active_glyphs", 8).iterator();
                while (iterator.hasNext()) {
                    String glyph = ((NBTTagString)iterator.next()).func_150285_a_();
                    if (glyph.equals(ASItems.charm_glyph_antigravity.getRegistryName().toString())) {
                        damage *= 0.7;
                        continue;
                    }
                    if (!glyph.equals(ASItems.charm_glyph_might.getRegistryName().toString())) continue;
                    damage *= 1.2;
                }
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", damage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        EnumHand otherHand = ItemBattlemageSword.getOtherHandForSword(stack, wielder);
        ItemStack otherStack = wielder.func_184586_b(otherHand);
        int cost = Settings.generalSettings.spellblade_base_mana_cost * (this.tier.level + 1);
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.melee_upgrade);
        if (WizardClassWeaponHelper.getElement(stack) == Element.LIGHTNING) {
            cost = (int)((double)cost * 1.5);
        }
        cost += level * 6;
        if (this.getMana(stack) > 0 && !(wielder.func_184592_cb().func_77973_b() instanceof ItemBattlemageShield)) {
            this.consumeMana(stack, cost, wielder);
        } else if (otherStack.func_77973_b() instanceof ItemWand && !((ItemWand)otherStack.func_77973_b()).isManaEmpty(otherStack)) {
            ((ItemWand)otherStack.func_77973_b()).consumeMana(otherStack, cost, wielder);
        }
        if (ItemBattlemageSword.hasManaAvailable(stack) || wielder instanceof EntityEvilClassWizard) {
            Element element = wielder instanceof EntityEvilClassWizard ? ((EntityEvilClassWizard)wielder).getElement() : WizardClassWeaponHelper.getElement(stack);
            EnumElementalSwordEffect.hitEntity(element, stack, target, wielder);
        }
        WizardClassWeaponHelper.addChargeProgress(stack, Settings.generalSettings.spellblade_charge_gain_per_spellcast);
        if (this.tier.level < Tier.MASTER.level && wielder instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)wielder;
            int recentHits = ClassWeaponData.getRecentHitCount(player, target);
            if (recentHits <= 2 + this.tier.level) {
                WandHelper.addProgression((ItemStack)stack, (int)1);
            }
            Tier nextTier = this.tier.next();
            int excess = WandHelper.getProgression((ItemStack)stack) - nextTier.getProgression();
            if (excess >= 0) {
                player.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{this.func_77653_i(stack), nextTier.getNameForTranslationFormatted()}));
                }
            }
            ClassWeaponData.trackRecentEnemy(player, target);
        }
        return true;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return false;
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!oldStack.func_190926_b() || !newStack.func_190926_b() && oldStack.func_77973_b() == newStack.func_77973_b() && !slotChanged && oldStack.func_77973_b() instanceof ItemBattlemageSword && newStack.func_77973_b() instanceof ItemBattlemageSword) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        text.add(Wizardry.proxy.translate("item.ancientspellcraft:battlemage_sword_armour_requirements_tooltip", new Object[0]));
        Element element = WizardArmourUtils.getFullSetElementForClass((EntityLivingBase)player, ItemWizardArmour.ArmourClass.BATTLEMAGE);
        if (element != null && element != Element.MAGIC) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((double)(this.tier.level + 1) * ((double)Constants.POTENCY_INCREASE_PER_TIER / 1.2) * 100.0 + 0.5), element.getDisplayName()}));
        }
        Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
        text.add(Wizardry.proxy.translate("item.ancientspellcraft:battlemage_sword.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER * 100.0f + 0.5f)}));
        boolean discovered = !Wizardry.settings.discoveryMode || player.func_184812_l_() || WizardData.get((EntityPlayer)player) == null || WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell);
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.spell", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{discovered ? spell.getDisplayNameWithFormatting() : "#" + TextFormatting.BLUE + SpellGlyphData.getGlyphName((Spell)spell, (World)player.field_70170_p)}));
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            AncientSpellcraft.proxy.addMultiLineDescription(text, I18n.func_135052_a((String)"tooltip.ancientspellcraft:runic_plate.more_info", (Object[])new Object[0]), new Object[0]);
        } else {
            text.add(I18n.func_135052_a((String)"tooltip.ancientspellcraft:more_info", (Object[])new Object[0]));
        }
        if (advanced.func_194127_a()) {
            if (ItemBattlemageSword.hasManaStorage(stack)) {
                text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
            } else {
                Optional<ItemStack> otherSource = WizardClassWeaponHelper.getManaSourceFromOtherHand(stack, (EntityLivingBase)player);
                if (otherSource.isPresent()) {
                    otherSource.ifPresent(itemStack -> text.add(Wizardry.proxy.translate("tooltip.ancientspellcraft:mana_with_eternal_source_name", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{((IManaStoringItem)((ItemStack)otherSource.get()).func_77973_b()).getMana(itemStack), ((IManaStoringItem)((ItemStack)otherSource.get()).func_77973_b()).getManaCapacity(itemStack), itemStack.func_82833_r() + new Style().func_150238_a(TextFormatting.BLUE).func_150218_j()})));
                } else {
                    text.add(Wizardry.proxy.translate("tooltip.ancientspellcraft:no_mana_source", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
                }
            }
        }
        if (this.tier.level < Tier.MASTER.level) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.progression", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{WandHelper.getProgression((ItemStack)stack), this.tier.level < Tier.MASTER.level ? this.tier.next().getProgression() : 0}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return TextFormatting.LIGHT_PURPLE + super.func_77653_i(stack);
    }

    private ItemStack getNextTier(Tier tier) {
        switch (tier) {
            case NOVICE: {
                return new ItemStack(ASItems.battlemage_sword_apprentice);
            }
            case APPRENTICE: {
                return new ItemStack(ASItems.battlemage_sword_advanced);
            }
        }
        return new ItemStack(ASItems.battlemage_sword_master);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return WandHelper.getCurrentSpell((ItemStack)itemstack).action;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        Spell spell;
        ItemStack stack = player.func_184586_b(hand);
        if (WizardClassWeaponHelper.selectMinionTarget(player, world)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if ((!(player.func_184592_cb().func_77973_b() instanceof ItemBattlemageShield) || player.func_70093_af()) && this.canCast(stack, spell = WandHelper.getCurrentSpell((ItemStack)stack), player, hand, 0, modifiers = this.calculateModifiers(stack, player, spell))) {
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous || chargeup > 0) {
                if (!player.func_184587_cr()) {
                    player.func_184598_c(hand);
                    if (WizardData.get((EntityPlayer)player) != null) {
                        WizardData.get((EntityPlayer)player).itemCastingModifiers = modifiers;
                    }
                    if (chargeup > 0 && world.field_72995_K) {
                        Wizardry.proxy.playChargeupSound((EntityLivingBase)player);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
            SpellModifiers modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int useTick = stack.func_77988_m() - count;
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous) {
                if (useTick >= chargeup) {
                    int castingTick = useTick - chargeup;
                    if (castingTick == 0 || this.canCast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers)) {
                        this.cast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers);
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else if (chargeup > 0 && useTick == chargeup) {
                this.cast(stack, spell, player, player.func_184600_cs(), 0, modifiers);
            }
        }
    }

    public Spell getCurrentSpell(ItemStack stack) {
        return WandHelper.getCurrentSpell((ItemStack)stack);
    }

    public Spell getNextSpell(ItemStack stack) {
        return WandHelper.getNextSpell((ItemStack)stack);
    }

    public Spell getPreviousSpell(ItemStack stack) {
        return WandHelper.getPreviousSpell((ItemStack)stack);
    }

    public Spell[] getSpells(ItemStack stack) {
        return WandHelper.getSpells((ItemStack)stack);
    }

    public void selectNextSpell(ItemStack stack) {
        WandHelper.selectNextSpell((ItemStack)stack);
    }

    public void selectPreviousSpell(ItemStack stack) {
        WandHelper.selectPreviousSpell((ItemStack)stack);
    }

    public boolean selectSpell(ItemStack stack, int index) {
        return WandHelper.selectSpell((ItemStack)stack, (int)index);
    }

    public int getCurrentCooldown(ItemStack stack) {
        return WandHelper.getCurrentCooldown((ItemStack)stack);
    }

    public int getCurrentMaxCooldown(ItemStack stack) {
        return WandHelper.getCurrentMaxCooldown((ItemStack)stack);
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        boolean hasWandFromMana;
        EnumHand otherHand;
        EnumHand enumHand = otherHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        if (castingTick == 0 ? MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(AncientSpellcraft.BATTLEMAGE_ITEM, spell, (EntityLivingBase)caster, modifiers)) : MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(AncientSpellcraft.BATTLEMAGE_ITEM, spell, (EntityLivingBase)caster, modifiers, castingTick))) {
            return false;
        }
        int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        if (spell.isContinuous) {
            cost = ItemBattlemageSword.getDistributedCost(cost, castingTick);
        }
        boolean bl = hasWandFromMana = cost <= this.getMana(stack, otherHand, (EntityLivingBase)caster) && spell.getTier().level <= this.tier.level && (WandHelper.getCurrentCooldown((ItemStack)stack) == 0 || caster.func_184812_l_());
        if (hasWandFromMana) {
            return hasWandFromMana;
        }
        boolean test0 = ItemBattlemageSword.hasManaStorage(stack);
        int mana = this.getMana(stack);
        int cooldown = WandHelper.getCurrentCooldown((ItemStack)stack);
        boolean test = cost <= mana && spell.getTier().level <= this.tier.level && (cooldown == 0 || caster.func_184812_l_());
        return test;
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        EnumHand otherHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(AncientSpellcraft.BATTLEMAGE_ITEM, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
                if (spell.isContinuous) {
                    cost = ItemBattlemageSword.getDistributedCost(cost, castingTick);
                }
                if (cost > 0) {
                    if (caster.func_184586_b(otherHand).func_77973_b() instanceof IManaStoringItem) {
                        int mana = ((IManaStoringItem)caster.func_184586_b(otherHand).func_77973_b()).getMana(caster.func_184586_b(otherHand));
                        if (mana >= cost) {
                            this.consumeMana(stack, otherHand, (EntityLivingBase)caster, cost);
                        }
                    } else {
                        this.consumeMana(stack, cost, (EntityLivingBase)caster);
                    }
                }
            }
            caster.func_184598_c(hand);
            if (!spell.isContinuous && !caster.func_184812_l_()) {
                WandHelper.setCurrentCooldown((ItemStack)stack, (int)((int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
            }
            if (this.tier.level < Tier.MASTER.level && castingTick % 20 == 0) {
                int progression = (int)((float)spell.getCost() * modifiers.get("progression"));
                WandHelper.addProgression((ItemStack)stack, (int)progression);
                if (!Wizardry.settings.legacyWandLevelling) {
                    Tier nextTier = this.tier.next();
                    int excess = WandHelper.getProgression((ItemStack)stack) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        caster.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        WizardryAdvancementTriggers.wand_levelup.triggerFor(caster);
                        if (!world.field_72995_K) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{this.func_77653_i(stack), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
                WizardData.get((EntityPlayer)caster).trackRecentSpell(spell);
            }
            WizardClassWeaponHelper.addChargeProgress(stack, Settings.generalSettings.spellblade_charge_gain_per_spellcast);
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentMending) && !(enchantment instanceof EnchantmentDurability) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185307_s) && !EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185296_A) && super.isBookEnchantable(stack, book);
    }

    public static HashMap<Runeword, Integer> getActiveRunewords(ItemStack stack) {
        HashMap<Runeword, Integer> map = new HashMap<Runeword, Integer>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ACTIVE_RUNEWORDS)) {
            NBTTagCompound compound = stack.func_77978_p().func_74775_l(ACTIVE_RUNEWORDS);
            for (String key : compound.func_150296_c()) {
                Spell runeword = Spell.get((String)key);
                if (!(runeword instanceof Runeword) || compound.func_74762_e(key) <= 0) continue;
                map.put((Runeword)runeword, compound.func_74762_e(key));
            }
        }
        return map;
    }

    public static int getRunewordCharges(ItemStack stack, Runeword runeword) {
        Integer charges = ItemBattlemageSword.getActiveRunewords(stack).get(runeword);
        return charges != null ? charges : 0;
    }

    public static void setActiveRuneword(ItemStack stack, Runeword runeword, int charges) {
        HashMap<Runeword, Integer> map = ItemBattlemageSword.getActiveRunewords(stack);
        map.put(runeword, charges);
        NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound runewords = new NBTTagCompound();
        for (Map.Entry<Runeword, Integer> e : map.entrySet()) {
            if (e.getValue() <= 0) continue;
            runewords.func_74768_a(e.getKey().getRegistryName().toString(), e.getValue().intValue());
        }
        compound.func_74782_a(ACTIVE_RUNEWORDS, (NBTBase)runewords);
        stack.func_77982_d(compound);
    }

    public static void spendCharge(ItemStack stack, Runeword runeword, int amount) {
        HashMap<Runeword, Integer> map = ItemBattlemageSword.getActiveRunewords(stack);
        if (map.containsKey(runeword)) {
            ItemBattlemageSword.setActiveRuneword(stack, runeword, map.get(runeword) - amount);
        }
    }

    public static HashMap<Runeword, NBTTagCompound> getTemporaryRunewordData(ItemStack stack) {
        HashMap<Runeword, NBTTagCompound> map = new HashMap<Runeword, NBTTagCompound>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TEMPORARY_RUNEWORD_DATA_TAG)) {
            NBTTagCompound compound = stack.func_77978_p().func_74775_l(TEMPORARY_RUNEWORD_DATA_TAG);
            for (String key : compound.func_150296_c()) {
                Spell runeword = Spell.get((String)key);
                if (!(runeword instanceof Runeword)) continue;
                map.put((Runeword)runeword, compound.func_74775_l(key));
            }
        }
        return map;
    }

    public static void setTemporaryRuneWordData(ItemStack sword, Runeword runeword, NBTTagCompound data) {
        HashMap<Runeword, NBTTagCompound> map = ItemBattlemageSword.getTemporaryRunewordData(sword);
        if (data != null) {
            map.put(runeword, data);
        } else {
            map.remove(runeword);
        }
        NBTTagCompound compound = sword.func_77942_o() ? sword.func_77978_p() : new NBTTagCompound();
        NBTTagCompound runewords = new NBTTagCompound();
        for (Map.Entry<Runeword, NBTTagCompound> e : map.entrySet()) {
            runewords.func_74782_a(e.getKey().getRegistryName().toString(), (NBTBase)e.getValue());
        }
        compound.func_74782_a(TEMPORARY_RUNEWORD_DATA_TAG, (NBTBase)runewords);
        sword.func_77982_d(compound);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        if (shield.func_77973_b() instanceof ItemShield && ItemBattlemageSword.getRunewordCharges(stack, (Runeword)ASSpells.runeword_shatter) > 0) {
            ItemBattlemageSword.spendCharge(stack, (Runeword)ASSpells.runeword_shatter, 1);
            return true;
        }
        return false;
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 5 + WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.attunement_upgrade);
    }

    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack wand, ItemStack upgrade) {
        if (WandHelper.isWandUpgrade((Item)upgrade.func_77973_b())) {
            Item specialUpgrade = upgrade.func_77973_b();
            int maxUpgrades = this.tier.upgradeLimit - 2;
            if (WandHelper.getTotalUpgrades((ItemStack)wand) < maxUpgrades && WandHelper.getUpgradeLevel((ItemStack)wand, (Item)specialUpgrade) < 3) {
                int prevMana = this.getMana(wand);
                WandHelper.applyUpgrade((ItemStack)wand, (Item)specialUpgrade);
                if (specialUpgrade == WizardryItems.storage_upgrade) {
                    this.setMana(wand, prevMana);
                } else if (specialUpgrade == WizardryItems.attunement_upgrade) {
                    int newSlotCount = 5 + WandHelper.getUpgradeLevel((ItemStack)wand, (Item)WizardryItems.attunement_upgrade);
                    Spell[] spells = WandHelper.getSpells((ItemStack)wand);
                    Spell[] newSpells = new Spell[newSlotCount];
                    for (int i = 0; i < newSpells.length; ++i) {
                        newSpells[i] = i < spells.length && spells[i] != null ? spells[i] : Spells.none;
                    }
                    WandHelper.setSpells((ItemStack)wand, (Spell[])newSpells);
                    int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                    int[] newCooldowns = new int[newSlotCount];
                    if (cooldowns.length > 0) {
                        System.arraycopy(cooldowns, 0, newCooldowns, 0, cooldowns.length);
                    }
                    WandHelper.setCooldowns((ItemStack)wand, (int[])newCooldowns);
                }
                upgrade.func_190918_g(1);
                if (player != null) {
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                    if (WandHelper.getTotalUpgrades((ItemStack)wand) == Tier.MASTER.upgradeLimit) {
                        WizardryAdvancementTriggers.max_out_wand.triggerFor(player);
                    }
                }
            }
        }
        return wand;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        Spell[] spells;
        boolean changed = false;
        if (upgrade.func_75216_d()) {
            ItemStack original = centre.func_75211_c().func_77946_l();
            centre.func_75215_d(this.applyUpgrade(player, centre.func_75211_c(), upgrade.func_75211_c()));
            boolean bl = changed = !ItemStack.func_77989_b((ItemStack)centre.func_75211_c(), (ItemStack)original);
        }
        if ((spells = WandHelper.getSpells((ItemStack)centre.func_75211_c())).length <= 0) {
            spells = new Spell[5];
        }
        for (int i = 0; i < spells.length; ++i) {
            if (spellBooks[i].func_75211_c() == ItemStack.field_190927_a) continue;
            Spell spell = Spell.byMetadata((int)spellBooks[i].func_75211_c().func_77952_i());
            if (spell.getTier().level > this.tier.level || spells[i] == spell || !spell.isEnabled(new SpellProperties.Context[0]) || spell instanceof RunesmithingSpellBase) continue;
            spells[i] = spell;
            changed = true;
        }
        WandHelper.setSpells((ItemStack)centre.func_75211_c(), (Spell[])spells);
        if (ItemBattlemageSword.hasManaStorage(centre.func_75211_c()) && crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public boolean showManaInWorkbench(EntityPlayer player, ItemStack stack) {
        return ItemBattlemageSword.hasManaStorage(stack);
    }

    public void consumeMana(ItemStack stack, int mana, @Nullable EntityLivingBase wielder) {
        super.consumeMana(stack, mana, wielder);
    }

    public void rechargeMana(ItemStack stack, int mana) {
        super.rechargeMana(stack, mana);
    }

    public boolean isManaFull(ItemStack stack) {
        return super.isManaFull(stack);
    }

    public boolean isManaEmpty(ItemStack stack) {
        return super.isManaEmpty(stack);
    }

    public float getFullness(ItemStack stack) {
        return super.getFullness(stack);
    }

    public SpellModifiers calculateModifiers(ItemStack stack, EntityPlayer player, Spell spell) {
        Element element;
        EnumHand otherHand = ItemBattlemageSword.getOtherHandForSword(stack, (EntityLivingBase)player);
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * Constants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        if ((element = WizardClassWeaponHelper.getElement(stack)) == spell.getElement()) {
            modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER, true);
        }
        if (spell instanceof IClassSpell && ((IClassSpell)spell).getArmourClass() == ItemWizardArmour.ArmourClass.BATTLEMAGE) {
            modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER, true);
        } else if (element != spell.getElement() && WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) > 0) {
            modifiers.set("potency", 1.0f + (float)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) * (float)Settings.generalSettings.empowerment_upgrade_potency_gain, true);
        }
        return modifiers;
    }

    private static EnumHand getOtherHandForSword(ItemStack stack, EntityLivingBase entity) {
        return entity.func_184614_ca().func_77973_b() instanceof ItemBattlemageSword ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    public static boolean hasManaStorage(ItemStack stack) {
        return WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.storage_upgrade) > 0;
    }

    private static boolean hasManaAvailable(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(MANA_AVAILABLE_TAG) && stack.func_77978_p().func_74767_n(MANA_AVAILABLE_TAG);
    }

    protected static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }

    public static Item getSwordForTier(Tier tier) {
        if (tier == null) {
            throw new NullPointerException("The given tier cannot be null.");
        }
        if (tier == Tier.NOVICE) {
            return ASItems.battlemage_sword_novice;
        }
        if (tier == Tier.APPRENTICE) {
            return ASItems.battlemage_sword_apprentice;
        }
        if (tier == Tier.ADVANCED) {
            return ASItems.battlemage_sword_advanced;
        }
        return ASItems.battlemage_sword_master;
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemBattlemageSword && ItemBattlemageSword.hasManaAvailable(stack)) {
            Random random = player.field_70170_p.field_73012_v;
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, WizardrySounds.ITEM_WAND_MELEE, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
            if (player.field_70170_p.field_72995_K) {
                Element element = WizardClassWeaponHelper.getElement(stack);
                switch (element) {
                    case MAGIC: {
                        Vec3d origin = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - 0.5, player.field_70161_v);
                        Vec3d hit = origin.func_178787_e(player.func_70040_Z().func_186678_a((double)player.func_70032_d(event.getTarget())));
                        Vec3d vec1 = player.func_70040_Z().func_178789_a(90.0f);
                        Vec3d vec2 = player.func_70040_Z().func_72431_c(vec1);
                        for (int i = 0; i < 15; ++i) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(hit).vel(vec1.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)).func_178787_e(vec2.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)))).clr(1.0f, 1.0f, 1.0f).fade(0.3f, 0.5f, 1.0f).time(8 + random.nextInt(4)).spawn(player.field_70170_p);
                        }
                        break;
                    }
                    case NECROMANCY: {
                        Vec3d origin = player.func_174824_e(1.0f);
                        Vec3d hit = origin.func_178787_e(player.func_70040_Z().func_186678_a((double)player.func_70032_d(event.getTarget())));
                        Vec3d vec1 = player.func_70040_Z().func_178789_a(90.0f);
                        Vec3d vec2 = player.func_70040_Z().func_72431_c(vec1);
                        for (int i = 0; i < 15; ++i) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(hit).vel(vec1.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)).func_178787_e(vec2.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)))).clr(0.5f, 0.0f, 0.0f).time(8 + random.nextInt(4)).spawn(player.field_70170_p);
                        }
                        break;
                    }
                    case LIGHTNING: {
                        ParticleBuilder.spawnShockParticles((World)player.field_70170_p, (double)event.getTarget().field_70165_t, (double)(event.getTarget().field_70163_u + (double)(event.getTarget().field_70131_O / 2.0f)), (double)event.getTarget().field_70161_v);
                        List secondaryTargets = EntityUtils.getLivingWithinRadius((double)4.0, (double)event.getTarget().field_70165_t, (double)(event.getTarget().field_70163_u + (double)(event.getTarget().field_70131_O / 2.0f)), (double)event.getTarget().field_70161_v, (World)player.field_70170_p);
                        secondaryTargets.stream().filter(entity -> !entity.equals((Object)event.getTarget())).filter(EntityUtils::isLiving).filter(e -> AllyDesignationSystem.isValidTarget((Entity)player, (Entity)e)).limit(3L).forEach(secondaryTarget -> EnumElementalSwordEffect.electrocute(event.getTarget().field_70170_p, (Entity)player, event.getTarget().func_174791_d().func_72441_c(0.0, (double)(event.getTarget().field_70131_O / 2.0f), 0.0), (Entity)secondaryTarget, 4.0f, 0));
                        break;
                    }
                    case ICE: {
                        double particleZ;
                        int i;
                        Vec3d origin = player.func_174824_e(1.0f);
                        Vec3d hit = origin.func_178787_e(player.func_70040_Z().func_186678_a((double)player.func_70032_d(event.getTarget())));
                        Vec3d vec1 = player.func_70040_Z().func_178789_a(90.0f);
                        Vec3d vec2 = player.func_70040_Z().func_72431_c(vec1);
                        for (int i2 = 0; i2 < 15; ++i2) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).pos(hit).vel(vec1.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)).func_178787_e(vec2.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)))).time(8 + random.nextInt(4)).spawn(player.field_70170_p);
                        }
                        if (!WizardClassWeaponHelper.isChargeFull(stack)) break;
                        for (i = 0; i < 10; ++i) {
                            double particleX = event.getTarget().field_70165_t - 1.0 + 2.0 * event.getTarget().field_70170_p.field_73012_v.nextDouble();
                            particleZ = event.getTarget().field_70161_v - 1.0 + 2.0 * event.getTarget().field_70170_p.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).pos(particleX, event.getTarget().field_70163_u + 1.0, particleZ).vel((particleX - event.getTarget().field_70165_t) * 0.3, 0.0, (particleZ - event.getTarget().field_70161_v) * 0.3).time(20).spawn(event.getTarget().field_70170_p);
                        }
                        for (i = 0; i < 40; ++i) {
                            double particleX = event.getTarget().field_70165_t - 1.0 + 2.0 * event.getTarget().field_70170_p.field_73012_v.nextDouble();
                            particleZ = event.getTarget().field_70161_v - 1.0 + 2.0 * event.getTarget().field_70170_p.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SNOW).pos(particleX, event.getTarget().field_70163_u + 1.0, particleZ).vel((particleX - event.getTarget().field_70165_t) * 0.3, 0.0, (particleZ - event.getTarget().field_70161_v) * 0.3).time(20).spawn(event.getTarget().field_70170_p);
                        }
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack sword;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && (sword = (player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()).func_77973_b() instanceof ItemBattlemageSword) {
            HashMap<Runeword, Integer> map = ItemBattlemageSword.getActiveRunewords(sword);
            for (Map.Entry<Runeword, Integer> entry : map.entrySet()) {
                if (!entry.getKey().isAffectingDamageDirectly()) continue;
                event.setAmount(entry.getKey().affectDamage(event.getSource(), event.getAmount(), player, event.getEntityLiving(), sword));
            }
        }
    }
}

