/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.util.EntityUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemCircletOfCircling
extends ItemASArtefact
implements ITickableArtefact {
    private static final double MOVE_THRESHOLD = 0.5;
    private static final double RADIUS = 3.0;

    public ItemCircletOfCircling(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && entity.field_70173_aa % 5 == 0) {
            EntityPlayer player = (EntityPlayer)entity;
            List<EntityLiving> minions = this.getMinions(player);
            this.arrangeMinionsInCircle(player, minions);
        }
    }

    private List<EntityLiving> getMinions(EntityPlayer player) {
        List entities = EntityUtils.getEntitiesWithinRadius((double)20.0, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (World)player.field_70170_p, Entity.class);
        return entities.stream().filter(entity -> entity instanceof ISummonedCreature && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70643_av() == null).map(entity -> (EntityLiving)entity).sorted(Comparator.comparingInt(Entity::func_145782_y)).collect(Collectors.toList());
    }

    private void removeAIWander(EntityLiving minion) {
        minion.field_70714_bg.field_75782_a.removeIf(task -> task.field_75733_a instanceof EntityAIWander);
    }

    private void arrangeMinionsInCircle(EntityPlayer player, List<EntityLiving> minions) {
        int totalMinions = minions.size();
        double angleIncrement = Math.PI * 2 / (double)totalMinions;
        for (int i = 0; i < totalMinions; ++i) {
            EntityLiving minion = minions.get(i);
            this.removeAIWander(minion);
            double targetX = player.field_70165_t + 3.0 * Math.cos((double)i * angleIncrement);
            double targetZ = player.field_70161_v + 3.0 * Math.sin((double)i * angleIncrement);
            if (!(minion.func_70011_f(targetX, minion.field_70163_u, targetZ) > 0.5)) continue;
            minion.func_70661_as().func_75492_a(targetX, minion.field_70163_u, targetZ, 1.2);
        }
    }
}

