/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.AbstractItemArtefactWithSlots;
import com.windanesz.ancientspellcraft.item.ItemDailyArtefact;
import com.windanesz.ancientspellcraft.item.ItemTransmutationScroll;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArmourUpgrade;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCubeTransmutation
extends AbstractItemArtefactWithSlots
implements IManaStoringItem,
IWorkbenchItem {
    private static final int MANA_COST = 4000;
    private static final int MANA_CAPACITY = 4000;
    private static final String LAST_OPEN_TIME_TAG = "last_open_time";

    public ItemCubeTransmutation(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type, 1, 1, true);
        this.func_77656_e(4000);
        this.addReadinessPropertyOverride();
    }

    @Override
    public boolean isItemStackValid(ItemStack stack) {
        return !stack.func_190926_b() && ItemTransmutationScroll.Transmutation.canBeTransmuted(stack);
    }

    @Override
    public boolean isItemValid(Item item) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack p_showDurabilityBar_1_) {
        return super.showDurabilityBar(p_showDurabilityBar_1_);
    }

    public void addReadinessPropertyOverride() {
        this.func_185043_a(new ResourceLocation("ready"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (worldIn == null && entityIn != null) {
                    return ItemCubeTransmutation.isReady(entityIn.func_130014_f_(), stack) ? 0.0f : 1.0f;
                }
                return ItemCubeTransmutation.isReady(worldIn, stack) ? 0.0f : 1.0f;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        super.func_77624_a(stack, world, text, advanced);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            if (!player.field_70170_p.field_72995_K) {
                if (ItemCubeTransmutation.isReady(world, player.func_184586_b(hand))) {
                    if (AbstractItemArtefactWithSlots.getItemForSlot(player.func_184586_b(hand), 0).func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".no_item", new Object[0]), true);
                    } else if (this.getMana(player.func_184586_b(hand)) >= 4000) {
                        if (this.tryTransmute(player.func_184586_b(hand), world, player)) {
                            ItemCubeTransmutation.setLastOpenTimeCurrent(player.func_184586_b(hand), player.field_70170_p.func_82737_E());
                        }
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".not_enough_mana", new Object[]{4000}), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".not_ready", new Object[0]), true);
                }
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public static boolean isReady(World world, ItemStack stack) {
        if (world != null && !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b(LAST_OPEN_TIME_TAG)) {
            long currentWorldTime = world.func_82737_E();
            long lastAccess = stack.func_77978_p().func_74763_f(LAST_OPEN_TIME_TAG);
            return ItemCubeTransmutation.isFullDayBetween(lastAccess, currentWorldTime);
        }
        return true;
    }

    public static boolean isFullDayBetween(long startTime, long endTime) {
        long fullDay = 24000L;
        return endTime - startTime >= fullDay;
    }

    public static void setLastOpenTimeCurrent(ItemStack stack, long currentTime) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        }
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean tryTransmute(ItemStack cubeStack, World world, EntityPlayer player) {
        ItemStack slotItem = AbstractItemArtefactWithSlots.getItemForSlot(cubeStack, 0);
        if (slotItem.func_190926_b() && !world.field_72995_K) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation.no_items_to_transmute", new Object[0]), false);
            return false;
        }
        if (!ItemTransmutationScroll.Transmutation.canBeTransmuted(slotItem)) {
            if (world.field_72995_K) return true;
            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation.invalid_item", new Object[0]), false);
            return true;
        }
        if (world.field_72995_K) return true;
        boolean transmuted = false;
        ItemStack transmutedItem = ItemStack.field_190927_a;
        if (slotItem.func_77973_b() instanceof ItemArmourUpgrade) {
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_runic_hammer)) {
                if (slotItem.func_77973_b() == WizardryItems.crystal_silver_plating) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                    return false;
                }
                transmuted = true;
                transmutedItem = new ItemStack(WizardryItems.crystal_silver_plating);
            } else if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_fabrikator_toolkit)) {
                if (slotItem.func_77973_b() == WizardryItems.resplendent_thread) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                    return false;
                }
                transmuted = true;
                transmutedItem = new ItemStack(WizardryItems.resplendent_thread);
            } else if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_scissors)) {
                if (slotItem.func_77973_b() == WizardryItems.ethereal_crystalweave) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                    return false;
                }
                transmuted = true;
                transmutedItem = new ItemStack(WizardryItems.ethereal_crystalweave);
            }
        }
        if (ItemTransmutationScroll.Transmutation.getMatchingTransmutation(slotItem) == ItemTransmutationScroll.Transmutation.ARTEFACT) {
            String rarity = slotItem.func_77973_b().getForgeRarity(slotItem).getName().toLowerCase();
            LootTable table = world.func_184146_ak().func_186521_a(new ResourceLocation("ebwizardry", "subsets/" + rarity + "_artefacts"));
            LootContext context = new LootContext.Builder((WorldServer)world).func_186470_a(player).func_186469_a(0.0f).func_186471_a();
            boolean isArtefactActive = false;
            ItemArtefact charm = null;
            if (rarity.equals(EnumRarity.UNCOMMON.field_77934_f.toLowerCase()) || rarity.equals(EnumRarity.RARE.field_77934_f.toLowerCase()) || rarity.equals(EnumRarity.EPIC.field_77934_f.toLowerCase())) {
                List charmSlot = ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[]{ItemArtefact.Type.CHARM});
                if (!(charmSlot.isEmpty() || (charm = (ItemArtefact)charmSlot.get(0)) != ASItems.charm_scissors && charm != ASItems.charm_fabrikator_toolkit && charm != ASItems.charm_runic_hammer)) {
                    isArtefactActive = true;
                }
                for (int i = 0; i < 60; ++i) {
                    ItemStack artefactCandidate;
                    Item item;
                    List stacks = table.func_186462_a(world.field_73012_v, context);
                    if (stacks.isEmpty() || (item = (artefactCandidate = (ItemStack)stacks.get(0)).func_77973_b()) == slotItem.func_77973_b()) continue;
                    if (isArtefactActive) {
                        if (charm == ASItems.charm_scissors) {
                            if ((!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.AMULET) && (!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.BELT)) continue;
                            transmuted = true;
                            transmutedItem = artefactCandidate;
                            break;
                        }
                        if (charm == ASItems.charm_fabrikator_toolkit) {
                            if (!(item instanceof ItemArtefact && ((ItemArtefact)item).getType() == ItemArtefact.Type.CHARM || item instanceof ItemArtefact && ((ItemArtefact)item).getType() == ItemArtefact.Type.HEAD) && !(item instanceof ItemDailyArtefact)) continue;
                            transmuted = true;
                            transmutedItem = artefactCandidate;
                            break;
                        }
                        if (!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.RING) continue;
                        transmuted = true;
                        transmutedItem = artefactCandidate;
                        break;
                    }
                    transmuted = true;
                    transmutedItem = artefactCandidate;
                    break;
                }
            }
        }
        if (!transmuted) {
            Item relatedArtefact = ItemTransmutationScroll.Transmutation.getRelatedArtefact(slotItem);
            boolean applyArtefactEffect = false;
            if (relatedArtefact != Items.field_190931_a) {
                if (relatedArtefact instanceof ItemArtefact) {
                    applyArtefactEffect = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)relatedArtefact);
                } else if (relatedArtefact instanceof ItemArtefact) {
                    applyArtefactEffect = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)relatedArtefact);
                }
            }
            transmutedItem = ItemTransmutationScroll.Transmutation.transmuteStack(slotItem, applyArtefactEffect);
        }
        if (transmutedItem == ItemStack.field_190927_a) return true;
        if (transmutedItem.func_77969_a(slotItem)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("Transmutation failed", new Object[0]));
            player.func_184811_cZ().func_185145_a((Item)this, 20);
            return false;
        }
        world.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, ASSounds.TRANSMUTATION, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
        this.setMana(cubeStack, this.getMana(cubeStack) - 4000);
        AbstractItemArtefactWithSlots.setItemForSlot(cubeStack, 0, transmutedItem);
        return true;
    }
}

