/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.registry.ASTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemDailyArtefact
extends ItemArtefact {
    private static final String LAST_OPEN_TIME_TAG = "last_open_time";
    private final EnumRarity rarity;

    public ItemDailyArtefact(EnumRarity rarity) {
        super(rarity, ItemArtefact.Type.CHARM);
        this.func_77625_d(1);
        this.rarity = rarity;
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
    }

    public void addReadinessPropertyOverride() {
        this.func_185043_a(new ResourceLocation("ready"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (worldIn == null && entityIn != null) {
                    return ItemDailyArtefact.isReady(entityIn.func_130014_f_(), stack) ? 0.0f : 1.0f;
                }
                return ItemDailyArtefact.isReady(worldIn, stack) ? 0.0f : 1.0f;
            }
        });
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.rarity == EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        Wizardry.proxy.addMultiLineDescription(tooltip, "tooltip.ancientspellcraft:artefact_use.usage", new Style().func_150217_b(Boolean.valueOf(true)), new Object[0]);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        long currentWorldTime = player.field_70170_p.func_82737_E();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(LAST_OPEN_TIME_TAG)) {
            long lastAccess = stack.func_77978_p().func_74763_f(LAST_OPEN_TIME_TAG);
            if (ItemDailyArtefact.isFullDayBetween(lastAccess, currentWorldTime)) {
                this.performAction(player);
                ItemDailyArtefact.setLastOpenTimeCurrent(stack, currentWorldTime);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!player.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".empty", new Object[0]), true);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        this.performAction(player);
        ItemDailyArtefact.setLastOpenTimeCurrent(stack, currentWorldTime);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static boolean isReady(World world, ItemStack stack) {
        if (world != null && !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b(LAST_OPEN_TIME_TAG)) {
            long currentWorldTime = world.func_82737_E();
            long lastAccess = stack.func_77978_p().func_74763_f(LAST_OPEN_TIME_TAG);
            return ItemDailyArtefact.isFullDayBetween(lastAccess, currentWorldTime);
        }
        return true;
    }

    public static boolean isFullDayBetween(long startTime, long endTime) {
        long fullDay = 24000L;
        return endTime - startTime >= fullDay;
    }

    public abstract void performAction(EntityPlayer var1);

    public static void setLastOpenTimeCurrent(ItemStack stack, long currentTime) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a(LAST_OPEN_TIME_TAG, currentTime);
            stack.func_77982_d(nbt);
        }
    }
}

