/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemArtefact;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDiamondGoose
extends ItemASArtefact
implements ITickableArtefact {
    private static final String NBT_BOUND_BLOCK = "boundBlock";
    private static final String NBT_LAST_DIRECTION_TIME = "lastDirectionTime";
    private static final String NBT_LAST_MID_RANGE_QUACK = "lastMidRangeQuackState";
    private static final int CHECK_INTERVAL = 40;
    private static final int HELD_CHECK_INTERVAL = 40;
    private static final int DIRECTION_COOLDOWN = 200;
    private static final int CLOSE_RANGE_MAX = 4;
    private static final int MID_RANGE_MIN = 5;
    private static final Random rand = new Random();

    public ItemDiamondGoose(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            String existingBlock = this.getNBTString(stack);
            if (existingBlock != null && !existingBlock.isEmpty()) {
                ASUtils.sendMessage((Entity)player, this.func_77658_a() + ".already_bound", false, new Object[0]);
                return EnumActionResult.FAIL;
            }
            Block block = world.func_180495_p(pos).func_177230_c();
            String blockName = block.getRegistryName().toString();
            this.setNBTString(stack, blockName);
            ASUtils.sendMessage((Entity)player, this.func_77658_a() + ".bound", false, new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        if (entity.field_70173_aa % 80 != 0) {
            return;
        }
        if (!(entity instanceof EntityPlayer) || entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        String boundBlockName = this.getNBTString(stack);
        if (boundBlockName == null || boundBlockName.isEmpty()) {
            return;
        }
        BlockDetectionResult result = this.findNearestBoundBlock(player, boundBlockName);
        this.handleQuackingByDistance(stack, player, result.getDistance());
    }

    private BlockDetectionResult findNearestBoundBlock(EntityPlayer player, String boundBlockName) {
        BlockPos playerPos = player.func_180425_c();
        World world = player.field_70170_p;
        double closestDistance = Double.MAX_VALUE;
        BlockPos closestPos = null;
        int detectionRange = Settings.generalSettings.diamondGooseDetectionRange;
        for (int x = -detectionRange; x <= detectionRange; ++x) {
            for (int y = -detectionRange; y <= detectionRange; ++y) {
                for (int z = -detectionRange; z <= detectionRange; ++z) {
                    double distance;
                    Block block;
                    BlockPos checkPos = playerPos.func_177982_a(x, y, z);
                    if (playerPos.func_177951_i((Vec3i)checkPos) > (double)(detectionRange * detectionRange) || !(block = world.func_180495_p(checkPos).func_177230_c()).getRegistryName().toString().equals(boundBlockName) || !((distance = playerPos.func_177951_i((Vec3i)checkPos)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestPos = checkPos;
                }
            }
        }
        if (closestPos != null) {
            EnumFacing direction = this.calculateRelativeDirection(player, closestPos);
            int distance = (int)Math.sqrt(closestDistance);
            return new BlockDetectionResult(true, distance, direction);
        }
        return new BlockDetectionResult(false, 0, null);
    }

    private void handleQuackingByDistance(ItemStack stack, EntityPlayer player, int distance) {
        if (distance > 0 && distance <= 4) {
            this.quack(player);
        } else if (distance >= 5 && distance <= Settings.generalSettings.diamondGooseDetectionRange) {
            boolean lastQuackState = this.getNBTBoolean(stack, false);
            if (!lastQuackState) {
                this.quack(player);
            }
            this.setNBTBoolean(stack, NBT_LAST_MID_RANGE_QUACK, !lastQuackState);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        long lastTime;
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof EntityPlayer) || world.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.field_70173_aa % 40 != 0) {
            return;
        }
        String boundBlockName = this.getNBTString(stack);
        if (boundBlockName == null || boundBlockName.isEmpty()) {
            return;
        }
        long currentTime = world.func_82737_E();
        if (currentTime - (lastTime = this.getNBTLong(stack, NBT_LAST_DIRECTION_TIME, 0L)) < 200L) {
            return;
        }
        BlockDetectionResult result = this.findNearestBoundBlock(player, boundBlockName);
        if (result.isBlockFound()) {
            this.indicateDirection(player, result.getDirection());
            this.setNBTLong(stack, NBT_LAST_DIRECTION_TIME, currentTime);
        }
    }

    private EnumFacing calculateRelativeDirection(EntityPlayer player, BlockPos target) {
        double dx = (double)target.func_177958_n() + 0.5 - player.field_70165_t;
        double dy = (double)target.func_177956_o() + 0.5 - player.field_70163_u - (double)player.func_70047_e();
        double dz = (double)target.func_177952_p() + 0.5 - player.field_70161_v;
        double lookX = -Math.sin(Math.toRadians(player.field_70177_z));
        double lookZ = Math.cos(Math.toRadians(player.field_70177_z));
        double dotProductHorizontal = dx * lookX + dz * lookZ;
        double crossProduct = dx * lookZ - dz * lookX;
        double absDot = Math.abs(dotProductHorizontal);
        double absCross = Math.abs(crossProduct);
        double absY = Math.abs(dy);
        if (absY > absDot && absY > absCross) {
            return dy > 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (absDot > absCross) {
            return dotProductHorizontal > 0.0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
        }
        return crossProduct > 0.0 ? EnumFacing.WEST : EnumFacing.EAST;
    }

    private void indicateDirection(EntityPlayer player, EnumFacing direction) {
        String translationKey = this.func_77658_a() + ".";
        switch (direction) {
            case NORTH: {
                translationKey = translationKey + "forward";
                break;
            }
            case SOUTH: {
                translationKey = translationKey + "backward";
                break;
            }
            case EAST: {
                translationKey = translationKey + "right";
                break;
            }
            case WEST: {
                translationKey = translationKey + "left";
                break;
            }
            case UP: {
                translationKey = translationKey + "up";
                break;
            }
            case DOWN: {
                translationKey = translationKey + "down";
                break;
            }
            default: {
                translationKey = translationKey + "nearby";
            }
        }
        ASUtils.sendMessage((Entity)player, translationKey, false, new Object[0]);
    }

    private void quack(EntityPlayer player) {
        if (rand.nextFloat() < 0.15f) {
            String[] quackMessages = new String[]{this.func_77658_a() + ".quack1", this.func_77658_a() + ".quack2", this.func_77658_a() + ".quack3"};
            String message = quackMessages[rand.nextInt(quackMessages.length)];
            ASUtils.sendMessage((Entity)player, message, false, new Object[0]);
        }
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ASSounds.GOOSE, SoundCategory.PLAYERS, 1.0f, 0.9f + rand.nextFloat() * 0.2f);
    }

    private String getNBTString(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_BOUND_BLOCK)) {
            return null;
        }
        return stack.func_77978_p().func_74779_i(NBT_BOUND_BLOCK);
    }

    private void setNBTString(ItemStack stack, String value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(NBT_BOUND_BLOCK, value);
    }

    private boolean getNBTBoolean(ItemStack stack, boolean defaultValue) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_LAST_MID_RANGE_QUACK)) {
            return defaultValue;
        }
        return stack.func_77978_p().func_74767_n(NBT_LAST_MID_RANGE_QUACK);
    }

    private void setNBTBoolean(ItemStack stack, String key, boolean value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(key, value);
    }

    private long getNBTLong(ItemStack stack, String key, long defaultValue) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(key)) {
            return defaultValue;
        }
        return stack.func_77978_p().func_74763_f(key);
    }

    private void setNBTLong(ItemStack stack, String key, long value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a(key, value);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String boundBlock = this.getNBTString(stack);
        if (boundBlock != null && !boundBlock.isEmpty()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(boundBlock));
            if (block != null) {
                String baseKey = this.func_77658_a() + ".tooltip.";
                tooltip.add(TextFormatting.GRAY + AncientSpellcraft.proxy.translate(baseKey + "imprinted", block.func_149732_F()));
                tooltip.add(TextFormatting.DARK_AQUA + AncientSpellcraft.proxy.translate(baseKey + "quack", new Object[0]));
                tooltip.add(TextFormatting.DARK_AQUA + AncientSpellcraft.proxy.translate(baseKey + "excited", new Object[0]));
            }
        } else {
            tooltip.add(TextFormatting.GRAY + AncientSpellcraft.proxy.translate(this.func_77658_a() + ".tooltip.bind", new Object[0]));
        }
    }

    private static class BlockDetectionResult {
        private final boolean blockFound;
        private final int distance;
        private final EnumFacing direction;

        public BlockDetectionResult(boolean blockFound, int distance, EnumFacing direction) {
            this.blockFound = blockFound;
            this.distance = distance;
            this.direction = direction;
        }

        public boolean isBlockFound() {
            return this.blockFound;
        }

        public int getDistance() {
            return this.distance;
        }

        public EnumFacing getDirection() {
            return this.direction;
        }
    }

    private static enum DetectionRange {
        NONE,
        CLOSE,
        MEDIUM,
        FAR;

    }
}

