/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.AbstractItemArtefactWithSlots;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemHungryChest
extends AbstractItemArtefactWithSlots {
    private static final float DROP_OFFSET = 0.5f;
    private static final int MAGIC_ELEMENT_COUNT = 7;
    private static final int MAGIC_ELEMENT_START = 1;

    public ItemHungryChest(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type, 1, 1, true);
    }

    public static ItemStack getScroll(ItemStack stack) {
        return AbstractItemArtefactWithSlots.getItemForSlot(stack, 0);
    }

    @Override
    public boolean isItemValid(Item item) {
        return item instanceof ItemSpellBook;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.field_72995_K) {
            return;
        }
        ItemStack bookStack = ItemHungryChest.getScroll(stack);
        if (bookStack.func_190926_b() || !(bookStack.func_77973_b() instanceof ItemSpellBook)) {
            return;
        }
        AbstractItemArtefactWithSlots.setItemForSlot(stack, 0, ItemStack.field_190927_a);
        Spell spell = Spell.byMetadata((int)bookStack.func_77952_i());
        if (spell == Spells.magic_missile) {
            entityIn.func_70099_a(bookStack, 0.5f);
            return;
        }
        ItemStack ruinedBook = new ItemStack(WizardryItems.ruined_spell_book);
        entityIn.func_70099_a(ruinedBook, 0.5f);
        Element element = spell.getElement();
        int dustAmount = this.getDustAmountForTier(spell.getTier(), worldIn);
        if (element != Element.MAGIC) {
            this.dropNonMagicSpellRewards(entityIn, dustAmount, element.ordinal());
        } else {
            this.dropMagicSpellRewards(entityIn, dustAmount, worldIn);
        }
    }

    private int getDustAmountForTier(Tier tier, World world) {
        switch (tier) {
            case NOVICE: {
                return 1 + world.field_73012_v.nextInt(3);
            }
            case APPRENTICE: {
                return 2 + world.field_73012_v.nextInt(2);
            }
            case ADVANCED: {
                return 2 + world.field_73012_v.nextInt(3);
            }
            case MASTER: {
                return 4;
            }
        }
        return 1;
    }

    private void dropNonMagicSpellRewards(Entity entity, int dustAmount, int elementMeta) {
        ItemStack dustStack = new ItemStack(WizardryItems.spectral_dust, dustAmount, elementMeta);
        entity.func_70099_a(dustStack, 0.5f);
    }

    private void dropMagicSpellRewards(Entity entity, int dustAmount, World world) {
        ArrayList<Integer> metas = new ArrayList<Integer>();
        for (int m = 1; m <= 7; ++m) {
            metas.add(m);
        }
        Collections.shuffle(metas, world.field_73012_v);
        for (int i = 0; i < dustAmount && i < metas.size(); ++i) {
            int randomMeta = (Integer)metas.get(i);
            ItemStack dustStack = new ItemStack(WizardryItems.spectral_dust, 1, randomMeta);
            entity.func_70099_a(dustStack, 0.5f);
        }
    }
}

