/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemInfernalStone
extends ItemASArtefact
implements ITickableArtefact {
    private static final String NBT_HEAT_PROGRESS = "heatProgress";
    private static final int MAX_HEAT = 100;
    private static final int HEAT_LOSS_INTERVAL = 60;
    private static final int FIRE_ABSORPTION_INTERVAL = 3;
    private static final int FIRE_ABSORPTION_RANGE = 3;
    private static final float HEAT_PER_FIRE_BLOCK = 5.0f;
    private static final float HEAT_LOSS_RATE = 1.0f;
    private static final float MANA_COST_REDUCTION = 0.25f;
    private static final float HEAT_CONSUMPTION_PER_SPELL = 10.0f;

    public ItemInfernalStone(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        super.func_77663_a(stack, world, entity, slot, isHeld);
        if (!world.field_72995_K && isHeld && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70173_aa % 3 == 0) {
                System.out.println("Infernal Stone onUpdate - held in hand, checking for fire...");
                this.absorbNearbyFire(player, stack);
            }
        }
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            if (player.field_70173_aa % 60 == 0) {
                ItemInfernalStone.removeHeat(itemstack, 1.0f);
            }
            if (this.isHeldInHand(entityPlayer, itemstack) && player.field_70173_aa % 3 == 0) {
                if (!player.field_70170_p.field_72995_K) {
                    System.out.println("Infernal Stone tick - held in hand, checking for fire...");
                }
                this.absorbNearbyFire(entityPlayer, itemstack);
            }
        }
    }

    public boolean isHeldInHand(EntityPlayer player, ItemStack stone) {
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        return !mainHand.func_190926_b() && mainHand.func_77973_b() == stone.func_77973_b() || !offHand.func_190926_b() && offHand.func_77973_b() == stone.func_77973_b();
    }

    public void absorbNearbyFire(EntityPlayer player, ItemStack stone) {
        BlockPos playerPos = player.func_180425_c();
        boolean foundFire = false;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y, z);
                    if (player.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150480_ab) continue;
                    player.field_70170_p.func_175698_g(pos);
                    ItemInfernalStone.addHeat(stone, 5.0f);
                    foundFire = true;
                    if (player.field_70170_p.field_72995_K) break;
                    System.out.println("Infernal Stone absorbed fire at " + pos + ", heat: " + ItemInfernalStone.getHeatPercentage(stone) + "%");
                    break;
                }
                if (foundFire) break;
            }
            if (foundFire) break;
        }
    }

    public static void addHeat(ItemStack stack, float amount) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int currentHeat = stack.func_77978_p().func_74762_e(NBT_HEAT_PROGRESS);
        int newHeat = Math.min(100, currentHeat + (int)amount);
        stack.func_77978_p().func_74768_a(NBT_HEAT_PROGRESS, newHeat);
    }

    public static void removeHeat(ItemStack stack, float amount) {
        if (!stack.func_77942_o()) {
            return;
        }
        int currentHeat = stack.func_77978_p().func_74762_e(NBT_HEAT_PROGRESS);
        int newHeat = Math.max(0, currentHeat - (int)amount);
        stack.func_77978_p().func_74768_a(NBT_HEAT_PROGRESS, newHeat);
    }

    public static int getHeatPercentage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(NBT_HEAT_PROGRESS);
    }

    public static boolean isHot(ItemStack stack) {
        return ItemInfernalStone.getHeatPercentage(stack) > 0;
    }

    public static void consumeHeatForSpell(ItemStack stack) {
        ItemInfernalStone.removeHeat(stack, 10.0f);
    }

    public static void applyFireSpellBonuses(SpellModifiers modifiers, ItemStack stack) {
        if (ItemInfernalStone.isHot(stack)) {
            float currentCost = modifiers.get("cost");
            modifiers.set("cost", currentCost * 0.75f, false);
        }
    }

    public int getItemBurnTime(ItemStack itemStack) {
        if (ItemInfernalStone.getHeatPercentage(itemStack) >= 50) {
            return 8000;
        }
        return 0;
    }

    public boolean isFurnaceFuel(ItemStack itemStack) {
        return ItemInfernalStone.getHeatPercentage(itemStack) >= 1;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.isFurnaceFuel(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!this.isFurnaceFuel(stack)) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        return copy;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int heatPercentage = ItemInfernalStone.getHeatPercentage(stack);
        String heatColor = heatPercentage >= 75 ? TextFormatting.RED.toString() : (heatPercentage >= 50 ? TextFormatting.GOLD.toString() : (heatPercentage >= 25 ? TextFormatting.YELLOW.toString() : TextFormatting.GRAY.toString()));
        tooltip.add(TextFormatting.GRAY + "Heat: " + heatColor + heatPercentage + "%");
        if (heatPercentage >= 50) {
            tooltip.add(TextFormatting.GREEN + "Can be used as furnace fuel");
        }
    }
}

