/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemManaArtefact
extends ItemASArtefact
implements IManaStoringItem,
IWorkbenchItem {
    public ItemManaArtefact(EnumRarity rarity, ItemArtefact.Type type, int mana) {
        super(rarity, type);
        this.func_77656_e(mana);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return super.getMaxDamage(stack);
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        super.func_77624_a(stack, world, text, advanced);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return DrawingUtils.mix((int)16747518, (int)9318116, (float)((float)this.getDurabilityForDisplay(stack)));
    }
}

