/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemMaskOfPerseigni
extends ItemASArtefact
implements ITickableArtefact {
    private static final int CHECK_INTERVAL = 20;
    private static final double RANGE = 10.0;
    private static final int MANA_COST = 15;

    public ItemMaskOfPerseigni(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        Entity target;
        EntityPlayer entityPlayer;
        ItemStack wandStack;
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 20 == 0 && player instanceof EntityPlayer && (wandStack = this.findWandWithPyrokinesis(entityPlayer = (EntityPlayer)player)) != null && this.hasSufficientMana(wandStack) && (target = this.getEntityInSight(entityPlayer)) instanceof EntityLivingBase && target != entityPlayer) {
            this.applyPyrokinesisEffects(entityPlayer, (EntityLivingBase)target, wandStack);
        }
    }

    private ItemStack findWandWithPyrokinesis(EntityPlayer player) {
        List<ItemStack> hotbarWands = ASUtils.getAllHotbarWands(player);
        for (ItemStack wandStack : hotbarWands) {
            if (!(wandStack.func_77973_b() instanceof ItemWand)) continue;
            ItemWand wand = (ItemWand)wandStack.func_77973_b();
            for (Spell spell : wand.getSpells(wandStack)) {
                if (!spell.getRegistryName().toString().equals("ancientspellcraft:pyrokinesis")) continue;
                return wandStack;
            }
        }
        return null;
    }

    private boolean hasSufficientMana(ItemStack wandStack) {
        if (wandStack.func_77973_b() instanceof ItemWand) {
            ItemWand wand = (ItemWand)wandStack.func_77973_b();
            return wand.getMana(wandStack) >= 15;
        }
        return false;
    }

    private Entity getEntityInSight(EntityPlayer player) {
        Vec3d endpoint;
        RayTraceResult rayTrace;
        Vec3d look = player.func_70040_Z();
        Vec3d origin = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - 0.25, player.field_70161_v);
        if (player.field_70170_p.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)player)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        if ((rayTrace = RayTracer.rayTrace((World)player.field_70170_p, (Vec3d)origin, (Vec3d)(endpoint = origin.func_178787_e(look.func_186678_a(10.0))), (float)0.4f, (boolean)false, (boolean)true, (boolean)false, Entity.class, (Predicate)RayTracer.ignoreEntityFilter((Entity)player))) != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            return rayTrace.field_72308_g;
        }
        return null;
    }

    private void applyPyrokinesisEffects(EntityPlayer caster, EntityLivingBase target, ItemStack wandStack) {
        World world = caster.field_70170_p;
        if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FIRE, (Entity)target)) {
            return;
        }
        target.func_70015_d(10);
        EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), (float)3.0f);
        target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 30, 1));
        this.spawnParticlesAroundTarget(target);
        if (wandStack.func_77973_b() instanceof ItemWand) {
            ItemWand wand = (ItemWand)wandStack.func_77973_b();
            wand.consumeMana(wandStack, 15, (EntityLivingBase)caster);
        }
    }

    private void spawnParticlesAroundTarget(EntityLivingBase target) {
        if (target.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx = target.field_70170_p.field_73012_v.nextDouble() * (double)(target.field_70170_p.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                double dy = target.field_70170_p.field_73012_v.nextDouble() * (double)(target.field_70170_p.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                double dz = target.field_70170_p.field_73012_v.nextDouble() * (double)(target.field_70170_p.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).entity((Entity)target).pos(0.0, (double)(target.field_70131_O / 2.0f), 0.0).vel(dx, dy, dz).spawn(target.field_70170_p);
            }
        }
    }
}

