/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.DiscoverSpellEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOmnicron
extends ItemASArtefact
implements IWorkbenchItem,
IManaStoringItem {
    private static final int MAX_MANA = 10000;

    public ItemOmnicron(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77625_d(1);
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
        this.func_77656_e(10000);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        Wizardry.proxy.addMultiLineDescription(tooltip, "tooltip.ancientspellcraft:artefact_use.usage", new Style().func_150217_b(Boolean.valueOf(true)), new Object[0]);
        super.func_77624_a(stack, world, tooltip, advanced);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return DrawingUtils.mix((int)16747518, (int)9318116, (float)((float)this.getDurabilityForDisplay(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack cubeStack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".wrong_hand", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)cubeStack);
        }
        ItemStack offhandStack = player.func_184592_cb();
        if (!(offhandStack.func_77973_b() instanceof ItemSpellBook) && !(offhandStack.func_77973_b() instanceof ItemScroll)) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".wrong_item", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)cubeStack);
        }
        if (WizardData.get((EntityPlayer)player) != null) {
            Spell spell;
            WizardData data = WizardData.get((EntityPlayer)player);
            if (!data.hasSpellBeenDiscovered(spell = Spell.byMetadata((int)offhandStack.func_77952_i()))) {
                int requiredMana;
                switch (spell.getTier()) {
                    case NOVICE: {
                        requiredMana = 3000;
                        break;
                    }
                    case ADVANCED: {
                        requiredMana = 7000;
                        break;
                    }
                    case MASTER: {
                        requiredMana = 10000;
                        break;
                    }
                    default: {
                        requiredMana = 5000;
                    }
                }
                if (this.getMana(cubeStack) < requiredMana) {
                    if (!world.field_72995_K) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".no_mana", new Object[]{requiredMana}));
                    }
                    return new ActionResult(EnumActionResult.PASS, (Object)cubeStack);
                }
                if (!MinecraftForge.EVENT_BUS.post((Event)new DiscoverSpellEvent(player, spell, DiscoverSpellEvent.Source.OTHER))) {
                    data.discoverSpell(spell);
                    player.func_184185_a(ASSounds.CHARM_OMNICRON, 1.25f, 1.0f);
                    if (!world.field_72995_K) {
                        this.consumeMana(cubeStack, requiredMana, (EntityLivingBase)player);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".discover", new Object[]{spell.getNameForTranslationFormatted()}));
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)cubeStack);
                }
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:identification_scroll.nothing_to_identify", new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)cubeStack);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return 10000;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int manaPerItem;
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int n = crystals.func_75211_c().func_77973_b() instanceof IManaStoringItem ? ((IManaStoringItem)crystals.func_75211_c().func_77973_b()).getMana(crystals.func_75211_c()) : (manaPerItem = crystals.func_75211_c().func_77973_b() instanceof ItemCrystal ? 100 : 10);
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }
}

