/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.integration.baubles.ASBaublesIntegration;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.ritual.ElementalAttunement;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryPotions;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ItemRainbowString
extends ItemASArtefact {
    private static final String CURRENT_ELEMENT_TAG = "CurrentElement";

    public ItemRainbowString(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        List<ItemStack> charmStacks;
        if (event.getEntityPlayer() != null && ItemRainbowString.isHoldingBow(event.getEntityPlayer()) && !(charmStacks = ASBaublesIntegration.getEquippedArtefactStacks(event.getEntityPlayer(), ItemArtefact.Type.CHARM)).isEmpty() && charmStacks.get(0).func_77973_b() instanceof ItemRainbowString) {
            ItemRainbowString.rotateElement(charmStacks.get(0));
        }
    }

    private static boolean isHoldingBow(EntityPlayer player) {
        return player.func_184614_ca().func_77973_b() instanceof ItemBow || player.func_184592_cb().func_77973_b() instanceof ItemBow;
    }

    private static void rotateElement(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        String currentElementName = nbt.func_74779_i(CURRENT_ELEMENT_TAG);
        Element currentElement = Element.fromName((String)currentElementName, (Element)Element.FIRE);
        Element[] elements = Element.values();
        Element newElement = elements[(currentElement.ordinal() + 1) % elements.length];
        nbt.func_74778_a(CURRENT_ELEMENT_TAG, newElement.func_176610_l());
    }

    private static Element getElement(ItemStack stack, EntityPlayer player) {
        Optional<Element> element = ElementalAttunement.getElement(player);
        if (element.isPresent()) {
            return element.get();
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            String currentElementName = nbt.func_74779_i(CURRENT_ELEMENT_TAG);
            return Element.fromName((String)currentElementName, (Element)Element.FIRE);
        }
        return Element.FIRE;
    }

    private static PotionEffect getEffect(Element element) {
        switch (element) {
            case NECROMANCY: {
                return new PotionEffect(MobEffects.field_82731_v, 40, 1);
            }
            case HEALING: {
                return new PotionEffect(MobEffects.field_76440_q, 60, 0);
            }
            case ICE: {
                return new PotionEffect(WizardryPotions.frost, 60, 0);
            }
            case EARTH: {
                return new PotionEffect(MobEffects.field_76436_u, 80, 0);
            }
            case SORCERY: {
                return new PotionEffect(MobEffects.field_188424_y, 35, 0);
            }
            case LIGHTNING: {
                return new PotionEffect(WizardryPotions.paralysis, 40, 0);
            }
        }
        return new PotionEffect(ASPotions.soul_scorch, 80, 0);
    }

    private static void createOrModifyTippedArrow(EntityArrow arrow, PotionEffect effect) {
        if (!(arrow instanceof EntityTippedArrow)) {
            EntityTippedArrow tippedArrow = new EntityTippedArrow(arrow.field_70170_p, (EntityLivingBase)arrow.field_70250_c);
            tippedArrow.func_70107_b(arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v);
            tippedArrow.func_70016_h(arrow.field_70159_w, arrow.field_70181_x, arrow.field_70179_y);
            tippedArrow.func_184558_a(effect);
            arrow.field_70170_p.func_72838_d((Entity)tippedArrow);
            arrow.func_70106_y();
        } else {
            ((EntityTippedArrow)arrow).func_184558_a(effect);
        }
    }

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow) {
            EntityPlayer shooter;
            List<ItemStack> charmStacks;
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer && !(charmStacks = ASBaublesIntegration.getEquippedArtefactStacks(shooter = (EntityPlayer)arrow.field_70250_c, ItemArtefact.Type.CHARM)).isEmpty() && charmStacks.get(0).func_77973_b() instanceof ItemRainbowString) {
                Element currentElement = ItemRainbowString.getElement(charmStacks.get(0), shooter);
                PotionEffect effect = ItemRainbowString.getEffect(currentElement);
                ItemRainbowString.createOrModifyTippedArrow(arrow, effect);
            }
        }
    }
}

