/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.entity.living.EntityRemnantMinion;
import com.windanesz.ancientspellcraft.item.ItemDailyArtefact;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.registry.WizardryItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRemnantCage
extends ItemDailyArtefact {
    private static final String HAS_REMNANT_TAG = "hasRemnant";
    private static final String STORED_ELEMENT_TAG = "storedElement";

    public ItemRemnantCage(EnumRarity rarity) {
        super(rarity);
        this.addReadinessPropertyOverride();
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && target instanceof EntityRemnant) {
            EntityRemnant remnant = (EntityRemnant)target;
            if (this.hasRemnant(stack)) {
                return false;
            }
            Element element = remnant.getElement();
            this.setStoredElement(stack, element);
            if (hand == EnumHand.MAIN_HAND) {
                player.func_184611_a(EnumHand.MAIN_HAND, stack);
            } else {
                player.func_184611_a(EnumHand.OFF_HAND, stack);
            }
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
            target.func_70106_y();
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (this.hasRemnant(stack)) {
                Element element;
                if (!world.field_72995_K && (element = this.getStoredElement(stack)) != null) {
                    EntityRemnantMinion minion = new EntityRemnantMinion(world);
                    minion.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    minion.setElement(element);
                    minion.setOwnerId(player.func_110124_au());
                    world.func_72838_d((Entity)minion);
                    this.clearRemnant(stack);
                    player.func_184611_a(hand, stack);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public void performAction(EntityPlayer player) {
        Element element;
        ItemStack stack = player.func_184614_ca();
        if (this.hasRemnant(stack) && (element = this.getStoredElement(stack)) != null) {
            ItemStack dust = new ItemStack(WizardryItems.spectral_dust, 1, element.ordinal());
            if (!player.field_71071_by.func_70441_a(dust)) {
                player.func_71019_a(dust, false);
            }
            this.clearRemnant(stack);
            player.func_184611_a(EnumHand.MAIN_HAND, stack);
        }
    }

    private boolean hasRemnant(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(HAS_REMNANT_TAG);
    }

    private void setStoredElement(ItemStack stack, Element element) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74757_a(HAS_REMNANT_TAG, true);
        nbt.func_74768_a(STORED_ELEMENT_TAG, element.ordinal());
        stack.func_77982_d(nbt);
    }

    private Element getStoredElement(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(STORED_ELEMENT_TAG)) {
            int elementOrdinal = stack.func_77978_p().func_74762_e(STORED_ELEMENT_TAG);
            return Element.values()[elementOrdinal];
        }
        return null;
    }

    private void clearRemnant(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_82580_o(HAS_REMNANT_TAG);
            nbt.func_82580_o(STORED_ELEMENT_TAG);
            stack.func_77982_d(nbt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (this.hasRemnant(stack)) {
            Element element = this.getStoredElement(stack);
            if (element != null) {
                tooltip.add("Contains a " + element.getFormattingCode() + element.getDisplayName() + " remnant");
                tooltip.add("Sneak-right-click to release as minion (resets daily usage)");
            }
        } else {
            super.func_77624_a(stack, world, tooltip, advanced);
        }
    }
}

