/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class ItemRingManaTransfer
extends ItemASArtefact
implements ITickableArtefact {
    private static final int MANA_THRESHOLD = 200;
    private static final int CHECK_INTERVAL = 100;
    private static final float FLASK_CONSUMPTION_CHANCE = 0.2f;

    public ItemRingManaTransfer(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer) || player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player;
        if (entityPlayer.field_70173_aa % 100 != 0) {
            return;
        }
        ItemStack mainHand = entityPlayer.func_184614_ca();
        ItemStack offHand = entityPlayer.func_184592_cb();
        if (this.shouldCheckWand(mainHand)) {
            this.checkAndConsumeFlask(entityPlayer, mainHand, EnumHand.MAIN_HAND);
        } else if (this.shouldCheckWand(offHand)) {
            this.checkAndConsumeFlask(entityPlayer, offHand, EnumHand.OFF_HAND);
        }
    }

    private boolean shouldCheckWand(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IManaStoringItem && ((IManaStoringItem)stack.func_77973_b()).getMana(stack) < 200;
    }

    private void checkAndConsumeFlask(EntityPlayer player, ItemStack wandStack, EnumHand hand) {
        if (player.field_70170_p.field_73012_v.nextFloat() >= 0.2f) {
            return;
        }
        ItemStack flaskToUse = this.findBestManaFlask(player);
        if (flaskToUse != null) {
            flaskToUse.func_190918_g(1);
            IManaStoringItem manaItem = (IManaStoringItem)wandStack.func_77973_b();
            int currentMana = manaItem.getMana(wandStack);
            int manaToRestore = this.getFlaskManaCapacity(flaskToUse);
            int newMana = Math.min(manaItem.getManaCapacity(wandStack), currentMana + manaToRestore);
            manaItem.setMana(wandStack, newMana);
            if (hand == EnumHand.MAIN_HAND) {
                player.func_184611_a(EnumHand.MAIN_HAND, wandStack);
            } else {
                player.func_184611_a(EnumHand.OFF_HAND, wandStack);
            }
        }
    }

    private ItemStack findBestManaFlask(EntityPlayer player) {
        ItemStack stack;
        int i;
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != WizardryItems.large_mana_flask) continue;
            return stack;
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != WizardryItems.medium_mana_flask) continue;
            return stack;
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != WizardryItems.small_mana_flask) continue;
            return stack;
        }
        return null;
    }

    private int getFlaskManaCapacity(ItemStack flaskStack) {
        if (flaskStack.func_77973_b() == WizardryItems.large_mana_flask) {
            return 1400;
        }
        if (flaskStack.func_77973_b() == WizardryItems.medium_mana_flask) {
            return 350;
        }
        if (flaskStack.func_77973_b() == WizardryItems.small_mana_flask) {
            return 75;
        }
        return 0;
    }
}

