/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.item.ItemRune;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.registry.Rituals;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.util.LangUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRitualBook
extends Item {
    public ItemRitualBook() {
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_RITUALS);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ASTabs.ANCIENTSPELLCRAFT_RITUALS) {
            List<Ritual> rituals = Ritual.getAllRituals();
            rituals.removeIf(r -> !r.applicableForItem(this));
            for (Ritual ritual : rituals) {
                ItemStack stack = new ItemStack((Item)this);
                ItemRitualBook.setRitual(stack, ritual);
                list.add((Object)stack);
            }
        }
    }

    public static Ritual getRitual(ItemStack stack) {
        String ritual;
        Ritual rit;
        if (stack.func_77973_b() instanceof ItemRitualBook && stack.func_77942_o() && stack.func_77978_p().func_74764_b("ritual") && (rit = (Ritual)Ritual.registry.getValue(new ResourceLocation(ritual = stack.func_77978_p().func_74779_i("ritual")))) != null) {
            return rit;
        }
        return Rituals.none;
    }

    public static void setRitual(ItemStack stack, Ritual ritual) {
        if (stack.func_77973_b() instanceof ItemRitualBook) {
            NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            compound.func_74778_a("ritual", ritual.getRegistryName().toString());
            stack.func_77982_d(compound);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Ritual ritual = ItemRitualBook.getRitual(stack);
        if (ritual != Rituals.none && !player.func_70093_af() && !player.func_184812_l_()) {
            player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.RITUAL_BOOK, world, 0, 0, 0);
        } else if (!world.field_72995_K && ritual != Rituals.none) {
            NonNullList<Ingredient> pattern = ritual.getRitualProperties().pattern;
            int width = ritual.getProperties().width;
            int height = ritual.getProperties().height;
            int middleIndex = width * height / 2;
            BlockPos playerPos = player.func_180425_c();
            EnumFacing playerFacing = player.func_174811_aO();
            BlockPos startingPos = playerPos.func_177967_a(playerFacing, width / 2).func_177967_a(playerFacing.func_176746_e(), height / 2);
            int counter = 0;
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < width; ++k) {
                    Ingredient ingredient = (Ingredient)pattern.get(counter);
                    BlockPos currentBlockPos = startingPos.func_177967_a(playerFacing, -k).func_177967_a(playerFacing.func_176746_e(), -j);
                    if (middleIndex != counter && ingredient.func_193365_a().length == 1 && ingredient.func_193365_a()[0].func_77973_b() instanceof ItemRune) {
                        ItemStack matchingStack = ingredient.func_193365_a()[0];
                        ((ItemRune)ASItems.rune_algiz).placeBlockAt(matchingStack, player, world, currentBlockPos, playerFacing.func_176735_f(), 0.0f, 0.0f, 0.0f, ASBlocks.PLACED_RUNE.func_176223_P());
                    } else {
                        world.func_175698_g(currentBlockPos);
                    }
                    ++counter;
                }
            }
            if (middleIndex < pattern.size()) {
                BlockPos middleBlockPos = startingPos.func_177967_a(playerFacing, -width / 2).func_177967_a(playerFacing.func_176746_e(), -height / 2);
                ((ItemRune)ASItems.rune_algiz).placeBlockAt(((Ingredient)pattern.get(middleIndex)).func_193365_a()[0], player, world, middleBlockPos, playerFacing, 0.0f, 0.0f, 0.0f, ASBlocks.PLACED_RUNE.func_176223_P());
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(itemstack, world, tooltip, advanced);
        if (world == null) {
            world = Wizardry.proxy.getTheWorld();
        }
        if (world != null && itemstack.func_77942_o() && ItemRitualBook.getRitual(itemstack) != Rituals.none) {
            Ritual ritual = ItemRitualBook.getRitual(itemstack);
            EntityPlayer player = Wizardry.proxy.getThePlayer();
            boolean discovered = AncientSpellcraft.proxy.shouldDisplayDiscovered(ritual, itemstack);
            if (!ritual.isEnabled()) {
                tooltip.add(AncientSpellcraft.proxy.translate("item.ancientspellcraft:ritual_book.desc_disabled", new Object[0]));
            } else if (!player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !discovered) {
                tooltip.add(LangUtils.toElderFuthark(ritual.getDisplayName()));
                tooltip.add(AncientSpellcraft.proxy.translate("item.ancientspellcraft:ritual_book.desc", new Object[0]));
            } else {
                tooltip.add(ritual.getDisplayName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }
}

