/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.ISpecialHandRenderItem;
import com.windanesz.ancientspellcraft.item.IWizardClassWeapon;
import com.windanesz.ancientspellcraft.item.WizardClassWeaponHelper;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.PerfectTheorySpell;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class ItemSageTome
extends Item
implements ISpellCastingItem,
IWorkbenchItem,
IWizardClassWeapon,
IManaStoringItem,
ISpecialHandRenderItem {
    public final ModelResourceLocation MODEL_3D;
    public static final int TOME_BASE_SPELL_SLOTS = 5;
    public static final IStoredVariable<BlockPos> LAST_POS = IStoredVariable.StoredVariable.ofBlockPos((String)"lastPlayerPos", (Persistence)Persistence.NEVER);
    private static final String MANA_AVAILABLE_TAG = "mana_available";
    private static final int CONTINUOUS_TRACKING_INTERVAL = 20;
    private static final float ELEMENTAL_PROGRESSION_MODIFIER = 1.2f;
    private static final float DISCOVERY_PROGRESSION_MODIFIER = 5.0f;
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;
    private static final float MAX_PROGRESSION_REDUCTION = 0.75f;
    public final int upgradeLimit;
    public Tier tier;
    public Element element;

    @Override
    public ModelResourceLocation getSpecialModel() {
        return this.MODEL_3D;
    }

    public ItemSageTome(Tier tier, Element element) {
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
        this.tier = tier;
        this.element = element;
        this.func_77656_e(this.tier.maxCharge);
        this.func_77625_d(1);
        this.upgradeLimit = this.tier.upgradeLimit;
        WizardryRecipes.addToManaFlaskCharging((Item)this);
        this.MODEL_3D = new ModelResourceLocation(String.format("ancientspellcraft:sage_tome_%s_%s_3d_model", tier.name().toLowerCase(), element.name().toLowerCase()), "3d_model");
    }

    private static EnumHand getOtherHandForSword(ItemStack stack, EntityLivingBase entity) {
        return entity.func_184614_ca().func_77973_b() instanceof ItemSageTome ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        WandHelper.decrementCooldowns((ItemStack)stack);
        if (!world.field_72995_K && !this.isManaFull(stack) && world.func_82737_E() % 50L == 0L) {
            this.rechargeMana(stack, WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.condenser_upgrade));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)super.getMaxDamage(stack) * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.storage_upgrade)) + 0.5f);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return false;
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!oldStack.func_190926_b() || !newStack.func_190926_b() && oldStack.func_77973_b() == newStack.func_77973_b() && !slotChanged && oldStack.func_77973_b() instanceof ItemSageTome && newStack.func_77973_b() instanceof ItemSageTome) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> text, ITooltipFlag advanced) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.element != null && this.element != Element.MAGIC) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER * 100.0f + 0.5f), this.element.getDisplayName()}));
        }
        if (WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) > 0) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((double)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) * Settings.generalSettings.empowerment_upgrade_potency_gain * 100.0 + 0.5), Wizardry.proxy.translate("item.ancientspellcraft:all_other_elements", new Object[0])}));
        }
        text.add(Wizardry.proxy.translate("item.ancientspellcraft:sage_tome.buff", new Style().func_150238_a(TextFormatting.DARK_GRAY), new Object[]{(int)((float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER * 100.0f + 0.5f)}));
        Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
        boolean discovered = !Wizardry.settings.discoveryMode || player.func_184812_l_() || WizardData.get((EntityPlayer)player) == null || WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell);
        text.add(Wizardry.proxy.translate("item.ebwizardry:wand.spell", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{discovered ? spell.getDisplayNameWithFormatting() : "#" + TextFormatting.BLUE + SpellGlyphData.getGlyphName((Spell)spell, (World)player.field_70170_p)}));
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            AncientSpellcraft.proxy.addMultiLineDescription(text, I18n.func_135052_a((String)"tooltip.ancientspellcraft:sage_tome.more_info", (Object[])new Object[0]), new Object[0]);
        } else {
            text.add(I18n.func_135052_a((String)"tooltip.ancientspellcraft:more_info", (Object[])new Object[0]));
        }
        if (advanced.func_194127_a()) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        }
        if (this.tier.level < Tier.MASTER.level) {
            text.add(Wizardry.proxy.translate("item.ebwizardry:wand.progression", new Style().func_150238_a(TextFormatting.GRAY), new Object[]{WandHelper.getProgression((ItemStack)stack), this.tier.level < Tier.MASTER.level ? this.tier.next().getProgression() : 0}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.element == null ? "" : this.element.getFormattingCode()) + super.func_77653_i(stack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return WandHelper.getCurrentSpell((ItemStack)itemstack).action;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        ItemStack stack = player.func_184586_b(hand);
        if (WizardClassWeaponHelper.selectMinionTarget(player, world)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
        if (this.canCast(stack, spell, player, hand, 0, modifiers = this.calculateModifiers(stack, player, spell))) {
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous || chargeup > 0) {
                if (!player.func_184587_cr()) {
                    player.func_184598_c(hand);
                    if (WizardData.get((EntityPlayer)player) != null) {
                        WizardData.get((EntityPlayer)player).itemCastingModifiers = modifiers;
                    }
                    if (chargeup > 0 && world.field_72995_K) {
                        Wizardry.proxy.playChargeupSound((EntityLivingBase)player);
                    }
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (this.cast(stack, spell, player, hand, 0, modifiers)) {
                if (spell == ASSpells.awaken_tome) {
                    stack = player.func_184586_b(hand);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
            SpellModifiers modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int useTick = stack.func_77988_m() - count;
            int chargeup = (int)((float)spell.getChargeup() * modifiers.get("chargeup"));
            if (spell.isContinuous) {
                if (useTick >= chargeup) {
                    int castingTick = useTick - chargeup;
                    if (castingTick == 0 || this.canCast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers)) {
                        this.cast(stack, spell, player, player.func_184600_cs(), castingTick, modifiers);
                    } else {
                        player.func_184597_cx();
                    }
                }
            } else if (chargeup > 0 && useTick == chargeup) {
                this.cast(stack, spell, player, player.func_184600_cs(), 0, modifiers);
            }
        }
    }

    public Spell getCurrentSpell(ItemStack stack) {
        return WandHelper.getCurrentSpell((ItemStack)stack);
    }

    public Spell getNextSpell(ItemStack stack) {
        return WandHelper.getNextSpell((ItemStack)stack);
    }

    public Spell getPreviousSpell(ItemStack stack) {
        return WandHelper.getPreviousSpell((ItemStack)stack);
    }

    public Spell[] getSpells(ItemStack stack) {
        return WandHelper.getSpells((ItemStack)stack);
    }

    public void selectNextSpell(ItemStack stack) {
        WandHelper.selectNextSpell((ItemStack)stack);
    }

    public void selectPreviousSpell(ItemStack stack) {
        WandHelper.selectPreviousSpell((ItemStack)stack);
    }

    public boolean selectSpell(ItemStack stack, int index) {
        return WandHelper.selectSpell((ItemStack)stack, (int)index);
    }

    public int getCurrentCooldown(ItemStack stack) {
        return WandHelper.getCurrentCooldown((ItemStack)stack);
    }

    public int getCurrentMaxCooldown(ItemStack stack) {
        return WandHelper.getCurrentMaxCooldown((ItemStack)stack);
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (castingTick == 0 ? MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(AncientSpellcraft.SAGE_ITEM, spell, (EntityLivingBase)caster, modifiers)) : MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(AncientSpellcraft.SAGE_ITEM, spell, (EntityLivingBase)caster, modifiers, castingTick))) {
            return false;
        }
        int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
        if (spell.isContinuous) {
            cost = WizardClassWeaponHelper.getDistributedCost(cost, castingTick);
        }
        return cost <= this.getMana(stack) && spell.getTier().level <= this.tier.level && (WandHelper.getCurrentCooldown((ItemStack)stack) == 0 || caster.func_184812_l_());
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        EnumHand otherHand = hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(AncientSpellcraft.SAGE_ITEM, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                int cost = (int)((float)spell.getCost() * modifiers.get("cost") + 0.1f);
                if (spell.isContinuous) {
                    cost = WizardClassWeaponHelper.getDistributedCost(cost, castingTick);
                }
                if (cost > 0) {
                    if (caster.func_184586_b(otherHand).func_77973_b() instanceof IManaStoringItem) {
                        int mana = ((IManaStoringItem)caster.func_184586_b(otherHand).func_77973_b()).getMana(caster.func_184586_b(otherHand));
                        if (mana >= cost) {
                            this.consumeMana(stack, otherHand, (EntityLivingBase)caster, cost);
                        }
                    } else {
                        this.consumeMana(stack, cost, (EntityLivingBase)caster);
                    }
                }
            }
            caster.func_184598_c(hand);
            if (!spell.isContinuous && !caster.func_184812_l_()) {
                WandHelper.setCurrentCooldown((ItemStack)stack, (int)((int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
            }
            if (this.tier.level < Tier.MASTER.level && castingTick % 20 == 0) {
                int progression = (int)((float)spell.getCost() * modifiers.get("progression"));
                WandHelper.addProgression((ItemStack)stack, (int)progression);
                if (!Wizardry.settings.legacyWandLevelling) {
                    Tier nextTier = this.tier.next();
                    int excess = WandHelper.getProgression((ItemStack)stack) - nextTier.getProgression();
                    if (excess >= 0 && excess < progression) {
                        caster.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                        WizardryAdvancementTriggers.wand_levelup.triggerFor(caster);
                        if (!world.field_72995_K) {
                            caster.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{this.func_77653_i(stack), nextTier.getNameForTranslationFormatted()}));
                        }
                    }
                }
                WizardData.get((EntityPlayer)caster).trackRecentSpell(spell);
            }
            WizardClassWeaponHelper.addChargeProgress(stack, Settings.generalSettings.spellblade_charge_gain_per_spellcast);
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            Spell spell = WandHelper.getCurrentSpell((ItemStack)stack);
            SpellModifiers modifiers = WizardData.get((EntityPlayer)player) != null ? WizardData.get((EntityPlayer)player).itemCastingModifiers : this.calculateModifiers(stack, (EntityPlayer)user, spell);
            int castingTick = stack.func_77988_m() - timeLeft;
            int cost = WizardClassWeaponHelper.getDistributedCost((int)((float)spell.getCost() * modifiers.get("cost") + 0.1f), castingTick);
            if (spell.isContinuous && spell.getTier().level <= this.tier.level && cost <= this.getMana(stack)) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(AncientSpellcraft.SAGE_ITEM, spell, (EntityLivingBase)player, modifiers, castingTick));
                spell.finishCasting(world, (EntityLivingBase)player, Double.NaN, Double.NaN, Double.NaN, null, castingTick, modifiers);
                if (!player.func_184812_l_()) {
                    WandHelper.setCurrentCooldown((ItemStack)stack, (int)((int)((float)spell.getCooldown() * modifiers.get(WizardryItems.cooldown_upgrade))));
                }
            }
        }
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 5 + WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.attunement_upgrade);
    }

    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack wand, ItemStack upgrade) {
        if (WandHelper.isWandUpgrade((Item)upgrade.func_77973_b())) {
            Item specialUpgrade = upgrade.func_77973_b();
            int maxUpgrades = this.tier.upgradeLimit - 2;
            if (WandHelper.getTotalUpgrades((ItemStack)wand) < maxUpgrades && WandHelper.getUpgradeLevel((ItemStack)wand, (Item)specialUpgrade) < 3) {
                int prevMana = this.getMana(wand);
                WandHelper.applyUpgrade((ItemStack)wand, (Item)specialUpgrade);
                if (specialUpgrade == WizardryItems.storage_upgrade) {
                    this.setMana(wand, prevMana);
                } else if (specialUpgrade == WizardryItems.attunement_upgrade) {
                    int newSlotCount = 5 + WandHelper.getUpgradeLevel((ItemStack)wand, (Item)WizardryItems.attunement_upgrade);
                    Spell[] spells = WandHelper.getSpells((ItemStack)wand);
                    Spell[] newSpells = new Spell[newSlotCount];
                    for (int i = 0; i < newSpells.length; ++i) {
                        newSpells[i] = i < spells.length && spells[i] != null ? spells[i] : Spells.none;
                    }
                    WandHelper.setSpells((ItemStack)wand, (Spell[])newSpells);
                    int[] cooldowns = WandHelper.getCooldowns((ItemStack)wand);
                    int[] newCooldowns = new int[newSlotCount];
                    if (cooldowns.length > 0) {
                        System.arraycopy(cooldowns, 0, newCooldowns, 0, cooldowns.length);
                    }
                    WandHelper.setCooldowns((ItemStack)wand, (int[])newCooldowns);
                }
                upgrade.func_190918_g(1);
                if (player != null) {
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                    if (WandHelper.getTotalUpgrades((ItemStack)wand) == Tier.MASTER.upgradeLimit) {
                        WizardryAdvancementTriggers.max_out_wand.triggerFor(player);
                    }
                }
            }
        }
        return wand;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        Spell[] spells;
        boolean changed = false;
        if (upgrade.func_75216_d()) {
            ItemStack original = centre.func_75211_c().func_77946_l();
            centre.func_75215_d(this.applyUpgrade(player, centre.func_75211_c(), upgrade.func_75211_c()));
            boolean bl = changed = !ItemStack.func_77989_b((ItemStack)centre.func_75211_c(), (ItemStack)original);
        }
        if ((spells = WandHelper.getSpells((ItemStack)centre.func_75211_c())).length <= 0) {
            spells = new Spell[5];
        }
        HashMap<Integer, NBTTagCompound> theorySpellData = new HashMap<Integer, NBTTagCompound>();
        for (int i = 0; i < spells.length; ++i) {
            if (spellBooks[i].func_75211_c() == ItemStack.field_190927_a) continue;
            Spell spell = Spell.byMetadata((int)spellBooks[i].func_75211_c().func_77952_i());
            if (spell.getTier().level > this.tier.level || !(spell instanceof PerfectTheorySpell) && spells[i] == spell || !spell.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.WANDS})) continue;
            spells[i] = spell;
            changed = true;
            if (!(spell instanceof PerfectTheorySpell)) continue;
            theorySpellData.put(i, spellBooks[i].func_75211_c().func_77978_p());
        }
        WandHelper.setSpells((ItemStack)centre.func_75211_c(), (Spell[])spells);
        if (!theorySpellData.isEmpty()) {
            NBTTagCompound tomeTheoryData = new NBTTagCompound();
            if (centre.func_75211_c().func_77942_o() && centre.func_75211_c().func_77978_p().func_74764_b("perfectTheoryData")) {
                NBTTagCompound theorySpells = centre.func_75211_c().func_77978_p().func_74775_l("perfectTheoryData");
                for (String key : theorySpells.func_150296_c()) {
                    theorySpellData.put(Integer.parseInt(key), theorySpells.func_74775_l(key));
                }
            }
            for (Map.Entry entry : theorySpellData.entrySet()) {
                if (entry.getValue() == null) continue;
                tomeTheoryData.func_74782_a(((Integer)entry.getKey()).toString(), (NBTBase)entry.getValue());
            }
            centre.func_75211_c().func_77978_p().func_74782_a("perfectTheoryData", (NBTBase)tomeTheoryData);
        }
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public boolean showManaInWorkbench(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public void consumeMana(ItemStack stack, int mana, @Nullable EntityLivingBase wielder) {
        super.consumeMana(stack, mana, wielder);
    }

    public void rechargeMana(ItemStack stack, int mana) {
        super.rechargeMana(stack, mana);
    }

    public boolean isManaFull(ItemStack stack) {
        return super.isManaFull(stack);
    }

    public boolean isManaEmpty(ItemStack stack) {
        return super.isManaEmpty(stack);
    }

    public float getFullness(ItemStack stack) {
        return super.getFullness(stack);
    }

    public SpellModifiers calculateModifiers(ItemStack stack, EntityPlayer player, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * Constants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        float progressionModifier = 1.0f - (float)WizardData.get((EntityPlayer)player).countRecentCasts(spell) / 5.0f * 0.75f;
        if (this.element == spell.getElement()) {
            modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER, true);
            progressionModifier *= 1.2f;
        }
        if (spell instanceof IClassSpell && ((IClassSpell)spell).getArmourClass() == ItemWizardArmour.ArmourClass.SAGE) {
            modifiers.set("potency", 1.0f + (float)(this.tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER, true);
            progressionModifier *= 1.2f;
        } else if (this.element != spell.getElement() && WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) > 0) {
            modifiers.set("potency", 1.0f + (float)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)ASItems.empowerment_upgrade) * (float)Settings.generalSettings.empowerment_upgrade_potency_gain, true);
        }
        if (WizardData.get((EntityPlayer)player) != null) {
            if (!WizardData.get((EntityPlayer)player).hasSpellBeenDiscovered(spell)) {
                progressionModifier *= 5.0f;
            }
            if (!WizardData.get((EntityPlayer)player).hasReachedTier(this.tier.next())) {
                progressionModifier *= 1.5f;
            }
        }
        modifiers.set("progression", progressionModifier, false);
        return modifiers;
    }
}

