/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpecterLightTorch
extends ItemASArtefact
implements ITickableArtefact {
    private static final int RADIUS = 10;
    private static final int GLOW_DURATION = 100;

    public ItemSpecterLightTorch() {
        super(EnumRarity.UNCOMMON, ItemArtefact.Type.CHARM);
    }

    public ItemSpecterLightTorch(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70173_aa % 20 != 0) {
            return;
        }
        World world = player.field_70170_p;
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        List entities = world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(x - 10.0, y - 10.0, z - 10.0, x + 10.0, y + 10.0, z + 10.0), e -> e != player && e.func_70089_S() && e.func_82150_aj());
        for (Object entity : entities) {
            for (PotionEffect effect : entity.func_70651_bq()) {
                Potion potion = effect.func_188419_a();
                if (potion != MobEffects.field_76441_p && (WizardryPotions.mirage == null || potion != WizardryPotions.mirage) && (WizardryPotions.muffle == null || potion != WizardryPotions.muffle)) continue;
                entity.func_184589_d(potion);
            }
        }
        List undead = world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(x - 10.0, y - 10.0, z - 10.0, x + 10.0, y + 10.0, z + 10.0), e -> e != player && ASUtils.isEntityConsideredUndead((Entity)e));
        for (EntityLivingBase entity : undead) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 100, 0));
        }
        BlockPos center = new BlockPos(x, y, z);
        Iterable positions = BlockPos.func_177980_a((BlockPos)center.func_177982_a(-10, -10, -10), (BlockPos)center.func_177982_a(10, 10, 10));
        for (BlockPos pos : positions) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TileEntityMobSpawner) || !world.field_72995_K) continue;
            double cx = (double)pos.func_177958_n() + 0.5;
            double cy = (double)pos.func_177956_o() + 1.0;
            double cz = (double)pos.func_177952_p() + 0.5;
            int count = 10;
            double radius = 0.7;
            for (int i = 0; i < count; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)count;
                double px = cx + radius * Math.cos(angle);
                double pz = cz + radius * Math.sin(angle);
                EnumParticleTypes type = EnumParticleTypes.SPELL_MOB;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(px, cy, pz).clr(180, 255, 255).scale(0.3f).time(20).spawn(world);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            BlockPos center = player.func_180425_c();
            int radius = 10;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos below;
                        BlockPos pos = center.func_177982_a(dx, dy, dz);
                        if (!world.func_175623_d(pos) || !world.func_180495_p(below = pos.func_177977_b()).func_185896_q() || world.func_175642_b(EnumSkyBlock.BLOCK, pos) > 7) continue;
                        for (int i = 0; i < 3; ++i) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos((double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() * 0.2, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() * 0.2).scale(0.3f + world.field_73012_v.nextFloat() * 0.2f).clr(180, 255, 255).spawn(world);
                        }
                    }
                }
            }
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.ancientspellcraft:charm_specterlight_torch.desc", (Object[])new Object[0]));
    }
}

