/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.SpellTeleporter;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeleportationStone
extends ItemASArtefact
implements IManaStoringItem,
IWorkbenchItem {
    private static final String NBT_BOUND_LOCATION = "boundLocation";
    private static final String NBT_IS_BOUND = "isBound";
    private static final int MANA_CAPACITY = 500;
    private static final int TELEPORTATION_COST = 250;
    private static final int BINDING_TIME_TICKS = 60;
    private static final int TELEPORTATION_TIME_TICKS = 80;

    public ItemTeleportationStone(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77656_e(500);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!Settings.isArtefactEnabled((Item)this)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af()) {
            return this.handleBindingMode(world, player, stack, hand);
        }
        return this.handleTeleportationMode(world, player, stack, hand);
    }

    private ActionResult<ItemStack> handleBindingMode(World world, EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (this.isBound(stack)) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.already_bound", true, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.binding_started", true, new Object[0]);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private ActionResult<ItemStack> handleTeleportationMode(World world, EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (!this.isBound(stack)) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.not_bound", true, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (this.getMana(stack) < 250) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.insufficient_mana", true, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.teleportation_started", true, new Object[0]);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        Object player = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("temp_sneaking")) {
            return stack.func_77978_p().func_74767_n("temp_sneaking") ? 60 : 80;
        }
        return 80;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return SpellActions.SUMMON;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (world.field_72995_K && entity instanceof EntityPlayer && (player = (EntityPlayer)entity).func_184607_cu() == stack && player.func_184605_cv() > 0) {
            int[] colors = new int[]{26367, 52479, 39423, 65535, 0x3366FF};
            int dustColor = colors[world.field_73012_v.nextInt(colors.length)];
            int flashColor = colors[world.field_73012_v.nextInt(colors.length)];
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).clr(dustColor).vel(0.0, (double)0.03f, 0.0).spin((double)0.8f, (double)0.03f).time(60).entity(entity).pos(0.0, (double)0.1f, 0.0).scale(1.2f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).clr(dustColor).vel(0.0, (double)0.03f, 0.0).spin((double)0.8f, (double)0.04f).time(60).entity(entity).pos(0.0, (double)0.1f, 0.0).scale(1.2f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).face(EnumFacing.DOWN).clr(flashColor).pos(0.0, (double)0.1f, 0.0).time(20).entity(entity).scale(1.2f).spawn(world);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean wasBinding = player.func_70093_af();
        if (wasBinding) {
            this.completeBinding(world, player, stack);
        } else {
            this.completeTeleportation(world, player, stack);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.charging_cancelled", true, new Object[0]);
        }
    }

    private void completeBinding(World world, EntityPlayer player, ItemStack stack) {
        if (!player.func_70093_af()) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.binding_cancelled", true, new Object[0]);
            return;
        }
        Location boundLocation = new Location(player.func_180425_c(), player.field_71093_bK);
        this.setBoundLocation(stack, boundLocation);
        this.setBound(stack, true);
        player.func_184811_cZ().func_185145_a((Item)this, 60);
        ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.bound", true, new Object[0]);
        if (world.field_72995_K) {
            this.spawnBindingParticles(world, player.func_180425_c());
        }
    }

    private void completeTeleportation(World world, EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af()) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.teleportation_cancelled", true, new Object[0]);
            return;
        }
        if (this.getMana(stack) < 250) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.insufficient_mana", true, new Object[0]);
            return;
        }
        Location boundLocation = this.getBoundLocation(stack);
        if (boundLocation == null) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.invalid_location", true, new Object[0]);
            return;
        }
        if (boundLocation.dimension != player.field_71093_bK && !ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_rift_bottle)) {
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_teleportation_stone.interdimensional_not_allowed", false, new Object[0]);
            return;
        }
        this.consumeMana(stack, 250, (EntityLivingBase)player);
        SpellTeleporter.teleportEntity(boundLocation.dimension, boundLocation.pos.func_177958_n(), boundLocation.pos.func_177956_o(), boundLocation.pos.func_177952_p(), true, player);
        player.func_184811_cZ().func_185145_a((Item)this, 40);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBindingParticles(World world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)(pos.func_177956_o() + 1) + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).clr(65535).vel(0.0, (double)0.1f, 0.0).time(40).spawn(world);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnChargingParticles(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(5) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)(pos.func_177956_o() + 1) + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).clr(65535).vel(0.0, (double)0.1f, 0.0).time(30).spawn(world);
        }
    }

    private boolean isBound(ItemStack stack) {
        return this.getNBTBoolean(stack, NBT_IS_BOUND, false);
    }

    private void setBound(ItemStack stack, boolean bound) {
        this.setNBTBoolean(stack, NBT_IS_BOUND, bound);
    }

    private Location getBoundLocation(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound locationTag = stack.func_77978_p().func_74775_l(NBT_BOUND_LOCATION);
        if (locationTag.func_82582_d()) {
            return null;
        }
        return Location.fromNBT((NBTTagCompound)locationTag);
    }

    private void setBoundLocation(ItemStack stack, Location location) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a(NBT_BOUND_LOCATION, (NBTBase)location.toNBT());
    }

    private boolean getNBTBoolean(ItemStack stack, String key, boolean defaultValue) {
        if (!stack.func_77942_o()) {
            return defaultValue;
        }
        return stack.func_77978_p().func_74767_n(key);
    }

    private void setNBTBoolean(ItemStack stack, String key, boolean value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a(key, value);
    }

    private long getNBTLong(ItemStack stack, String key, long defaultValue) {
        if (!stack.func_77942_o()) {
            return defaultValue;
        }
        return stack.func_77978_p().func_74763_f(key);
    }

    private void setNBTLong(ItemStack stack, String key, long value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a(key, value);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return 500;
    }

    public boolean showManaInWorkbench(EntityPlayer player, ItemStack stack) {
        return true;
    }

    public void consumeMana(ItemStack stack, int mana, @Nullable EntityLivingBase wielder) {
        super.consumeMana(stack, mana, wielder);
    }

    public void rechargeMana(ItemStack stack, int mana) {
        super.rechargeMana(stack, mana);
    }

    public boolean isManaFull(ItemStack stack) {
        return super.isManaFull(stack);
    }

    public boolean isManaEmpty(ItemStack stack) {
        return super.isManaEmpty(stack);
    }

    public float getFullness(ItemStack stack) {
        return super.getFullness(stack);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            int manaPerItem = 100;
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.crystal_shard) {
                manaPerItem = 10;
            }
            if (crystals.func_75211_c().func_77973_b() == WizardryItems.grand_crystal) {
                manaPerItem = 400;
            }
            if (crystals.func_75211_c().func_190916_E() * manaPerItem < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * manaPerItem);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / (double)manaPerItem));
            }
            changed = true;
        }
        return changed;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Wizardry.proxy.translate("item.ebwizardry:wand.mana", new Style().func_150238_a(TextFormatting.BLUE), new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        if (this.isBound(stack)) {
            Location boundLocation = this.getBoundLocation(stack);
            if (boundLocation != null) {
                String dimName = "Unknown";
                DimensionType dimType = DimensionType.func_186069_a((int)boundLocation.dimension);
                if (dimType != null && !(dimName = I18n.func_135052_a((String)dimType.func_186065_b(), (Object[])new Object[0])).isEmpty()) {
                    dimName = dimName.substring(0, 1).toUpperCase() + dimName.substring(1);
                    dimName = dimName.replace("_", " ");
                }
                tooltip.add(TextFormatting.GREEN + "Bound to: " + boundLocation.pos.func_177958_n() + ", " + boundLocation.pos.func_177956_o() + ", " + boundLocation.pos.func_177952_p() + " (" + dimName + ")");
            }
            tooltip.add(TextFormatting.YELLOW + "Right-click to teleport (Cost: " + 250 + ")");
        } else {
            tooltip.add(TextFormatting.YELLOW + "Sneak + Right-click to bind to current location (3s charge)");
        }
        if (!Settings.isArtefactEnabled((Item)this)) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return DrawingUtils.mix((int)16747518, (int)9318116, (float)((float)this.getDurabilityForDisplay(stack)));
    }
}

