/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemDailyArtefact;
import com.windanesz.ancientspellcraft.item.ItemRareScroll;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import electroblob.wizardry.block.BlockCrystal;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArmourUpgrade;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber
public class ItemTransmutationScroll
extends ItemRareScroll {
    public void onUsingTick(ItemStack stack, EntityLivingBase entityLiving, int count) {
        if (!entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        World world = entityLiving.field_70170_p;
        Random rand = entityLiving.field_70170_p.field_73012_v;
        double posX = entityLiving.field_70165_t;
        double posY = entityLiving.field_70163_u;
        double posZ = entityLiving.field_70161_v;
        if (world.func_82737_E() % 3L == 0L) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(245, 188, 66).time(20 + rand.nextInt(50)).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(0.3f, 0.3f, 0.3f).time(20 + rand.nextInt(50)).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(0.4f, 0.4f, 0.4f).time(20 + rand.nextInt(50)).spawn(world);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(entityLiving.field_70165_t, entityLiving.field_70163_u + 0.101, entityLiving.field_70161_v).face(EnumFacing.UP).clr(DrawingUtils.mix((int)16104514, (int)7039593, (float)0.5f)).collide(false).scale(2.3f).time(10).spawn(world);
    }

    public ItemStack func_77654_b(ItemStack scrollStack, World world, EntityLivingBase entityLiving) {
        return this.onTransmutationFinish(scrollStack, world, entityLiving);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack onTransmutationFinish(ItemStack scrollStack, World world, EntityLivingBase entityLiving) {
        block31: {
            EntityPlayer player;
            block33: {
                WizardData data;
                ItemStack transmutedItem;
                boolean transmuted;
                ItemStack offhandStack;
                block34: {
                    ItemArtefact charm;
                    boolean isArtefactActive;
                    LootContext context;
                    LootTable table;
                    block35: {
                        block32: {
                            if (!(entityLiving instanceof EntityPlayer)) break block31;
                            player = (EntityPlayer)entityLiving;
                            offhandStack = player.func_184592_cb();
                            if (offhandStack.func_190926_b() && !world.field_72995_K) {
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation.no_items_to_transmute", new Object[0]), false);
                                return scrollStack;
                            }
                            if (!Transmutation.canBeTransmuted(offhandStack)) break block32;
                            if (world.field_72995_K) break block33;
                            transmuted = false;
                            transmutedItem = ItemStack.field_190927_a;
                            if (offhandStack.func_77973_b() instanceof ItemArmourUpgrade) {
                                if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_runic_hammer)) {
                                    if (offhandStack.func_77973_b() == WizardryItems.crystal_silver_plating) {
                                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                                        return scrollStack;
                                    }
                                    transmuted = true;
                                    transmutedItem = new ItemStack(WizardryItems.crystal_silver_plating);
                                } else if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_fabrikator_toolkit)) {
                                    if (offhandStack.func_77973_b() == WizardryItems.resplendent_thread) {
                                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                                        return scrollStack;
                                    }
                                    transmuted = true;
                                    transmutedItem = new ItemStack(WizardryItems.resplendent_thread);
                                } else if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_scissors)) {
                                    if (offhandStack.func_77973_b() == WizardryItems.ethereal_crystalweave) {
                                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation_scroll.results_in_same_item", new Object[0]), false);
                                        return scrollStack;
                                    }
                                    transmuted = true;
                                    transmutedItem = new ItemStack(WizardryItems.ethereal_crystalweave);
                                }
                            }
                            if (Transmutation.getMatchingTransmutation(offhandStack) != Transmutation.ARTEFACT) break block34;
                            String rarity = offhandStack.func_77973_b().getForgeRarity(offhandStack).getName().toLowerCase();
                            table = world.func_184146_ak().func_186521_a(new ResourceLocation("ebwizardry", "subsets/" + rarity + "_artefacts"));
                            context = new LootContext.Builder((WorldServer)world).func_186470_a(player).func_186469_a(0.0f).func_186471_a();
                            isArtefactActive = false;
                            charm = null;
                            if (!rarity.equals(EnumRarity.UNCOMMON.field_77934_f.toLowerCase()) && !rarity.equals(EnumRarity.RARE.field_77934_f.toLowerCase()) && !rarity.equals(EnumRarity.EPIC.field_77934_f.toLowerCase())) break block34;
                            List charmSlot = ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[]{ItemArtefact.Type.CHARM});
                            if (charmSlot.isEmpty() || (charm = (ItemArtefact)charmSlot.get(0)) != ASItems.charm_scissors && charm != ASItems.charm_fabrikator_toolkit && charm != ASItems.charm_runic_hammer) break block35;
                            isArtefactActive = true;
                            break block35;
                        }
                        if (!world.field_72995_K) {
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:transmutation.invalid_item", new Object[0]), false);
                        }
                        break block33;
                    }
                    for (int i2 = 0; i2 < 60; ++i2) {
                        ItemStack artefactCandidate;
                        Item item;
                        List stacks = table.func_186462_a(world.field_73012_v, context);
                        if (stacks.isEmpty() || (item = (artefactCandidate = (ItemStack)stacks.get(0)).func_77973_b()) == offhandStack.func_77973_b()) continue;
                        if (isArtefactActive) {
                            if (charm == ASItems.charm_scissors) {
                                if ((!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.AMULET) && (!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.BELT)) continue;
                                transmuted = true;
                                transmutedItem = artefactCandidate;
                                break;
                            }
                            if (charm == ASItems.charm_fabrikator_toolkit) {
                                if (!(item instanceof ItemArtefact && ((ItemArtefact)item).getType() == ItemArtefact.Type.CHARM || item instanceof ItemArtefact && ((ItemArtefact)item).getType() == ItemArtefact.Type.HEAD) && !(item instanceof ItemDailyArtefact)) continue;
                                transmuted = true;
                                transmutedItem = artefactCandidate;
                                break;
                            }
                            if (!(item instanceof ItemArtefact) || ((ItemArtefact)item).getType() != ItemArtefact.Type.RING) continue;
                            transmuted = true;
                            transmutedItem = artefactCandidate;
                            break;
                        }
                        transmuted = true;
                        transmutedItem = artefactCandidate;
                        break;
                    }
                }
                if (!transmuted && offhandStack.func_77973_b() instanceof ItemSpellBook && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.head_circlet_of_the_unknown) && (data = WizardData.get((EntityPlayer)player)) != null) {
                    Spell oldSpell = Spell.byMetadata((int)offhandStack.func_77952_i());
                    Element elementConstraint = null;
                    if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.amulet_arcane_catalyst)) {
                        elementConstraint = oldSpell.getElement();
                    }
                    List unknownSpells = Spell.getSpells((Predicate)new Spell.TierElementFilter(oldSpell.getTier(), elementConstraint, new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
                    unknownSpells.removeIf(new Spell.TierElementFilter(oldSpell.getTier(), elementConstraint, new SpellProperties.Context[]{SpellProperties.Context.LOOTING}).negate());
                    unknownSpells.removeIf(arg_0 -> ((WizardData)data).hasSpellBeenDiscovered(arg_0));
                    if (unknownSpells.isEmpty() && elementConstraint == null) {
                        unknownSpells = Spell.getSpells(s -> !data.hasSpellBeenDiscovered(s) && s.isEnabled(new SpellProperties.Context[0]));
                        unknownSpells.removeIf(new Spell.TierElementFilter(null, null, new SpellProperties.Context[]{SpellProperties.Context.LOOTING}).negate());
                    }
                    if (!unknownSpells.isEmpty()) {
                        Spell newSpell = (Spell)unknownSpells.get(world.field_73012_v.nextInt(unknownSpells.size()));
                        Item book = offhandStack.func_77973_b();
                        List bookTypeList = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemSpellBook).collect(Collectors.toList());
                        for (Item currentBook : bookTypeList) {
                            if (!newSpell.applicableForItem(currentBook)) continue;
                            book = currentBook;
                            break;
                        }
                        transmutedItem = new ItemStack(book, 1, newSpell.metadata());
                        transmuted = true;
                    }
                }
                if (!transmuted) {
                    Item relatedArtefact = Transmutation.getRelatedArtefact(offhandStack);
                    boolean applyArtefactEffect = false;
                    if (relatedArtefact != Items.field_190931_a) {
                        if (relatedArtefact instanceof ItemArtefact) {
                            applyArtefactEffect = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)relatedArtefact);
                        } else if (relatedArtefact instanceof ItemArtefact) {
                            applyArtefactEffect = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)relatedArtefact);
                        }
                    }
                    transmutedItem = Transmutation.transmuteStack(offhandStack, applyArtefactEffect);
                }
                if (transmutedItem != ItemStack.field_190927_a) {
                    if (transmutedItem.func_77969_a(offhandStack)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Transmutation failed", new Object[0]));
                        player.func_184811_cZ().func_185145_a((Item)this, 20);
                        return scrollStack;
                    }
                    if (!player.func_184812_l_()) {
                        ItemTransmutationScroll.consumeScroll(player, scrollStack);
                    }
                    offhandStack.func_190918_g(1);
                    if (player.func_184592_cb().func_190926_b()) {
                        player.func_184611_a(EnumHand.OFF_HAND, transmutedItem);
                    } else if (!player.func_191521_c(transmutedItem)) {
                        player.func_71019_a(transmutedItem, true);
                    }
                }
            }
            player.func_184811_cZ().func_185145_a((Item)this, 60);
        }
        world.func_184134_a(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, ASSounds.TRANSMUTATION, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
        return scrollStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return SpellActions.IMBUE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack scrollStack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)entityLiving).func_146105_b((ITextComponent)new TextComponentTranslation("item." + this.getRegistryName() + ".interrupted", new Object[0]), true);
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, 40);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity() instanceof EntityPlayer && event.getHand() == EnumHand.OFF_HAND && ((EntityPlayer)event.getEntity()).func_184614_ca().func_77973_b() == ASItems.transmutation_scroll) {
            event.setCanceled(true);
        }
    }

    public static enum Transmutation {
        SPELLBOOK{

            @Override
            protected ItemStack transmute(ItemStack bookStack, boolean applyArtefactEffects) {
                if (!this.matches(bookStack)) {
                    return bookStack;
                }
                if (bookStack.func_77973_b() == ASItems.ancient_spell_book) {
                    return bookStack;
                }
                Element element = applyArtefactEffects ? Spell.byMetadata((int)bookStack.func_77952_i()).getElement() : null;
                Item book = bookStack.func_77973_b();
                List bookTypeList = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemSpellBook).collect(Collectors.toList());
                Spell newSpell = Transmutation.getRandomSpell(bookStack, element, SpellProperties.Context.BOOK);
                for (int i2 = 0; i2 < bookTypeList.size(); ++i2) {
                    Item currentBook = (Item)bookTypeList.get(i2);
                    if (!newSpell.applicableForItem(currentBook)) continue;
                    book = currentBook;
                }
                return new ItemStack(book, 1, newSpell.metadata());
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return ASItems.amulet_arcane_catalyst;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemSpellBook;
            }
        }
        ,
        SCROLL{

            @Override
            protected ItemStack transmute(ItemStack scrollStack, boolean applyArtefactEffects) {
                if (!this.matches(scrollStack)) {
                    return scrollStack;
                }
                Element element = applyArtefactEffects ? Spell.byMetadata((int)scrollStack.func_77952_i()).getElement() : null;
                Spell oldSpell = Spell.byMetadata((int)scrollStack.func_77960_j());
                if (oldSpell.getRegistryName().func_110624_b().equals("ancientspellcraft") && oldSpell.getElement() == Element.MAGIC) {
                    return scrollStack;
                }
                return new ItemStack(scrollStack.func_77973_b(), 1, Transmutation.getRandomSpell(scrollStack, element, SpellProperties.Context.SCROLL).metadata());
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return ASItems.amulet_arcane_catalyst;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemScroll;
            }
        }
        ,
        WAND{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                Item newWand = ItemWand.getWand((Tier)((ItemWand)oldItem.func_77973_b()).tier, (Element)Transmutation.getRandomOtherElement(((ItemWand)oldItem.func_77973_b()).element));
                return new ItemStack(newWand);
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemWand;
            }
        }
        ,
        ARTEFACT{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                return ItemStack.field_190927_a;
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemArtefact || stack.func_77973_b() instanceof ItemArtefact || stack.func_77973_b() instanceof ItemDailyArtefact;
            }
        }
        ,
        ARMOUR{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                ItemWizardArmour oldArmour = (ItemWizardArmour)oldItem.func_77973_b();
                return new ItemStack(ItemWizardArmour.getArmour((Element)Transmutation.getRandomOtherElement(oldArmour.element), (ItemWizardArmour.ArmourClass)oldArmour.armourClass, (EntityEquipmentSlot)oldArmour.field_77881_a));
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemWizardArmour;
            }
        }
        ,
        ARMOR_UPGRADE_ITEM{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                if (!applyArtefactEffects) {
                    ArrayList<Item> upgrades = new ArrayList<Item>(Arrays.asList(WizardryItems.crystal_silver_plating, WizardryItems.resplendent_thread, WizardryItems.ethereal_crystalweave));
                    upgrades.remove(oldItem.func_77973_b());
                    return new ItemStack((Item)upgrades.get(field_77697_d.nextInt(upgrades.size())));
                }
                return ItemStack.field_190927_a;
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemArmourUpgrade;
            }
        }
        ,
        WAND_UPGRADE{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                ArrayList<Item> upgrades = new ArrayList<Item>(Arrays.asList(WizardryItems.attunement_upgrade, WizardryItems.blast_upgrade, WizardryItems.condenser_upgrade, WizardryItems.cooldown_upgrade, WizardryItems.duration_upgrade, WizardryItems.melee_upgrade, WizardryItems.range_upgrade, WizardryItems.siphon_upgrade, WizardryItems.storage_upgrade));
                if (upgrades.remove(oldItem.func_77973_b())) {
                    return new ItemStack((Item)upgrades.get(field_77697_d.nextInt(upgrades.size())));
                }
                return oldItem;
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemWandUpgrade;
            }
        }
        ,
        SPECTRAL_DUST{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                return Transmutation.transmuteStandardItemWithElementMetadata(oldItem);
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return false;
            }
        }
        ,
        CRYSTAL{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                return Transmutation.transmuteStandardItemWithElementMetadata(oldItem);
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return stack.func_77973_b() instanceof ItemCrystal;
            }
        }
        ,
        CRYSTAL_BLOCK{

            @Override
            protected ItemStack transmute(ItemStack oldItem, boolean applyArtefactEffects) {
                if (!this.matches(oldItem)) {
                    return oldItem;
                }
                return Transmutation.transmuteStandardItemWithElementMetadata(oldItem);
            }

            @Override
            protected Item getRelatedArtefact(Item item) {
                return Items.field_190931_a;
            }

            @Override
            boolean matches(ItemStack stack) {
                return Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockCrystal;
            }
        };


        public static ItemStack transmuteStack(ItemStack stack, boolean applyArtefactEffects) {
            for (Transmutation t : Transmutation.values()) {
                if (!t.matches(stack)) continue;
                return t.transmute(stack, applyArtefactEffects);
            }
            return stack;
        }

        public static boolean canBeTransmuted(ItemStack stack) {
            for (Transmutation t : Transmutation.values()) {
                if (!t.matches(stack)) continue;
                return true;
            }
            return false;
        }

        public static Item getRelatedArtefact(ItemStack stack) {
            if (Transmutation.canBeTransmuted(stack)) {
                return Transmutation.getMatchingTransmutation(stack).getRelatedArtefact(stack.func_77973_b());
            }
            return Items.field_190931_a;
        }

        abstract boolean matches(ItemStack var1);

        protected abstract ItemStack transmute(ItemStack var1, boolean var2);

        protected abstract Item getRelatedArtefact(Item var1);

        private static Spell getRandomSpell(ItemStack oldStack, Element element, SpellProperties.Context context) {
            if (!(oldStack.func_77973_b() instanceof ItemSpellBook) && !(oldStack.func_77973_b() instanceof ItemScroll)) {
                return Spells.none;
            }
            Spell oldSpell = Spell.byMetadata((int)oldStack.func_77952_i());
            List spells = Spell.getSpells((Predicate)new Spell.TierElementFilter(oldSpell.getTier(), element, new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
            spells.removeIf(new Spell.TierElementFilter(oldSpell.getTier(), element, new SpellProperties.Context[]{SpellProperties.Context.LOOTING}).negate());
            Spell newSpell = oldSpell;
            if (spells.size() != 0 && !spells.isEmpty()) {
                for (int remainingTries = 30; newSpell == oldSpell || remainingTries == 0; --remainingTries) {
                    newSpell = (Spell)spells.get(field_77697_d.nextInt(spells.size()));
                }
            }
            return newSpell;
        }

        private static ItemStack transmuteStandardItemWithElementMetadata(ItemStack oldStack) {
            Element newElement = Transmutation.getRandomOtherElementFromMeta(oldStack);
            return new ItemStack(oldStack.func_77973_b(), 1, newElement.ordinal());
        }

        private static Element getRandomOtherElementFromMeta(ItemStack oldStack) {
            if (Element.values().length >= oldStack.func_77960_j()) {
                Element oldElement = Element.values()[oldStack.func_77960_j()];
                return Transmutation.getRandomOtherElement(oldElement);
            }
            return Element.MAGIC;
        }

        private static Element getRandomOtherElement(Element excluded) {
            ArrayList<Element> elements = new ArrayList<Element>(Arrays.asList(Element.values()));
            if (excluded != Element.MAGIC) {
                elements.remove(Element.MAGIC);
            }
            elements.remove(excluded);
            return (Element)elements.get(field_77697_d.nextInt(elements.size()));
        }

        public static Transmutation getMatchingTransmutation(ItemStack stack) {
            for (Transmutation t : Transmutation.values()) {
                if (!t.matches(stack)) continue;
                return t;
            }
            return null;
        }
    }
}

