/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.tileentity.TileArcaneWall;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVaultKey
extends ItemASArtefact
implements IManaStoringItem,
IWorkbenchItem {
    public ItemVaultKey(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77656_e(10000);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !this.isManaEmpty(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[]{Settings.generalSettings.orb_artefact_potency_bonus});
        if (!Settings.isArtefactEnabled((Item)this)) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        ItemStack stack = player.func_184586_b(hand);
        Vec3d look = player.func_70040_Z();
        Vec3d origin = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - 0.25, player.field_70161_v);
        if (world.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)player)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        if (this.getMana(stack) < this.getManaCost()) {
            return EnumActionResult.PASS;
        }
        double range = 5.0;
        Vec3d endpoint = origin.func_178787_e(look.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)0.0f, (boolean)false, (boolean)false, (boolean)false, Entity.class, (Predicate)RayTracer.ignoreEntityFilter((Entity)player));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(rayTrace.func_178782_a()).func_177230_c() == ASBlocks.arcane_wall && (tile = world.func_175625_s(rayTrace.func_178782_a())) instanceof TileArcaneWall && ((TileArcaneWall)tile).isGenerated()) {
            ((TileArcaneWall)tile).setBeingDispelled(true);
            if (!player.func_184812_l_()) {
                this.consumeMana(stack, this.getManaCost(), (EntityLivingBase)player);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    private int getManaCost() {
        return Settings.generalSettings.vault_key_usage_mana_cost;
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean showTooltip(ItemStack stack) {
        return false;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        return WandHelper.rechargeManaOnApplyButtonPressed((Slot)centre, (Slot)crystals);
    }
}

