/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemDailyArtefact;
import com.windanesz.ancientspellcraft.util.ASUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemVerdantCrucible
extends ItemDailyArtefact {
    public static final List<IngredientEntry> ingredientEntries = new ArrayList<IngredientEntry>();

    public ItemVerdantCrucible(EnumRarity rarity) {
        super(rarity);
        this.addReadinessPropertyOverride();
    }

    @Override
    public void performAction(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && !ingredientEntries.isEmpty()) {
            IngredientEntry entry = ingredientEntries.get(player.func_70681_au().nextInt(ingredientEntries.size()));
            int count = ASUtils.randIntBetween(entry.min, entry.max);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.itemName));
            if (item != null) {
                ItemStack stack = ItemStack.field_190927_a;
                int retries = 10;
                while (retries-- > 0 && (stack = new ItemStack(item, count, entry.meta)).func_190926_b()) {
                }
                if (!stack.func_190926_b()) {
                    if (entry.nbt != null) {
                        stack.func_77982_d(entry.nbt.func_74737_b());
                    }
                    if (!player.field_71071_by.func_70441_a(stack)) {
                        player.func_71019_a(stack, false);
                    }
                }
            }
        }
    }

    static {
        ingredientEntries.clear();
        String[] configList = Settings.generalSettings.verdant_crucible_ingredients;
        if (configList != null) {
            for (String entry : configList) {
                String[] parts = entry.split("\\|");
                if (parts.length < 5) continue;
                String itemName = parts[0];
                try {
                    int meta = Integer.parseInt(parts[1]);
                    NBTTagCompound nbt = null;
                    if (!parts[2].isEmpty()) {
                        try {
                            nbt = JsonToNBT.func_180713_a((String)parts[2]);
                        }
                        catch (NBTException nBTException) {
                            // empty catch block
                        }
                    }
                    int min = Integer.parseInt(parts[3]);
                    int max = Integer.parseInt(parts[4]);
                    ingredientEntries.add(new IngredientEntry(itemName, meta, nbt, min, max));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static class IngredientEntry {
        public final String itemName;
        public final int meta;
        public final NBTTagCompound nbt;
        public final int min;
        public final int max;

        public IngredientEntry(String itemName, int meta, NBTTagCompound nbt, int min, int max) {
            this.itemName = itemName;
            this.meta = meta;
            this.nbt = nbt;
            this.min = min;
            this.max = max;
        }
    }
}

