/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.potion.Curse;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemVesselOfTheWitheredOath
extends ItemASArtefact
implements IBauble,
ITickableArtefact {
    private static final String NBT_STORED_CURSE = "storedCurse";

    public ItemVesselOfTheWitheredOath(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.CHARM;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean isSelected) {
        if (this.hasStoredCurse(stack)) {
            this.removeStoredCurse(stack);
        }
        super.func_77663_a(stack, world, entity, inventorySlot, isSelected);
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
        }
    }

    public void storeFirstCurse(EntityLivingBase player, ItemStack stack) {
        PotionEffect curseToContain = this.findFirstCurse(player);
        if (curseToContain != null) {
            this.setStoredCurse(stack, curseToContain);
            player.func_184589_d(curseToContain.func_188419_a());
            ASUtils.sendMessage((Entity)player, "item.ancientspellcraft:charm_vessel_of_the_withered_oath.curse_contained", true, new Object[0]);
        }
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer && player.field_70173_aa % 5 == 0 && !player.field_70170_p.field_72995_K) {
            EntityPlayer entityPlayer = (EntityPlayer)player;
            Potion storedCurse = this.getStoredCurse(itemstack);
            if (storedCurse != null) {
                PotionEffect activeCurse = entityPlayer.func_70660_b(storedCurse);
                if (activeCurse != null) {
                    entityPlayer.func_184589_d(storedCurse);
                }
            } else {
                this.storeFirstCurse(player, itemstack);
            }
        }
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase entity) {
        Potion storedCurse;
        if (!entity.field_70170_p.field_72995_K && this.hasStoredCurse(itemstack) && (storedCurse = this.getStoredCurse(itemstack)) != null) {
            entity.func_70690_d(new PotionEffect(storedCurse, Integer.MAX_VALUE));
            this.removeStoredCurse(itemstack);
            ASUtils.sendMessage((Entity)entity, "item.ancientspellcraft:charm_vessel_of_the_withered_oath.curse_restored", true, storedCurse.func_76393_a());
        }
    }

    private PotionEffect findFirstCurse(EntityLivingBase entity) {
        for (PotionEffect effect : entity.func_70651_bq()) {
            if (!(effect.func_188419_a() instanceof Curse)) continue;
            return effect;
        }
        return null;
    }

    public boolean hasStoredCurse(ItemStack itemstack) {
        return itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b(NBT_STORED_CURSE);
    }

    public Potion getStoredCurse(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(NBT_STORED_CURSE)) {
            return null;
        }
        return Potion.func_180142_b((String)nbt.func_74779_i(NBT_STORED_CURSE));
    }

    public void setStoredCurse(ItemStack itemstack, PotionEffect curse) {
        NBTTagCompound nbt = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a(NBT_STORED_CURSE, curse.func_188419_a().getRegistryName().toString());
        itemstack.func_77982_d(nbt);
    }

    public void removeStoredCurse(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
        nbt.func_82580_o(NBT_STORED_CURSE);
        itemstack.func_77982_d(nbt);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Potion storedCurse;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.hasStoredCurse(stack) && (storedCurse = this.getStoredCurse(stack)) != null) {
            tooltip.add(AncientSpellcraft.proxy.translate("item.ancientspellcraft:charm_vessel_of_the_withered_oath.contains", AncientSpellcraft.proxy.translate(storedCurse.func_76393_a(), new Object[0])));
        }
    }
}

