/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;

public class ItemWhisperingVeil
extends ItemASArtefact {
    public static final IStoredVariable<List<UUID>> USED_WIZARDS_TODAY = new IStoredVariable.StoredVariable("whispering_veil_used_wizards", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.ALWAYS);
    public static final IStoredVariable<List<UUID>> USED_VILLAGERS_TODAY = new IStoredVariable.StoredVariable("whispering_veil_used_villagers", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.ALWAYS);
    public static final IStoredVariable<List<UUID>> USED_WIZARDS_PERMANENT = new IStoredVariable.StoredVariable("whispering_veil_used_wizards_permanent", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.ALWAYS);

    public ItemWhisperingVeil(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
    }

    public static boolean hasUsedWizardToday(EntityPlayer player, UUID wizardUUID) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        List usedWizards = (List)data.getVariable(USED_WIZARDS_PERMANENT);
        return usedWizards != null && usedWizards.contains(wizardUUID);
    }

    public static void markWizardAsUsedToday(EntityPlayer player, UUID wizardUUID) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return;
        }
        ArrayList<UUID> usedWizards = (ArrayList<UUID>)data.getVariable(USED_WIZARDS_PERMANENT);
        if (usedWizards == null) {
            usedWizards = new ArrayList<UUID>();
        }
        if (!usedWizards.contains(wizardUUID)) {
            usedWizards.add(wizardUUID);
            data.setVariable(USED_WIZARDS_PERMANENT, usedWizards);
        }
    }

    public static boolean hasUsedVillagerToday(EntityPlayer player, UUID villagerUUID) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        List usedVillagers = (List)data.getVariable(USED_VILLAGERS_TODAY);
        return usedVillagers != null && usedVillagers.contains(villagerUUID);
    }

    public static void markVillagerAsUsedToday(EntityPlayer player, UUID villagerUUID) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return;
        }
        ArrayList<UUID> usedVillagers = (ArrayList<UUID>)data.getVariable(USED_VILLAGERS_TODAY);
        if (usedVillagers == null) {
            usedVillagers = new ArrayList<UUID>();
        }
        if (!usedVillagers.contains(villagerUUID)) {
            usedVillagers.add(villagerUUID);
            data.setVariable(USED_VILLAGERS_TODAY, usedVillagers);
        }
    }

    public static void clearUsedWizardsToday(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(USED_WIZARDS_TODAY, null);
        }
    }

    public static void clearUsedVillagersToday(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(USED_VILLAGERS_TODAY, null);
        }
    }

    static {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{USED_WIZARDS_TODAY, USED_VILLAGERS_TODAY, USED_WIZARDS_PERMANENT});
    }
}

