/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.IWizardClassWeapon;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.RayTracer;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class WizardClassWeaponHelper {
    public static final String ELEMENT_TAG = "element";
    public static final String CHARGE_PROGRESS = "charge_progress";

    private WizardClassWeaponHelper() {
    }

    public static Item getClassItemForTier(Tier tier, ItemWizardArmour.ArmourClass armourClass) {
        return WizardClassWeaponHelper.getClassItemForTier(tier, armourClass, Element.MAGIC);
    }

    public static Item getClassItemForTier(Tier tier, ItemWizardArmour.ArmourClass armourClass, Element element) {
        if (tier == null) {
            throw new NullPointerException("The given tier cannot be null.");
        }
        if (armourClass == null) {
            throw new NullPointerException("The given armourClass cannot be null.");
        }
        switch (armourClass) {
            case WIZARD: {
                return ItemWand.getWand((Tier)tier, (Element)Element.MAGIC);
            }
            case BATTLEMAGE: {
                if (tier == Tier.NOVICE) {
                    return ASItems.battlemage_sword_novice;
                }
                if (tier == Tier.APPRENTICE) {
                    return ASItems.battlemage_sword_apprentice;
                }
                if (tier == Tier.ADVANCED) {
                    return ASItems.battlemage_sword_advanced;
                }
                return ASItems.battlemage_sword_master;
            }
            case SAGE: {
                String registryName = "sage_tome_" + tier.getUnlocalisedName() + "_" + element.func_176610_l().toLowerCase();
                return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ancientspellcraft", registryName));
            }
        }
        String registryName = "warlock_orb_" + tier.getUnlocalisedName() + "_" + element.func_176610_l().toLowerCase();
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ancientspellcraft", registryName));
    }

    public static Element getElement(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ELEMENT_TAG)) {
            return Element.fromName((String)stack.func_77978_p().func_74779_i(ELEMENT_TAG).toLowerCase());
        }
        return Element.MAGIC;
    }

    public static boolean isChargeFull(ItemStack stack) {
        if (stack.func_77973_b() instanceof IWizardClassWeapon && stack.func_77942_o()) {
            return stack.func_77978_p().func_74764_b(CHARGE_PROGRESS) && stack.func_77978_p().func_74762_e(CHARGE_PROGRESS) >= 100;
        }
        return false;
    }

    public static int getChargeProgress(ItemStack stack) {
        if (stack.func_77973_b() instanceof IWizardClassWeapon && stack.func_77942_o()) {
            return stack.func_77978_p().func_74764_b(CHARGE_PROGRESS) ? stack.func_77978_p().func_74762_e(CHARGE_PROGRESS) : 0;
        }
        return 0;
    }

    public static void addChargeProgress(ItemStack stack, int amount) {
        int progress = WizardClassWeaponHelper.getChargeProgress(stack);
        if (stack.func_77973_b() instanceof IWizardClassWeapon) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            compound.func_74768_a(CHARGE_PROGRESS, Math.min(progress + amount, 100));
            stack.func_77982_d(compound);
        }
    }

    public static void resetChargeProgress(ItemStack stack) {
        if (stack.func_77973_b() instanceof IWizardClassWeapon && stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            compound.func_74768_a(CHARGE_PROGRESS, 0);
            stack.func_77982_d(compound);
        }
    }

    static boolean selectMinionTarget(EntityPlayer player, World world) {
        RayTraceResult rayTrace = RayTracer.standardEntityRayTrace((World)world, (Entity)player, (double)16.0, (boolean)false);
        if (rayTrace != null && EntityUtils.isLiving((Entity)rayTrace.field_72308_g)) {
            ISummonedCreature minion;
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (player.func_70093_af() && WizardData.get((EntityPlayer)player) != null && WizardData.get((EntityPlayer)player).selectedMinion != null && (minion = (ISummonedCreature)WizardData.get((EntityPlayer)player).selectedMinion.get()) instanceof EntityLiving && minion != entity) {
                ((EntityLiving)minion).func_70624_b(entity);
                WizardData.get((EntityPlayer)player).selectedMinion = null;
                return true;
            }
        }
        return false;
    }

    public static Optional<ItemStack> getManaSourceFromOtherHand(ItemStack weapon, EntityLivingBase entity) {
        if (entity != null) {
            ItemStack heldItemMainhand;
            if (!entity.func_184614_ca().func_190926_b() && entity.func_184614_ca().func_77973_b() == weapon.func_77973_b()) {
                ItemStack heldItemOffhand;
                if (!entity.func_184592_cb().func_190926_b() && entity.func_184592_cb().func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)(heldItemOffhand = entity.func_184592_cb()).func_77973_b()).isManaEmpty(heldItemOffhand)) {
                    return Optional.of(heldItemOffhand);
                }
            } else if (!entity.func_184592_cb().func_190926_b() && entity.func_184592_cb().func_77973_b() == weapon.func_77973_b() && !entity.func_184614_ca().func_190926_b() && entity.func_184614_ca().func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)(heldItemMainhand = entity.func_184614_ca()).func_77973_b()).isManaEmpty(heldItemMainhand)) {
                return Optional.of(heldItemMainhand);
            }
        }
        return Optional.empty();
    }

    public static int getDistributedCost(int cost, int castingTick) {
        int partialCost = castingTick % 20 == 0 ? cost / 2 + cost % 2 : (castingTick % 10 == 0 ? cost / 2 : 0);
        return partialCost;
    }
}

