/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ArtefactCondition
implements LootCondition {
    private final String requiredArtefact;
    private final float chance;

    public ArtefactCondition(String requiredArtefact, float chance) {
        this.requiredArtefact = requiredArtefact;
        this.chance = chance;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        if (rand.nextFloat() <= this.chance) {
            Item artefact = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.requiredArtefact));
            if (artefact == null) {
                Wizardry.logger.warn("Couldn't locate required artefact item in loottable condition!");
            } else if (player != null) {
                return ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)artefact);
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<ArtefactCondition> {
        public Serializer() {
            super(new ResourceLocation("ancientspellcraft", "artefact_condition"), ArtefactCondition.class);
        }

        public void serialize(JsonObject json, ArtefactCondition value, JsonSerializationContext context) {
            json.addProperty("required_artefact", value.requiredArtefact);
            json.addProperty("chance", (Number)Float.valueOf(value.chance));
        }

        public ArtefactCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            String requiredArtefact = JsonUtils.func_151200_h((JsonObject)object, (String)"required_artefact");
            float chance = JsonUtils.func_151221_a((JsonObject)object, (String)"chance", (float)1.0f);
            return new ArtefactCondition(requiredArtefact, chance);
        }
    }
}

