/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class RandomBoundAncientSpell
extends LootFunction {
    private final List<Spell> spells;
    private final float chance;
    private final List<Tier> tiers;

    protected RandomBoundAncientSpell(LootCondition[] conditions, List<Spell> spells, boolean ignoreWeighting, float chance, List<Tier> tiers) {
        super(conditions);
        this.spells = spells;
        this.chance = chance;
        this.tiers = tiers;
    }

    public ItemStack func_186553_a(ItemStack stack, Random random, LootContext context) {
        EntityPlayer player;
        if (random.nextFloat() >= this.chance) {
            return stack;
        }
        SpellProperties.Context spellContext = context.func_186493_a() == null ? SpellProperties.Context.TREASURE : SpellProperties.Context.LOOTING;
        Spell spell = this.pickRandomSpell(stack, random, spellContext, player = (EntityPlayer)context.func_186495_b());
        if (spell == Spells.none) {
            Wizardry.logger.warn("Tried to apply the random_bound_ancient_spell loot function to an item, but no enabled spells matched the criteria specified.");
        }
        WandHelper.setSpells((ItemStack)stack, (Spell[])new Spell[]{spell});
        return stack;
    }

    private Spell pickRandomSpell(ItemStack stack, Random random, SpellProperties.Context spellContext, EntityPlayer player) {
        List possibleSpells = Spell.getSpells(s -> s.applicableForItem(ASItems.ancient_spell_book) && (this.tiers == null || this.tiers.contains(s.getTier())));
        if (this.spells != null && !this.spells.isEmpty()) {
            possibleSpells.retainAll(this.spells);
        }
        possibleSpells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.WANDS}));
        ArrayList<Tier> possibleTiers = new ArrayList<Tier>();
        if (this.tiers == null || this.tiers.isEmpty()) {
            possibleTiers.addAll(Arrays.asList(Tier.values()));
        } else {
            possibleTiers.addAll(this.tiers);
        }
        possibleTiers.removeIf(t -> possibleSpells.stream().noneMatch(s -> s.getTier() == t));
        if (possibleTiers.isEmpty()) {
            return Spells.none;
        }
        Tier tier = (Tier)possibleTiers.get(random.nextInt(possibleTiers.size()));
        possibleSpells.removeIf(s -> s.getTier() != tier);
        possibleSpells.removeIf(s -> s.getElement() != Element.MAGIC);
        if (possibleSpells.isEmpty()) {
            return Spells.none;
        }
        return (Spell)possibleSpells.get(random.nextInt(possibleSpells.size()));
    }

    public static class Serializer
    extends LootFunction.Serializer<RandomBoundAncientSpell> {
        public Serializer() {
            super(new ResourceLocation("ancientspellcraft", "random_bound_ancient_spell"), RandomBoundAncientSpell.class);
        }

        public void serialize(JsonObject object, RandomBoundAncientSpell function, JsonSerializationContext serializationContext) {
            JsonArray jsonarray;
            if (function.spells != null && !function.spells.isEmpty()) {
                jsonarray = new JsonArray();
                for (Spell spell : function.spells) {
                    jsonarray.add((JsonElement)new JsonPrimitive(spell.getRegistryName().toString()));
                }
                object.add("spells", (JsonElement)jsonarray);
            }
            object.addProperty("chance", (Number)Float.valueOf(function.chance));
            if (function.tiers != null && !function.tiers.isEmpty()) {
                jsonarray = new JsonArray();
                for (Tier tier : function.tiers) {
                    jsonarray.add((JsonElement)new JsonPrimitive(tier.getUnlocalisedName()));
                }
                object.add("tiers", (JsonElement)jsonarray);
            }
        }

        public RandomBoundAncientSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditions) {
            ArrayList<Spell> spells = null;
            ArrayList<Tier> tiers = null;
            Object elements = null;
            if (object.has("spells")) {
                spells = new ArrayList<Spell>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"spells", (JsonArray)new JsonArray())) {
                    String string = JsonUtils.func_151206_a((JsonElement)element, (String)"spell");
                    Spell spell = Spell.get((String)string);
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + string + "'");
                    }
                    spells.add(spell);
                }
            }
            boolean ignoreWeighting = JsonUtils.func_151209_a((JsonObject)object, (String)"ignore_weighting", (boolean)false);
            float chance = JsonUtils.func_151221_a((JsonObject)object, (String)"chance", (float)0.0f);
            if (object.has("tiers")) {
                tiers = new ArrayList<Tier>();
                for (JsonElement element : JsonUtils.func_151213_a((JsonObject)object, (String)"tiers", (JsonArray)new JsonArray())) {
                    String string = JsonUtils.func_151206_a((JsonElement)element, (String)"tier");
                    try {
                        tiers.add(Tier.fromName((String)string));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException("Unknown tier '" + string + "'");
                    }
                }
            }
            return new RandomBoundAncientSpell(conditions, spells, ignoreWeighting, chance, tiers);
        }
    }
}

