/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.mixin.ebwizardry;

import com.windanesz.ancientspellcraft.spell.WarlockElementalSpellEffects;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.WandHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemWand.class})
public class MixinItemWand {
    @Shadow(remap=false)
    public Element element;

    @Inject(method={"hitEntity"}, at={@At(value="RETURN")}, remap=false)
    private void modifyItemList(ItemStack stack, EntityLivingBase originalTarget, EntityLivingBase wielder, CallbackInfoReturnable<Boolean> cir) {
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.melee_upgrade);
        if (level > 0) {
            World world = wielder.field_70170_p;
            List targets = EntityUtils.getEntitiesWithinRadius((double)2.0, (double)originalTarget.field_70165_t, (double)originalTarget.field_70163_u, (double)originalTarget.field_70161_v, (World)world, EntityLivingBase.class);
            int remainingTargets = level;
            for (EntityLivingBase target : targets) {
                if (remainingTargets <= 0 || target == wielder || target == null || AllyDesignationSystem.isAllied((EntityLivingBase)wielder, (EntityLivingBase)target)) continue;
                --remainingTargets;
                Vec3d origin = new Vec3d(wielder.field_70165_t, wielder.field_70163_u + (double)wielder.func_70047_e() - 0.25, wielder.field_70161_v);
                Vec3d vec = target.func_174824_e(1.0f).func_178788_d(origin).func_72432_b();
                if (!world.field_72995_K) {
                    float velocity = Math.max(0.4f, 0.4f * ((float)level + (float)((ItemWand)this).tier.ordinal() * 0.5f));
                    target.field_70159_w = vec.field_72450_a * (double)velocity;
                    target.field_70181_x = vec.field_72448_b * (double)0.4f;
                    target.field_70179_y = vec.field_72449_c * (double)velocity;
                    if (target instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                    }
                    double motionX = target.field_70159_w;
                    double motionY = target.field_70181_x;
                    double motionZ = target.field_70179_y;
                    if (wielder instanceof EntityPlayer) {
                        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)wielder)), (float)level);
                    } else {
                        target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)wielder), (float)level);
                    }
                    target.field_70159_w = motionX;
                    target.field_70181_x = motionY;
                    target.field_70179_y = motionZ;
                }
                if (!world.field_72995_K) continue;
                double distance = target.func_70011_f(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(((ItemWand)this).element);
                for (int i = 0; i < 20 + level * 5; ++i) {
                    double x = origin.field_72450_a + world.field_73012_v.nextDouble() - 0.3 + vec.field_72450_a * distance * 0.3;
                    double y = origin.field_72448_b + world.field_73012_v.nextDouble() - 0.3 + vec.field_72448_b * distance * 0.3;
                    double z = origin.field_72449_c + world.field_73012_v.nextDouble() - 0.3 + vec.field_72449_c * distance * 0.3;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST, (Random)world.field_73012_v, (double)x, (double)y, (double)z, (double)1.0, (boolean)false).scale(world.field_73012_v.nextFloat() * 4.0f).clr(colours[1]).fade(colours[2]).time(10).vel(vec.field_72450_a * 0.8, vec.field_72448_b * 0.8, vec.field_72449_c * 0.8).spawn(world);
                }
            }
        }
    }

    @Inject(method={"onAttackEntityEvent"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void onAttackEntityEventMixin(AttackEntityEvent event, CallbackInfo ci) {
        EntityPlayer wielder = event.getEntityPlayer();
        ItemStack stack = wielder.func_184614_ca();
        World world = wielder.field_70170_p;
        if (stack.func_77973_b() instanceof IManaStoringItem) {
            Element element;
            int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.melee_upgrade);
            int mana = ((IManaStoringItem)stack.func_77973_b()).getMana(stack);
            Element element2 = element = stack.func_77973_b() instanceof ItemWand ? ((ItemWand)stack.func_77973_b()).element : Element.MAGIC;
            if (level > 0 && mana > 0) {
                wielder.field_70170_p.func_184134_a(wielder.field_70165_t, wielder.field_70163_u, wielder.field_70161_v, WizardrySounds.ITEM_WAND_MELEE, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                if (wielder.field_70170_p.field_72995_K) {
                    Vec3d origin = new Vec3d(wielder.field_70165_t, wielder.field_70163_u + (double)wielder.func_70047_e() - 0.25, wielder.field_70161_v);
                    Vec3d vec = event.getTarget().func_174824_e(1.0f).func_178788_d(origin).func_72432_b();
                    double distance = event.getTarget().func_70011_f(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
                    int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(element);
                    for (int i = 0; i < 25; ++i) {
                        double x = origin.field_72450_a + world.field_73012_v.nextDouble() - 0.3 + vec.field_72450_a * distance * 0.3;
                        double y = origin.field_72448_b + world.field_73012_v.nextDouble() - 0.3 + vec.field_72448_b * distance * 0.3;
                        double z = origin.field_72449_c + world.field_73012_v.nextDouble() - 0.3 + vec.field_72449_c * distance * 0.3;
                        ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element), (Random)world.field_73012_v, (double)x, (double)y, (double)z, (double)1.0, (boolean)false).scale(world.field_73012_v.nextFloat() * 2.0f).clr(colours[0]).time(5).vel(vec.field_72450_a * 0.8, vec.field_72448_b * 0.8, vec.field_72449_c * 0.8).spawn(world);
                    }
                    Random random = wielder.field_70170_p.field_73012_v;
                    wielder.field_70170_p.func_184134_a(wielder.field_70165_t, wielder.field_70163_u, wielder.field_70161_v, WizardrySounds.ITEM_WAND_MELEE, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                    if (wielder.field_70170_p.field_72995_K) {
                        origin = wielder.func_174824_e(1.0f);
                        Vec3d hit = origin.func_178787_e(wielder.func_70040_Z().func_186678_a((double)wielder.func_70032_d(event.getTarget())));
                        Vec3d vec1 = wielder.func_70040_Z().func_178789_a(90.0f);
                        Vec3d vec2 = wielder.func_70040_Z().func_72431_c(vec1);
                        for (int i = 0; i < 15; ++i) {
                            ParticleBuilder.create((ResourceLocation)WarlockElementalSpellEffects.getElementalParticle(element)).pos(hit).vel(vec1.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)).func_178787_e(vec2.func_186678_a((double)(random.nextFloat() * 0.3f - 0.15f)))).clr(colours[0]).time(8 + random.nextInt(4)).spawn(wielder.field_70170_p);
                        }
                    }
                }
            }
        }
        ci.cancel();
    }
}

